/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ebmwebsourcing.ws.mock.server;

import java.awt.Color;
import java.awt.Desktop;
import java.net.InetAddress;
import java.net.URI;

import javax.swing.JOptionPane;
import javax.swing.UIManager;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;

/**
 *
 * @author nsalatge
 */
public class RecommandationJFrame extends javax.swing.JFrame {

	private Twitter twitter = null;
	private RequestToken requestToken = null;

	/**
	 * Creates new form RecommandationJFrame
	 */
	public RecommandationJFrame(String notif) {
		try{ 
			UIManager.setLookAndFeel(
					UIManager.getSystemLookAndFeelClassName());



			initComponents();

			this.jTextAreaNotif.setText(notif);
			String caller = notif.substring(notif.indexOf("callerPhoneNumber =") + "callerPhoneNumber =".length(), notif.indexOf("\n", notif.indexOf("callerPhoneNumber =")));
			String callee = notif.substring(notif.indexOf("calleePhoneNumber =") + "calleePhoneNumber =".length(), notif.indexOf("\n", notif.indexOf("calleePhoneNumber =")));
			
			if(caller.trim().length() > 4) {
				caller = caller.trim().substring(0, 4) + "...";
			}	
			if(callee.trim().length() > 4) {
				callee = callee.trim().substring(0, 4) + "...";
			}	
			
			String ip = InetAddress.getLocalHost().toString();
			if(ip.length() > 6) {
				ip = ip.substring(0,6) + "...";
			}
			SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String date = parser.format(Calendar.getInstance().getTime());
			this.jTextAreaPredefinedMessage.setText("UC3 Successfull [" + date + "] => " + "from=" + ip + " - " + "caller=" + caller + " - " + "callee=" + callee + " - " + "msg=" + "Recommandation");
			twitter = TwitterFactory.getSingleton();


			try {
				twitter.setOAuthConsumer("Hbc6mMMAVoqrX6aNyq8w", "yS6uWpvgTG81YBlKakgUyreJKJ3R8UHGBPIchS4upQ");
				requestToken = twitter.getOAuthRequestToken();
				this.jLabelUrlClientID.setText(requestToken.getAuthorizationURL());
			} catch(Exception e) {
				JOptionPane.showMessageDialog(this, e.getMessage(), "Error to get authentification url", JOptionPane.ERROR_MESSAGE);
			}
		} catch(Exception e){
			JOptionPane.showMessageDialog(this, e.getMessage(), "Initialization error", JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jLabelNotifReceived = new javax.swing.JLabel();
		jPanelTwitter = new javax.swing.JPanel();
		jLabelActiveClientKey = new javax.swing.JLabel();
		jLabelCopyPin = new javax.swing.JLabel();
		jTextFieldPIN = new javax.swing.JTextField();
		jLabelPredefinedMessage = new javax.swing.JLabel();
		jLabelCustomMessage = new javax.swing.JLabel();
		jComboBoxCustom = new javax.swing.JComboBox();
		jButtonSend = new javax.swing.JButton();
		jLabelUrlClientID = new javax.swing.JLabel();
		jScrollPanePredefinedMessage = new javax.swing.JScrollPane();
		jTextAreaPredefinedMessage = new javax.swing.JTextArea();
		jScrollPaneNotif = new javax.swing.JScrollPane();
		jTextAreaNotif = new javax.swing.JTextArea();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setTitle("Recommandation Service");

		jLabelNotifReceived.setText("Notication Received:");

		jPanelTwitter.setBorder(javax.swing.BorderFactory.createTitledBorder("Would you like send a Tweet on Soceda account?"));

		jLabelActiveClientKey.setText("Active client key to this url:");

		jLabelCopyPin.setText("Copy the pin:");

		jLabelPredefinedMessage.setText("Predefined message:");

		jLabelCustomMessage.setText("Custom message:");

		jComboBoxCustom.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "I love Soceda", "I really love Soceda", "Non mais, allo quoi?", "Thanks to Soceda developers" }));

		jButtonSend.setText("Send");
		jButtonSend.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonSendActionPerformed(evt);
			}
		});

		jLabelUrlClientID.setFont(new java.awt.Font("Tahoma", 2, 11)); // NOI18N
		jLabelUrlClientID.setForeground(new java.awt.Color(0, 153, 255));
		jLabelUrlClientID.setText("jLabel5");
		jLabelUrlClientID.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				jLabelUrlClientIDMouseClicked(evt);
			}
			public void mouseEntered(java.awt.event.MouseEvent evt) {
				jLabelUrlClientIDMouseEntered(evt);
			}
			public void mouseExited(java.awt.event.MouseEvent evt) {
				jLabelUrlClientIDMouseExited(evt);
			}
		});
		jLabelUrlClientID.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(java.awt.event.KeyEvent evt) {
				jLabelUrlClientIDKeyPressed(evt);
			}
		});

		jTextAreaPredefinedMessage.setEditable(false);
		jTextAreaPredefinedMessage.setColumns(20);
		jTextAreaPredefinedMessage.setRows(5);
		jScrollPanePredefinedMessage.setViewportView(jTextAreaPredefinedMessage);

		javax.swing.GroupLayout jPanelTwitterLayout = new javax.swing.GroupLayout(jPanelTwitter);
		jPanelTwitter.setLayout(jPanelTwitterLayout);
		jPanelTwitterLayout.setHorizontalGroup(
				jPanelTwitterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelTwitterLayout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanelTwitterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jScrollPanePredefinedMessage)
								.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelTwitterLayout.createSequentialGroup()
										.addGap(0, 0, Short.MAX_VALUE)
										.addComponent(jButtonSend))
										.addGroup(jPanelTwitterLayout.createSequentialGroup()
												.addComponent(jLabelCustomMessage)
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
												.addComponent(jComboBoxCustom, 0, 782, Short.MAX_VALUE))
												.addGroup(jPanelTwitterLayout.createSequentialGroup()
														.addGroup(jPanelTwitterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
																.addGroup(jPanelTwitterLayout.createSequentialGroup()
																		.addComponent(jLabelCopyPin)
																		.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																		.addComponent(jTextFieldPIN, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE))
																		.addComponent(jLabelPredefinedMessage))
																		.addGap(0, 0, Short.MAX_VALUE))
																		.addGroup(jPanelTwitterLayout.createSequentialGroup()
																				.addComponent(jLabelActiveClientKey)
																				.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
																				.addComponent(jLabelUrlClientID, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
																				.addContainerGap())
				);
		jPanelTwitterLayout.setVerticalGroup(
				jPanelTwitterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelTwitterLayout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanelTwitterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
								.addComponent(jLabelActiveClientKey)
								.addComponent(jLabelUrlClientID))
								.addGap(18, 18, 18)
								.addGroup(jPanelTwitterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
										.addComponent(jLabelCopyPin)
										.addComponent(jTextFieldPIN, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
										.addComponent(jLabelPredefinedMessage)
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(jScrollPanePredefinedMessage, javax.swing.GroupLayout.PREFERRED_SIZE, 68, javax.swing.GroupLayout.PREFERRED_SIZE)
										.addGap(8, 8, 8)
										.addGroup(jPanelTwitterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
												.addComponent(jLabelCustomMessage)
												.addComponent(jComboBoxCustom, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
												.addComponent(jButtonSend)
												.addContainerGap(44, Short.MAX_VALUE))
				);

		jScrollPaneNotif.setEnabled(false);

		jTextAreaNotif.setEditable(false);
		jTextAreaNotif.setColumns(20);
		jTextAreaNotif.setRows(5);
		jScrollPaneNotif.setViewportView(jTextAreaNotif);

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
						.addContainerGap()
						.addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
								.addComponent(jScrollPaneNotif)
								.addComponent(jPanelTwitter, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
								.addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
										.addComponent(jLabelNotifReceived)
										.addGap(0, 0, Short.MAX_VALUE)))
										.addContainerGap())
				);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jLabelNotifReceived)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addComponent(jScrollPaneNotif, javax.swing.GroupLayout.PREFERRED_SIZE, 210, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addGap(18, 18, 18)
						.addComponent(jPanelTwitter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
				);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButtonSendActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSendActionPerformed
		try {
			AccessToken accessToken = twitter.getOAuthAccessToken(requestToken, this.jTextFieldPIN.getText());
			String msg = this.jTextAreaPredefinedMessage.getText() + " => " + this.jComboBoxCustom.getSelectedItem();
			if(msg.length() > 140) {
				msg = msg.substring(0, 140);
			}
			String tweet = this.jTextAreaPredefinedMessage.getText() + " - " + this.jComboBoxCustom.getSelectedItem();
			twitter.updateStatus(tweet);
			JOptionPane.showMessageDialog(this, "tweet sent with content:" + tweet, "Tweet succesfully sent", JOptionPane.PLAIN_MESSAGE);
		} catch (TwitterException e) {
			JOptionPane.showMessageDialog(this, e.getMessage(), "Error to send tweet", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jButtonSendActionPerformed

	private void jLabelUrlClientIDKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jLabelUrlClientIDKeyPressed
		// do nothing
	}//GEN-LAST:event_jLabelUrlClientIDKeyPressed

	private void jLabelUrlClientIDMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabelUrlClientIDMouseClicked
		try {
			Desktop.getDesktop().browse(URI.create(this.jLabelUrlClientID.getText()));
		} catch (Exception e) {
			JOptionPane.showMessageDialog(this, e.getMessage(), "Error to browe tweeter authentification url", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jLabelUrlClientIDMouseClicked

	private void jLabelUrlClientIDMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabelUrlClientIDMouseEntered
		this.jLabelUrlClientID.setForeground(new Color(0,0,255));
	}//GEN-LAST:event_jLabelUrlClientIDMouseEntered

	private void jLabelUrlClientIDMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabelUrlClientIDMouseExited
		this.jLabelUrlClientID.setForeground(new Color(0,153,255));
	}//GEN-LAST:event_jLabelUrlClientIDMouseExited

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		/* Set the Nimbus look and feel */
		//<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
		/* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
		 * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
		 */
		try {
			for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					javax.swing.UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (ClassNotFoundException ex) {
			java.util.logging.Logger.getLogger(RecommandationJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (InstantiationException ex) {
			java.util.logging.Logger.getLogger(RecommandationJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (IllegalAccessException ex) {
			java.util.logging.Logger.getLogger(RecommandationJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (javax.swing.UnsupportedLookAndFeelException ex) {
			java.util.logging.Logger.getLogger(RecommandationJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		}
		//</editor-fold>

		/* Create and display the form */
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new RecommandationJFrame("uniqueId = \n" + 
						"sequenceNumber = \n" + 
						"timeStamp = \n" + 
						"callerPhoneNumber = 0607080910\n" + 
						"calleePhoneNumber = orangeLabsTaxiUC:calleePhoneNumber\n" + 
						"message = ?\n").setVisible(true);
			}
		});
	}
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButtonSend;
	private javax.swing.JComboBox jComboBoxCustom;
	private javax.swing.JLabel jLabelActiveClientKey;
	private javax.swing.JLabel jLabelCopyPin;
	private javax.swing.JLabel jLabelCustomMessage;
	private javax.swing.JLabel jLabelNotifReceived;
	private javax.swing.JLabel jLabelPredefinedMessage;
	private javax.swing.JLabel jLabelUrlClientID;
	private javax.swing.JPanel jPanelTwitter;
	private javax.swing.JScrollPane jScrollPaneNotif;
	private javax.swing.JScrollPane jScrollPanePredefinedMessage;
	private javax.swing.JTextArea jTextAreaNotif;
	private javax.swing.JTextArea jTextAreaPredefinedMessage;
	private javax.swing.JTextField jTextFieldPIN;
	// End of variables declaration//GEN-END:variables
}
