package com.ebmwebsourcing.ws.mock.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;

public class RecommandationNotifier implements NotificationConsumerDecorator {


	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class
					);
		} catch(Exception e) {
			// do nothing
		}
	}

	private boolean ui = false;
	private List<EJaxbNotify> notifies = new ArrayList<EJaxbNotify>();

	public RecommandationNotifier(boolean ui) {
		this.ui = ui;
	}


	@Override
	public void notify(EJaxbNotify notify) {
		try {
			notifies.add(notify);

			Object payload = notify.getNotificationMessage().get(0).getMessage().getAny();

			String m = "RECOMMANDATION RECEIVED:\n";
			if(payload instanceof Element) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.adoptNode((Element) payload));
				for(int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); i++) {
					m = m +
							doc.getDocumentElement().getChildNodes().item(i).getLocalName() + " = " + doc.getDocumentElement().getChildNodes().item(i).getTextContent() + "\n" ;
				}
			}

			System.out.println("ui = " + ui);
			System.out.println(m);

			if(ui) {
				RecommandationJFrame frame = new RecommandationJFrame(m);
				frame.setVisible(true);
			}


			// send to twitter
			// The factory instance is re-useable and thread safe.
//			if(ui) {
//				Twitter twitter = TwitterFactory.getSingleton();
//				twitter.setOAuthConsumer("Hbc6mMMAVoqrX6aNyq8w", "yS6uWpvgTG81YBlKakgUyreJKJ3R8UHGBPIchS4upQ");
//				RequestToken requestToken = twitter.getOAuthRequestToken();
//				AccessToken accessToken = null;
//				BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
//				while (null == accessToken) {
//
//					System.out.println("Open the following URL and grant access to your account:");
//					System.out.println(requestToken.getAuthorizationURL());
//					System.out.print("Enter the PIN(if aviailable) or just hit enter.[PIN]:");
//					String pin = br.readLine();
//					try{
//						if(pin.length() > 0){
//							accessToken = twitter.getOAuthAccessToken(requestToken, pin);
//						}else{
//							accessToken = twitter.getOAuthAccessToken();
//						}
//					} catch (TwitterException te) {
//						if(401 == te.getStatusCode()){
//							System.out.println("Unable to get the access token.");
//						}else{
//							te.printStackTrace();
//						}
//					}
//				}
				//persist to the accessToken for future reference.
				//storeAccessToken((int) twitter.verifyCredentials().getId() , accessToken);

//				twitter.updateStatus("Test the twitter API wihtout oa");
//			}
		} catch (Exception e) {
			// do nothing
			e.printStackTrace();
		}

	}


	public List<EJaxbNotify> getNotifications() {
		return this.notifies;
	}
}
