<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright (c) 2011 EBM Websourcing.
  All rights reserved. This program and the accompanying materials
  are made available under the terms of the GNU Lesser Public License v3.0
  which accompanies this distribution, and is available at
  http://www.gnu.org/licenses/lgpl.html
  
  Contributors:
      EBM Websourcing - initial API and implementation
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" />
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()">
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="@createInstance">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="createInstance">
						<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="createInstance">
						<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@initiate">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="initiate">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="initiate">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@parallel">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="parallel">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="parallel">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@isolated">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="isolated">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="isolated">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@exitOnStandardFault">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="exitOnStandardFault">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="exitOnStandardFault">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@suppressJoinFailure">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="suppressJoinFailure">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="suppressJoinFailure">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@validate">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="validate">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="validate">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@keepSrcElementName">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="keepSrcElementName">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="keepSrcElementName">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@ignoreMissingFromData">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="ignoreMissingFromData">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="ignoreMissingFromData">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@mustUnderstand">
		<xsl:choose>
			<xsl:when test=".='yes'">
				<xsl:attribute name="mustUnderstand">
					<xsl:text>YES</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test=".='no'">
				<xsl:attribute name="mustUnderstand">
					<xsl:text>NO</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*">
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>

