/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.properties;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.junit.Test;

public class PropertiesHelperTest {
    private static final String PROPA_RSV_VALUE = "value";
    private static final String PROPB_RSV_VALUE = "/value/value2";
    private static final String PROPC_RSV_VALUE = "/value/value2/value";
    private static final String PROPD_RSV_VALUE = "value3//value/value2/value /value/value2";
    private static final String PROPE_RSV_VALUE = "value3//value/value2/value /value/value2value3//value/value2/value /value/value2";
    private static final String PROPL_RSV_VALUE = "value17";
    private static final String PROPM_RSV_VALUE = "value2//value/value2/valuevalue4 /value3";
    private static final String PROPN_RSV_VALUE = "/value/value2/value3//value/value2/value /value/value2value3//value/value2/value /value/value2";
    private static final String PROPO_RSV_VALUE = "value3//value/value2/value /value/value2";
    private static final String PROPP_RSV_VALUE = "${test.propP}";
    private static final String PROPX_RSV_VALUE = "value8${test.propP}";
    private static final String PROPY_RSV_VALUE = "value8${test.propP}/value7";
    private static final String PROP_VALUES_WHITESPACEDELIMITER = "java.util.logging.ConsoleHandler org.ow2.petals.commons.logger.PetalsFileHandler org.ow2.petals.commons.logger.TestingFileHandler";
    private static final String PROP_VALUES_COMMADELIMITER = "java.util.logging.ConsoleHandler, org.ow2.petals.commons.logger.PetalsFileHandler ,org.ow2.petals.commons.logger.TestingFileHandler";

    @Test
    public void testResolvePropertiesOK() throws Exception {
        Properties properties = new Properties();
        PropertiesHelperTest.addCorrectPropData(properties);
        PropertiesHelper.resolveProperties((Properties)properties, (Properties)properties);
        Assert.assertEquals((String)properties.getProperty("test.propA"), (String)PROPA_RSV_VALUE);
        Assert.assertEquals((String)properties.getProperty("test.propB"), (String)PROPB_RSV_VALUE);
        Assert.assertEquals((String)properties.getProperty("test.propC"), (String)PROPC_RSV_VALUE);
        Assert.assertEquals((String)properties.getProperty("test.propD"), (String)"value3//value/value2/value /value/value2");
        Assert.assertEquals((String)properties.getProperty("test.propE"), (String)PROPE_RSV_VALUE);
    }

    @Test
    public void testResolvePropertiesWithUnresolvableProperties() throws Exception {
        Properties properties = new Properties();
        PropertiesHelperTest.addUnexistingPropData(properties);
        PropertiesHelper.resolveProperties((Properties)properties, (Properties)properties);
        Assert.assertEquals((String)properties.getProperty("test.propX"), (String)PROPX_RSV_VALUE);
        Assert.assertEquals((String)properties.getProperty("test.propY"), (String)PROPY_RSV_VALUE);
    }

    @Test
    public void testResolvePropertiesWithALoop() {
        Properties properties = new Properties();
        PropertiesHelperTest.addLoopPropData(properties);
        try {
            PropertiesHelper.resolveProperties((Properties)properties, (Properties)properties);
            Assert.fail();
        }
        catch (PropertiesException pe) {
            Assert.assertEquals((String)"There is a place holder loop in the specified properties", (String)pe.getMessage());
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testResolvePropertiesWithOtherProperties() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        Properties propertiesToResolve = new Properties();
        this.addCorrectPropData2(propertiesToResolve);
        PropertiesHelper.resolveProperties((Properties)propertiesToResolve, (Properties)propertiesToUse);
        Assert.assertEquals((String)propertiesToResolve.getProperty("test.propL"), (String)PROPL_RSV_VALUE);
        Assert.assertEquals((String)propertiesToResolve.getProperty("test.propM"), (String)PROPM_RSV_VALUE);
        Assert.assertEquals((String)propertiesToResolve.getProperty("test.propN"), (String)PROPN_RSV_VALUE);
        Assert.assertEquals((String)propertiesToResolve.getProperty("test.propO"), (String)"value3//value/value2/value /value/value2");
    }

    @Test
    public void testResolveMapWithNoExceptionOK() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        HashMap<String, String> map = new HashMap<String, String>();
        PropertiesHelperTest.addCorrectMapData(map);
        PropertiesHelper.resolveMapWithNoException(map, (Properties)propertiesToUse);
        Assert.assertEquals((String)((String)map.get("test.propL")), (String)PROPL_RSV_VALUE);
        Assert.assertEquals((String)((String)map.get("test.propM")), (String)PROPM_RSV_VALUE);
        Assert.assertEquals((String)((String)map.get("test.propN")), (String)PROPN_RSV_VALUE);
        Assert.assertEquals((String)((String)map.get("test.propO")), (String)"value3//value/value2/value /value/value2");
    }

    @Test
    public void testResolveMapWithNoExceptionWithALoop() {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addLoopPropData(propertiesToUse);
        HashMap<String, String> map = new HashMap<String, String>();
        PropertiesHelperTest.addLoopMapData(map);
        PropertiesHelper.resolveMapWithNoException(map, (Properties)propertiesToUse);
    }

    @Test
    public void testResolveMapOK() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        HashMap<String, String> map = new HashMap<String, String>();
        PropertiesHelperTest.addCorrectMapData(map);
        PropertiesHelper.resolveMap(map, (Properties)propertiesToUse);
        Assert.assertEquals((String)((String)map.get("test.propL")), (String)PROPL_RSV_VALUE);
        Assert.assertEquals((String)((String)map.get("test.propM")), (String)PROPM_RSV_VALUE);
        Assert.assertEquals((String)((String)map.get("test.propN")), (String)PROPN_RSV_VALUE);
        Assert.assertEquals((String)((String)map.get("test.propO")), (String)"value3//value/value2/value /value/value2");
    }

    @Test
    public void testResolveMapWithALoop() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addLoopPropData(propertiesToUse);
        HashMap<String, String> map = new HashMap<String, String>();
        PropertiesHelperTest.addLoopMapData(map);
        try {
            PropertiesHelper.resolveMap(map, (Properties)propertiesToUse);
            Assert.fail();
        }
        catch (PropertiesException pe) {
            Assert.assertEquals((String)"There is a place holder loop in the specified properties", (String)pe.getMessage());
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testResolveStringWithNoPlaceHolder() {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        PropertiesHelperTest.addLoopPropData(propertiesToUse);
        PropertiesHelperTest.addUnexistingPropData(propertiesToUse);
        try {
            String resolvedStr = PropertiesHelper.resolveString((String)"no_place_holder", (Properties)propertiesToUse);
            Assert.assertEquals((String)"no_place_holder", (String)resolvedStr);
        }
        catch (PropertiesException Pe) {
            Assert.fail();
        }
    }

    @Test
    public void testResolveStringWithNoRecursion() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        String resolvedStr = PropertiesHelper.resolveString((String)"${test.propA}", (Properties)propertiesToUse);
        Assert.assertEquals((String)PROPA_RSV_VALUE, (String)resolvedStr);
    }

    @Test
    public void testResolveStringWithARecursion() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        String resolvedStr = PropertiesHelper.resolveString((String)"${test.propB}", (Properties)propertiesToUse);
        Assert.assertEquals((String)PROPB_RSV_VALUE, (String)resolvedStr);
    }

    @Test
    public void testResolveStringWithMoreThanOneRecursion() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        String resolvedStr = PropertiesHelper.resolveString((String)"${test.propC}", (Properties)propertiesToUse);
        Assert.assertEquals((String)PROPC_RSV_VALUE, (String)resolvedStr);
    }

    @Test
    public void testResolveStringWithSeveralRecursions0() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        String resolvedStr = PropertiesHelper.resolveString((String)"${test.propD}", (Properties)propertiesToUse);
        Assert.assertEquals((String)"value3//value/value2/value /value/value2", (String)resolvedStr);
    }

    @Test
    public void testResolveStringWithSeveralRecursions1() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        String resolvedStr = PropertiesHelper.resolveString((String)"${test.propE}", (Properties)propertiesToUse);
        Assert.assertEquals((String)PROPE_RSV_VALUE, (String)resolvedStr);
    }

    @Test
    public void testResolveStringWithSeveralRecursions2() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addCorrectPropData(propertiesToUse);
        String resolvedStr = PropertiesHelper.resolveString((String)"${test.propE}${test.propC}", (Properties)propertiesToUse);
        Assert.assertEquals((String)"value3//value/value2/value /value/value2value3//value/value2/value /value/value2/value/value2/value", (String)resolvedStr);
    }

    @Test
    public void testResolveStringAnUnresolvableProperty() throws Exception {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addUnexistingPropData(propertiesToUse);
        String resolvedStr = PropertiesHelper.resolveString((String)"${test.propX}", (Properties)propertiesToUse);
        Assert.assertEquals((String)PROPX_RSV_VALUE, (String)resolvedStr);
    }

    @Test
    public void testResolveStringAPropertyLoop() {
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addLoopPropData(propertiesToUse);
        try {
            PropertiesHelper.resolveString((String)"${test.propI}", (Properties)propertiesToUse);
            Assert.fail();
        }
        catch (PropertiesException pe) {
            Assert.assertEquals((String)"There is a place holder loop in the specified properties", (String)pe.getMessage());
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testContainsPlaceHolderWithAPlaceHolder() throws Exception {
        Assert.assertTrue((boolean)PropertiesHelper.containsPlaceHolder((String)"value2/${test.propC}value4 /value3"));
    }

    @Test
    public void testContainsPlaceHolderWithNoPlaceHolder() throws Exception {
        Assert.assertTrue((!PropertiesHelper.containsPlaceHolder((String)"value2/value4 /value3") ? 1 : 0) != 0);
    }

    private static final void addCorrectMapData(Map<String, String> map) {
        map.put("test.propL", PROPL_RSV_VALUE);
        map.put("test.propM", "value2/${test.propC}value4 /value3");
        map.put("test.propN", "${test.propB}/${test.propE}");
        map.put("test.propO", "${test.propD}");
    }

    private static final void addCorrectPropData(Properties properties) {
        properties.put("test.propA", PROPA_RSV_VALUE);
        properties.put("test.propB", "/${test.propA}/value2");
        properties.put("test.propC", "${test.propB}/${test.propA}");
        properties.put("test.propD", "value3/${test.propC} ${test.propB}");
        properties.put("test.propE", "${test.propD}${test.propD}");
    }

    private static final void addLoopMapData(Map<String, String> map) {
        map.put("test.propJ", "${test.propI}value5value6");
    }

    private void addCorrectPropData2(Properties propertiesToResolve) {
        propertiesToResolve.put("test.propL", PROPL_RSV_VALUE);
        propertiesToResolve.put("test.propM", "value2/${test.propC}value4 /value3");
        propertiesToResolve.put("test.propN", "${test.propB}/${test.propE}");
        propertiesToResolve.put("test.propO", "${test.propD}");
    }

    private static final void addLoopPropData(Properties propertiesToUse) {
        propertiesToUse.put("test.propI", "value4${test.propJ}value5");
        propertiesToUse.put("test.propJ", "${test.propK}value5value6");
        propertiesToUse.put("test.propK", "${test.propJ}");
    }

    private static final void addUnexistingPropData(Properties propertiesToUse) {
        propertiesToUse.put("test.propX", PROPX_RSV_VALUE);
        propertiesToUse.put("test.propY", "${test.propX}/value7");
    }

    private static final InputStream addCorrectDataForInputStream() {
        byte[] testByteArray = "test = ${test.propIn}".getBytes();
        return new ByteArrayInputStream(testByteArray);
    }

    private static final InputStream addBadDataForInputStream() {
        byte[] testByteArray = "test".getBytes();
        return new ByteArrayInputStream(testByteArray);
    }

    private static final void addResolvedProperties(Properties propertiesToUse) {
        propertiesToUse.put("test.propIn", PROPA_RSV_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolvePropertiesForInputStream() throws Exception {
        InputStream inputStreamToResolve = PropertiesHelperTest.addCorrectDataForInputStream();
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addResolvedProperties(propertiesToUse);
        ByteArrayInputStream inputStreamResolved = null;
        try {
            inputStreamResolved = PropertiesHelper.resolvePropertiesForInputStream((InputStream)inputStreamToResolve, (Properties)propertiesToUse);
            Properties propertiesResolved = new Properties();
            propertiesResolved.load(inputStreamResolved);
            Assert.assertEquals((String)propertiesResolved.getProperty("test"), (String)PROPA_RSV_VALUE);
        }
        finally {
            IOHelper.close((Closeable)inputStreamToResolve);
            IOHelper.close((Closeable)inputStreamResolved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolvePropertiesWithBadInputStream() throws Exception {
        InputStream inputStreamToResolve = PropertiesHelperTest.addBadDataForInputStream();
        Properties propertiesToUse = new Properties();
        PropertiesHelperTest.addResolvedProperties(propertiesToUse);
        ByteArrayInputStream inputStreamResolved = null;
        try {
            inputStreamResolved = PropertiesHelper.resolvePropertiesForInputStream((InputStream)inputStreamToResolve, (Properties)propertiesToUse);
            Properties propertiesResolved = new Properties();
            propertiesResolved.load(inputStreamResolved);
            Assert.assertEquals((String)propertiesResolved.getProperty("test"), (String)"");
        }
        finally {
            IOHelper.close((Closeable)inputStreamToResolve);
            IOHelper.close((Closeable)inputStreamResolved);
        }
    }

    @Test
    public void testFlattenPropertiesWithoutDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("name1", "value1");
        properties.setProperty("name2", "value2");
        properties.setProperty("name3", "value3");
        properties.setProperty("name4", "value4");
        properties.setProperty("name4", "value5");
        Properties expected = new Properties();
        expected.put("name1", "value1");
        expected.put("name2", "value2");
        expected.put("name3", "value3");
        expected.put("name4", "value5");
        Assert.assertEquals((Object)expected, (Object)PropertiesHelper.flattenProperties((Properties)properties));
    }

    @Test
    public void testFlattenPropertiesWithDefaultProperties() {
        Properties defaultProperties = new Properties();
        Properties properties = new Properties(defaultProperties);
        defaultProperties.setProperty("name1", "value1");
        defaultProperties.setProperty("name2", "value2");
        defaultProperties.setProperty("name4", "value5");
        properties.setProperty("name3", "value3");
        properties.setProperty("name4", "value4");
        Properties expected = new Properties();
        expected.put("name1", "value1");
        expected.put("name2", "value2");
        expected.put("name3", "value3");
        expected.put("name4", "value4");
        Assert.assertEquals((Object)expected, (Object)PropertiesHelper.flattenProperties((Properties)properties));
    }

    @Test
    public void testParsePropertyValues() {
        String[] values = PropertiesHelper.parsePropertyValues((String)PROP_VALUES_WHITESPACEDELIMITER);
        Assert.assertEquals((String)values[0], (String)"java.util.logging.ConsoleHandler");
        Assert.assertEquals((String)values[1], (String)"org.ow2.petals.commons.logger.PetalsFileHandler");
        Assert.assertEquals((String)values[2], (String)"org.ow2.petals.commons.logger.TestingFileHandler");
        String[] values2 = PropertiesHelper.parsePropertyValues((String)PROP_VALUES_COMMADELIMITER);
        Assert.assertEquals((String)values2[0], (String)"java.util.logging.ConsoleHandler");
        Assert.assertEquals((String)values2[1], (String)"org.ow2.petals.commons.logger.PetalsFileHandler");
        Assert.assertEquals((String)values2[2], (String)"org.ow2.petals.commons.logger.TestingFileHandler");
    }
}

