/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.cep.launcher.tasks;

import java.util.List;

/**
 * 
 * Created on 13 févr. 08
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * @since
 * 
 */
public abstract class Task {

    public final static int SHUTDOWN_CODE = 0;

    public final static int ERROR_CODE = -1;

    public final static int OK_CODE = 1;
    
    public final static int INVALID_ARGS = -2;
    

    private String name;

    private String shortcut;

    private String description;

    /**
     * 
     * @param args
     */
    public int process(List<String> args) {
        int result = OK_CODE;
        if (!validateArgs(args)) {
            result = INVALID_ARGS;
        } else {
            result = doProcess(args);
        }
        return result;
    }
    
    protected abstract int doProcess(List<String> args);
    
    /**
     * 
     * @param args
     * @return
     */
    public boolean validateArgs(List<String> args) {
        return true;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortcut() {
        return shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String prefix = shortcut + ", " + name;
        String blank = "";
        int length = 25 - prefix.length();
        for (int i = 0; i < length; i++) {
            blank += " ";
        }
        return prefix + blank + description;
    }
}
