/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

package com.ebmwebsourcing.cep.server;

import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

import com.ebmwebsourcing.cep.server.Cep.CEP_MODE;
import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import engine.cep.admin.api.SubscriptionsRequired;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;


/**
 * This class was generated by Apache CXF 2.5.0-easy
 * 2012-01-17T15:16:49.423+01:00
 * Generated source version: 2.5.0-easy
 * 
 */

@javax.jws.WebService(serviceName = "CloudManagementService", portName = "CloudManagementSOAPEndpoint", targetNamespace = "http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation = "wsdl/SeaCloud.wsdl", endpointInterface = "seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class CepManagementImpl implements CloudManagement {

	private static final Logger LOG = Logger.getLogger(CepManagementImpl.class.getName());


	private String cepAddress;
	private Cep.CEP_MODE mode;
	private int cpt = 0;
	private boolean first = true;

	private SOAPSender sender = new SOAPSender();
	private String SeaCloud_EndpointAddressToSubscribe = null;
	private DataManagerClientImplSOAP easierGovClient; 

	private EPServiceProvider epService = null;


	public CepManagementImpl(String cepAddress) throws CloudManagementException {
		this.cepAddress = cepAddress;
		this.mode = CEP_MODE.ESPER;

		System.setProperty(DOMImplementationRegistry.PROPERTY,
				"com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
		Configuration config = new Configuration();
		config.getEngineDefaults().getLogging().setEnableQueryPlan(true);
		config.getEngineDefaults().getLogging().setEnableExecutionDebug(true);
		config.getEngineDefaults().getLogging().setEnableTimerDebug(false);
		epService = EPServiceProviderManager.getDefaultProvider(config);
	}

	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
			throws org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault,
			org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault,
			org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault,
			org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault,
			org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault,
			org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault,
			org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault,
			org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault,
			org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault,
			org.oasis_open.docs.wsn.bw_2.InvalidFilterFault,
			org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault,
			org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault {
		throw new UnsupportedOperationException();
	}

	public void notify(EJaxbNotify notify) {
		LOG.info("Executing operation notify on cep");
		System.out.println(notify);
		cpt++;
		try {

			Document event = getEventInNotify(notify);
			System.out.println("****** Notify on CEP: \n" + XMLPrettyPrinter.prettyPrint(event));
			this.epService.getEPRuntime().sendEvent(event);

			System.out.println("****** NUMBER OF NOTIFICATION RECEIVED ON CEP:" + cpt);	
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}

	private Document getEventInNotify(EJaxbNotify notify) throws WsnbException {
		Document doc = null;
		try {
			for(EJaxbNotificationMessageHolderType msgh: notify.getNotificationMessage()) {
				Element elmt = (Element) msgh.getMessage().getAny();
				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.adoptNode(elmt));
			}
		} catch (ParserConfigurationException e) {
			throw new WsnbException(e);
		}
		return doc;
	}

	@Override
	public AddResourcesDescriptorResponse addResourcesDescriptor(
			AddResourcesDescriptor parameters) throws CloudManagementException {
		AddResourcesDescriptorResponse response = new AddResourcesDescriptorResponse();
		try {
			List<URL> easierGovAdresses = new ArrayList<URL>();
			for (Resource rsc : parameters.getResourcesDescriptor()
					.getResource()) {
				if (ResourceType.GOVERNANCE.equals(rsc.getType())) {
					easierGovAdresses.add(new URL(rsc.getAddress()));
				}
			}

			URL easierGovAdress = null;
			if (easierGovAdresses.size() > 0) {
				easierGovAdress = new URL(easierGovAdresses.get(0).toString().replace("eventManager", "dataManager"));
				System.out.println("easierGovAdress = " + easierGovAdress);
				this.easierGovClient = new DataManagerClientImplSOAP(easierGovAdress.toString());
				System.out.println("Governance is now connected to cep");
			}
			
			
		} catch (MalformedURLException e) {
			throw new CloudManagementException(e.getMessage(), e);
		}
		return response;
	}

	@Override
	public String addStatement(String arg0, String arg1)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public AddStatementResponseWithActions addStatementWithActions(
			AddStatementWithActions parameters) throws CloudManagementException {
		AddStatementResponseWithActions res = new AddStatementResponseWithActions();

		try {
			cpt = 0;
			System.out.println("RECIEVED CEP RULE TO DEPLOY ON CEP");



			SubscriptionsRequired subscriptionsRequired = parameters
					.getSubscriptionsRequired();

			List<SubscriptionsRequired.Entry> entries = subscriptionsRequired
					.getEntry();
			System.out.println("entries: " + entries);




			// inject CEP rules in esper engine

			// 1- find xsd in easiergov corresponding to event
			if(this.easierGovClient != null) {
				for (SubscriptionsRequired.Entry entry : entries) {
					if(entry.getCorrespondingEvent() != null) {
						GetElement request = new GetElement();
						request.setIdElement(entry.getCorrespondingEvent());
						GetElementResponse response = this.easierGovClient.getElement(request);
						
						String bufferSchema = null;
						if(response.getAny() instanceof EJaxbSchema) {
							bufferSchema = XMLPrettyPrinter.prettyPrint(SOAJAXBContext.getInstance().unmarshallAnyElement(response.getAny()));
						} else if(response.getAny() instanceof Element) {
							Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
							doc.appendChild(doc.adoptNode((Element) response.getAny()));
							bufferSchema = XMLPrettyPrinter.prettyPrint(doc);
						}
						String schemaText = XMLPrettyPrinter.prettyPrint(DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(bufferSchema.getBytes())));

						// 2 - add new eventType
						System.out.println("******** CEP number of subscription required: " + entries.size());

						ConfigurationEventTypeXMLDOM eventcfg = new ConfigurationEventTypeXMLDOM();
						eventcfg.setXPathPropertyExpr(true);
						System.out.println("******** CEP entry.getCorrespondingEvent() = " + entry.getCorrespondingEvent());
						eventcfg.setRootElementName(entry.getCorrespondingEvent().getLocalPart());
						eventcfg.setSchemaText(schemaText);
						epService.getEPAdministrator().getConfiguration().addEventType(entry.getCorrespondingEvent().getLocalPart(), eventcfg);
					}
				}
			} else {
				LOG.warning("Governance is not connected to CEP !!!");
			}

			// 3 - Set rules
			EPStatement statement = epService.getEPAdministrator().createEPL(parameters.getStatement());
			statement.addListener(new EventListener(this.SeaCloud_EndpointAddressToSubscribe, this.cepAddress, parameters.getAction(), parameters.getNamespaceOfEventTypes(), this.easierGovClient));
			System.out.println("statement = " + statement);


			// 4 - Send subscription to primitive event
			for (SubscriptionsRequired.Entry entry : entries) {

				QName topicUsed = entry.getTopic();
				System.out.println("topicUsed: " + topicUsed);
				SeaCloud_EndpointAddressToSubscribe = entry.getEndpointAddressToSubscribe();

				AdminManagementClientSOAP clientSubscribe = new AdminManagementClientSOAP(
						SeaCloud_EndpointAddressToSubscribe);


				com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe payload = WSNHelper.createSubscription(
						this.cepAddress, topicUsed, entry.getCorrespondingEvent());

				Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(
						payload);
				if(topicUsed != null) {

					EJaxbSubscribe not = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribe.class);

					doc = SOAJAXBContext.getInstance().unmarshallAnyElement(not);
				}

				System.out.println("CEP SUBSCRIBE on topic: " + topicUsed);
				System.out.println("CEP SUBSCRIBE :\n" + XMLPrettyPrinter.prettyPrint(doc));
				EJaxbSubscribeResponse response = (EJaxbSubscribeResponse) clientSubscribe.subscribe(doc);

				System.out.println("CEP SUBSCRIBE ON " + topicUsed + " => OK");

			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new CloudManagementException(e.getMessage(), e);
		} 
		return res;
	}

	@Override
	public BindResponse bind(Bind arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public String deleteStatement(String arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public String expose(QName arg0, String arg1)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(QName arg0)
			throws ResourceUnavailableFault, ResourceUnknownFault,
			InvalidResourcePropertyQNameFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public String getStatementById(String arg0) throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public ListAllStatementsResponse listAllStatements(ListAllStatements arg0)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public ProxifyResponse proxify(Proxify arg0)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}

	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe arg0)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public String updateStatement(String arg0, String arg1)
			throws CloudManagementException {
		throw new UnsupportedOperationException();
	}


}
