/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eventcloud.mocked.server;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.eventcloud.mocked.server.TopicKey;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbFilterType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

@WebService(serviceName="CloudManagementService", portName="CloudManagementSOAPEndpoint", targetNamespace="http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation="wsdl/SeaCloud.wsdl", endpointInterface="seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class EventCloudMockedManagementImpl
implements CloudManagement {
    private static final Logger LOG = Logger.getLogger(EventCloudMockedManagementImpl.class.getName());
    private String eventcloudAddress;
    private int cpt = 0;
    private SOAPSender sender = new SOAPSender();
    private Map<TopicKey, List<URI>> clientsMap = new HashMap<TopicKey, List<URI>>();

    public EventCloudMockedManagementImpl(String cepAddress) throws CloudManagementException {
        this.eventcloudAddress = cepAddress;
    }

    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault, UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault, UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault, InvalidProducerPropertiesExpressionFault {
        EJaxbSubscribeResponse response = new EJaxbSubscribeResponse();
        try {
            URI clientEPR = URI.create(subscribeRequest.getConsumerReference().getAddress().getValue());
            System.out.println("Event cloud (subscribe) =>\n" + XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)subscribeRequest)));
            System.out.println("Event cloud (subscribe) => client EPR: " + clientEPR);
            System.out.println("Event cloud (subscribe) => filter: " + subscribeRequest.getFilter().getAny());
            EJaxbTopicExpressionType texp = null;
            for (Object obj : subscribeRequest.getFilter().getAny()) {
                JAXBElement jelmt;
                if (obj instanceof EJaxbTopicExpressionType) {
                    texp = (EJaxbTopicExpressionType)obj;
                    break;
                }
                if (!(obj instanceof JAXBElement) || !((jelmt = (JAXBElement)obj).getValue() instanceof EJaxbTopicExpressionType)) continue;
                texp = (EJaxbTopicExpressionType)jelmt.getValue();
                break;
            }
            System.out.println("Event cloud (subscribe) => texp = " + texp);
            QName topic = WSNHelper.getQNameInSimpleTopicExpression((EJaxbTopicExpressionType)texp);
            List msgs = WSNHelper.getMessages((MessageContentExpression)WSNHelper.getMessageContentInFilter((EJaxbFilterType)subscribeRequest.getFilter()));
            System.out.println("Event cloud (subscribe) => topic: " + topic);
            System.out.println("Event cloud (subscribe) => msgs: " + msgs);
            List<URI> clientURIS = this.clientsMap.get(topic);
            if (clientURIS == null) {
                clientURIS = new ArrayList<URI>();
            }
            System.out.println("Event cloud (subscribe) => find topic: " + TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()]))));
            if (TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()]))).size() > 0) {
                for (TopicKey key : TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()])))) {
                    clientURIS = this.clientsMap.get(key);
                    if (clientURIS.contains(clientEPR)) continue;
                    clientURIS.add(clientEPR);
                }
            } else {
                clientURIS.add(clientEPR);
                this.clientsMap.put(new TopicKey(topic, msgs), clientURIS);
            }
            System.out.println("Event cloud (subscribe) => clients added: " + this.clientsMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidTopicExpressionFault(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public void notify(EJaxbNotify notify) {
        LOG.info("Executing operation notify on event cloud");
        System.out.println(notify);
        try {
            System.out.println("Event cloud (notify) => notify received: \n" + XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify)));
            for (EJaxbNotificationMessageHolderType h : notify.getNotificationMessage()) {
                QName topic = WSNHelper.getQNameInSimpleTopicExpression((EJaxbTopicExpressionType)h.getTopic());
                ArrayList<QName> msgs = new ArrayList<QName>();
                Element elmt = (Element)h.getMessage().getAny();
                QName msg = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
                msgs.add(msg);
                System.out.println("Event cloud (notify) => this.clientMap: " + this.clientsMap);
                System.out.println("Event cloud (notify) => topic = " + topic);
                System.out.println("Event cloud (notify) => msgs = " + msgs);
                List<TopicKey> keys = TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()])));
                System.out.println("Event cloud (notify) => keys = " + keys);
                for (TopicKey key : keys) {
                    List<URI> clients = this.clientsMap.get(key);
                    System.out.println("Event cloud (notify) => clients found: " + clients);
                    if (clients == null) continue;
                    for (URI uri : clients) {
                        Document request = SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify));
                        System.out.println("Event cloud (notify) => Send notification to " + uri.toString());
                        System.out.println("Event cloud (notify) => notif to send:\n" + XMLPrettyPrinter.prettyPrint((Document)request));
                        this.sender.sendSoapRequest(request, uri.toString(), "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public String addStatement(String arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters) throws CloudManagementException {
        AddStatementResponseWithActions res = new AddStatementResponseWithActions();
        throw new UnsupportedOperationException();
    }

    public BindResponse bind(Bind arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public String deleteStatement(String arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public String expose(QName arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbGetResourcePropertyResponse getResourceProperty(QName arg0) throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        throw new UnsupportedOperationException();
    }

    public String getStatementById(String arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public ListAllStatementsResponse listAllStatements(ListAllStatements arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public ProxifyResponse proxify(Proxify arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe arg0) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        throw new UnsupportedOperationException();
    }

    public String updateStatement(String arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

