/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.test;

import javax.servlet.Servlet;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.AxisServlet;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.start.Monitor;
import org.ow2.petals.binding.soap.test.HttpServerConfig;

public class HttpServer {
    public static final String STOP_KEY = "jetty";
    public static final int STOP_PORT = 9002;
    private Server server;

    public HttpServer(HttpServerConfig config, ConfigurationContext configurationContext) {
        Monitor.monitor((int)9002, (String)STOP_KEY);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(config.getHost());
        connector.setPort(config.getPort());
        this.server = new Server();
        this.server.setConnectors(new Connector[]{connector});
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        securityHandler.addConstraintMapping(constraintMapping);
        BasicAuthenticator basicAuth = new BasicAuthenticator();
        securityHandler.setAuthenticator((Authenticator)basicAuth);
        HashLoginService loginService = new HashLoginService();
        loginService.putUser(config.getUsername(), (Credential)new Password(config.getPassword()), new String[]{"user"});
        securityHandler.setLoginService((LoginService)loginService);
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setContextPath("/" + configurationContext.getContextRoot());
        contextHandler.setAttribute("CONFIGURATION_CONTEXT", (Object)configurationContext);
        AxisServlet axisServlet = new AxisServlet();
        ServletHolder axisServletHolder = new ServletHolder((Servlet)axisServlet);
        contextHandler.addServlet(axisServletHolder, "/" + configurationContext.getServicePath() + "/*");
        contextHandler.setSecurityHandler((SecurityHandler)securityHandler);
        this.server.setHandler((Handler)contextHandler);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

