/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.axis2.transport.TransportListener;
import org.ow2.petals.binding.soap.test.HttpServer;
import org.ow2.petals.binding.soap.test.HttpServerConfig;
import org.ow2.petals.binding.soap.test.IntegrationServiceSOAP;

public class IntegrationServiceSOAPOnHttpBasicAuthServer
implements TransportListener {
    private static final String HTTP_SERVER_HOST = "localhost";
    private static final int HTTP_SERVER_PORT = 8480;
    public static final String HTTP_BASIC_AUTH_USERNAME = "petals";
    public static final String HTTP_BASIC_AUTH_PASSWORD = "soap";
    private HttpServer httpServer;
    private ConfigurationContext configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
    private HttpServerConfig httpServerConfig;
    private static final String START_CMD = "start";
    private static final String STOP_CMD = "stop";
    private static final String STATUS_CMD = "status";

    public IntegrationServiceSOAPOnHttpBasicAuthServer() throws Exception {
        AxisConfiguration axisConf = this.configurationContext.getAxisConfiguration();
        axisConf.addParameter("disableREST", (Object)true);
        axisConf.addParameter("disableSOAP12", (Object)true);
        this.httpServerConfig = new HttpServerConfig(HTTP_SERVER_HOST, 8480, HTTP_BASIC_AUTH_USERNAME, HTTP_BASIC_AUTH_PASSWORD);
        this.httpServer = new HttpServer(this.httpServerConfig, this.configurationContext);
        ListenerManager listenerManager = new ListenerManager();
        listenerManager.init(this.configurationContext);
        TransportInDescription httpTransInDesc = new TransportInDescription("http");
        httpTransInDesc.setReceiver((TransportListener)this);
        listenerManager.addListener(httpTransInDesc, true);
        this.configurationContext.setTransportManager(listenerManager);
        HashMap receivers = new HashMap();
        receivers.put("http://www.w3.org/ns/wsdl/in-out", RPCMessageReceiver.class.newInstance());
        ClassLoader classLoader = IntegrationServiceSOAPOnHttpBasicAuthServer.class.getClassLoader();
        AxisService service = AxisService.createService((String)IntegrationServiceSOAP.class.getName(), (AxisConfiguration)axisConf, receivers, (String)"http://petals.ow2.org/", (String)"http://petals.ow2.org/", (ClassLoader)classLoader);
        service.setName("HTTPBasicAuthIntegrationServiceSOAP");
        service.addExposedTransport("http");
        axisConf.addService(service);
    }

    public void destroy() {
        try {
            this.configurationContext.getListenerManager().stop();
        }
        catch (AxisFault e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String endpointReference = "http://" + this.httpServerConfig.getHost() + ":" + this.httpServerConfig.getPort() + this.configurationContext.getServiceContextPath() + "/" + serviceName;
        return new EndpointReference[]{new EndpointReference(endpointReference)};
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtInDesc) throws AxisFault {
    }

    public void start() throws AxisFault {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public void stop() throws AxisFault {
        try {
            this.httpServer.stop();
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            String cmd = args[0];
            if (cmd.equals(START_CMD)) {
                try {
                    IntegrationServiceSOAPOnHttpBasicAuthServer intServServer = new IntegrationServiceSOAPOnHttpBasicAuthServer();
                    intServServer.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            } else if (cmd.equals(STOP_CMD) || cmd.equals(STATUS_CMD)) {
                try {
                    Socket socket = new Socket(InetAddress.getByName(HTTP_SERVER_HOST), 9002);
                    OutputStream os = socket.getOutputStream();
                    String msg = "jetty\r\n" + cmd + "\r\n";
                    os.write(msg.getBytes());
                    os.flush();
                    if (cmd.equals(STATUS_CMD)) {
                        InputStream is = socket.getInputStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        String status = br.readLine();
                        if (!status.equals("OK")) {
                            is.close();
                            os.close();
                            System.exit(-1);
                        }
                        is.close();
                    }
                    os.close();
                }
                catch (ConnectException e) {
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            } else {
                System.exit(-1);
            }
        } else {
            System.exit(-1);
        }
    }
}

