/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsoucing.integration.client.rmi;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.integration.util.IntegrationBuilder;
import com.ebmwebsourcing.integration.util.IntegrationException;
import com.ebmwebsourcing.integration.util.IntegrationRegexUtils;
import com.ebmwebsourcing.petals.integration.util.generated.Acknowledgment;
import com.ebmwebsourcing.petals.integration.util.generated.Actor;
import com.ebmwebsourcing.petals.integration.util.generated.Attachment;
import com.ebmwebsourcing.petals.integration.util.generated.Integration;
import com.ebmwebsourcing.petals.integration.util.generated.Mep;
import com.ebmwebsourcing.petals.integration.util.generated.NormalizedMessageExchange;
import com.ebmwebsourcing.petals.integration.util.generated.Property;
import com.ebmwebsourcing.petals.integration.util.generated.Test;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.petals.tools.rmi.client.ComponentContextLocator;
import org.objectweb.petals.tools.rmi.common.serializable.Fault;
import org.objectweb.petals.tools.rmi.common.serializable.NormalizedMessage;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteComponentContext;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;

public class RMIClient {
    private static final String UTF8 = "UTF-8";
    private static Transformer transformer;
    private static RemoteComponentContext componentContext;
    private static Integration integration;
    private static int rmiPort;
    private static String rmiContext;
    private static String rmiIP;
    private static int consumerDelay;
    private static long defautAcceptTimeout;
    private static Map<String, String> returnedUuids;

    public static void main(String[] args) {
        URI propertiesLocation = null;
        URI integrationLocation = null;
        returnedUuids = new HashMap<String, String>();
        if (args.length == 0) {
            RMIClient.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-integration".equals(args[i])) {
                try {
                    integrationLocation = URI.create(args[i + 1].replace(" ", "%20").replace("\\", "/"));
                    integrationLocation.normalize();
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Integration URL location is invalid : " + args[i + 1]);
                }
                continue;
            }
            if (!"-properties".equals(args[i])) continue;
            try {
                propertiesLocation = URI.create(args[i + 1].replace(" ", "%20").replace("\\", "/"));
                propertiesLocation.normalize();
                continue;
            }
            catch (IllegalArgumentException e) {
                System.out.println("Properties URL location is invalid : " + args[i + 1]);
            }
        }
        if (integrationLocation == null) {
            RMIClient.usage();
        }
        if (propertiesLocation != null) {
            Properties rmiProperties = new Properties();
            try {
                rmiProperties.load(propertiesLocation.toURL().openStream());
                if (rmiProperties.get("rmiPort") != null) {
                    rmiPort = Integer.parseInt((String)rmiProperties.get("rmiPort"));
                }
                if (rmiProperties.get("rmiIP") != null) {
                    rmiIP = (String)rmiProperties.get("rmiIP");
                }
                if (rmiProperties.get("rmiContext") != null) {
                    rmiContext = (String)rmiProperties.get("rmiContext");
                }
                if (rmiProperties.get("acceptTimeout") != null) {
                    defautAcceptTimeout = Long.parseLong((String)rmiProperties.get("acceptTimeout"));
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            ComponentContextLocator ccl = new ComponentContextLocator(rmiIP, rmiPort, rmiContext);
            componentContext = ccl.getComponentContext();
            System.out.println("Client: component Name = " + componentContext.getComponentName());
            integration = IntegrationBuilder.buildJavaIntegration((InputStream)integrationLocation.toURL().openStream());
            for (Actor provider : integration.getProvider()) {
                RMIClient.runProviderIntegration(provider);
            }
            for (Actor consumer : integration.getConsumer()) {
                RMIClient.runConsumerIntegration(consumer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Run integration tests successfully");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void runProviderIntegration(Actor provider) throws JBIException, TransformerConfigurationException, IntegrationException, TransformerException, IOException {
        String endpoint = provider.getEndpoint();
        if (StringHelper.isNullOrEmpty((String)endpoint)) {
            String id = new SimpleUUIDGenerator().getNewID();
            endpoint = "edpt-" + id;
        }
        componentContext.activateEndpoint(provider.getInterface(), provider.getService(), endpoint);
        System.out.println(rmiContext + "[provider]: " + provider.getDescription());
        for (Test test : provider.getTest()) {
            System.out.println(rmiContext + ": Running test '" + test.getDescription() + "' on operation '" + test.getOperation() + "' with mep '" + test.getMep() + "'");
            MessageExchange exchange = componentContext.getDeliveryChannel().accept(defautAcceptTimeout);
            RMIClient.checkProviderInMessage(exchange, test.getMessages().getIn(), test.getDescription(), test.getOperation(), test.getMep());
            if (exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.IN_ONLY_PATTERN)) {
                if (test.getMessages().getInack() == null) throw new IntegrationException("Test '" + test.getDescription() + "' must contain an InAck element for the patterm InOnly");
                RMIClient.handleProviderAcknowledgment(exchange, test.getMessages().getInack());
            } else if (exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.ROBUST_IN_ONLY_PATTERN)) {
                if (test.getMessages().getInack() != null) {
                    RMIClient.handleProviderAcknowledgment(exchange, test.getMessages().getInack());
                } else {
                    if (test.getMessages().getFault() == null || test.getMessages().getFaultack() == null) throw new IntegrationException("Test '" + test.getDescription() + "' must contain an InAck element or Fault and FaultAck elements for the pattern RobustInOnly");
                    RMIClient.handleProviderFault(exchange, test.getMessages().getFault(), test.getMessages().getFaultack(), test.getDescription());
                }
            } else if (exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.IN_OUT_PATTERN) || exchange.getPattern().equals(AbsItfOperation.MEPPatternConstants.IN_OUT)) {
                if (test.getMessages().getFault() != null) {
                    if (test.getMessages().getFaultack() == null) throw new IntegrationException("Test '" + test.getDescription() + "' must contain an FaultAck element as it contains a Fault element for the pattern InOut");
                    RMIClient.handleProviderFault(exchange, test.getMessages().getFault(), test.getMessages().getFaultack(), test.getDescription());
                } else {
                    if (test.getMessages().getOut() == null) throw new IntegrationException("Test '" + test.getDescription() + "' must contain an Out or a Fault element for the pattern InOut");
                    if (test.getMessages().getOutack() == null) throw new IntegrationException("Test '" + test.getDescription() + "' must contain an OutAck element as it contains an Out element for the pattern InOut");
                    RMIClient.handleProviderOutMessage(exchange, test.getMessages().getOut(), test.getMessages().getOutack(), test.getDescription());
                }
            }
            System.out.println(rmiContext + ": Running test '" + test.getDescription() + "' on operation '" + test.getOperation() + "' with mep '" + test.getMep() + "'.....OK");
        }
    }

    private static void runConsumerIntegration(Actor consumer) throws MessagingException, IntegrationException, TransformerConfigurationException, TransformerException, InterruptedException, IOException, Exception {
        System.out.println(rmiContext + "[consumer]: " + consumer.getDescription());
        for (Test test : consumer.getTest()) {
            MessageExchange exchange;
            Thread.sleep(consumerDelay);
            System.out.println(rmiContext + ": Running test '" + test.getDescription() + "' on operation '" + test.getOperation() + "' with mep '" + test.getMep() + "'");
            MessageExchange ref1 = exchange = RMIClient.createMessageExchange(test, consumer.getInterface(), consumer.getService(), consumer.getEndpoint(), componentContext);
            if (test.getSynchronousSend() != null) {
                exchange = componentContext.getDeliveryChannel().sendSync(exchange, test.getSynchronousSend().longValue());
                if (test.isTimeoutReached() != null && test.isTimeoutReached().booleanValue() && exchange != null) {
                    throw new IntegrationException("Test '" + test.getDescription() + "' failed. Expected timeout not reached");
                }
                if (exchange == null) {
                    throw new IntegrationException("Test '" + test.getDescription() + "' failed. Unexpected timeout reached");
                }
            } else {
                componentContext.getDeliveryChannel().send(exchange);
                exchange = componentContext.getDeliveryChannel().accept(defautAcceptTimeout);
            }
            MessageExchange ref2 = exchange;
            if (!ref1.getPattern().toString().equalsIgnoreCase(ref2.getPattern().toString())) {
                throw new Exception("Not same exchange (not same pattern) -> Ref1 ExchangeId " + ref1.getExchangeId() + " Ref2 ExchangeId " + ref2.getExchangeId() + "\nRef1 Pattern : " + ref1.getPattern() + " Ref2 pattern : " + ref2.getPattern());
            }
            if (!ref1.getExchangeId().equalsIgnoreCase(ref2.getExchangeId())) {
                throw new Exception("Not same exchange (not same exchangeId)");
            }
            if (AbsItfOperation.MEPPatternConstants.IN_ONLY.equals(exchange.getPattern()) || exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.IN_ONLY_PATTERN)) {
                if (test.getMessages().getInack() != null) {
                    RMIClient.checkAcknowledgment(exchange, test.getMessages().getInack(), test.getDescription());
                    continue;
                }
                throw new IntegrationException("Test '" + test.getDescription() + "' must contain an InAck element for the patterm InOnly");
            }
            if (Mep.ROBUST_IN_ONLY.equals((Object)test.getMep()) || exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.ROBUST_IN_ONLY_PATTERN)) {
                if (test.getMessages().getInack() != null) {
                    RMIClient.checkAcknowledgment(exchange, test.getMessages().getInack(), test.getDescription());
                    continue;
                }
                if (test.getMessages().getFault() != null) {
                    if (test.getMessages().getFaultack() != null) {
                        RMIClient.checkConsumerFault(exchange, test.getMessages().getFault(), test.getMessages().getFaultack(), test.getDescription());
                        continue;
                    }
                    throw new IntegrationException("Test '" + test.getDescription() + "' must contain a FaultAck element as it contains a Fault element for the pattern RobustInOnly");
                }
                throw new IntegrationException("Test '" + test.getDescription() + "' must contain an InAck or a Fault element for the patterm RobustInOnly");
            }
            if (AbsItfOperation.MEPPatternConstants.IN_OUT.equals(exchange.getPattern()) || exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.IN_OUT_PATTERN)) {
                if (test.getMessages().getOut() != null) {
                    if (test.getMessages().getOutack() != null) {
                        RMIClient.checkConsumerOutMessage(exchange, test.getMessages().getOut(), test.getMessages().getOutack(), test.getDescription());
                        continue;
                    }
                    throw new IntegrationException("Test '" + test.getDescription() + "' must contain an OutAck element as it contain Out element for the patterm InOut");
                }
                if (test.getMessages().getFault() != null) {
                    if (test.getMessages().getFaultack() != null) {
                        RMIClient.checkConsumerFault(exchange, test.getMessages().getFault(), test.getMessages().getFaultack(), test.getDescription());
                        continue;
                    }
                    throw new IntegrationException("Test '" + test.getDescription() + "' must contain an OutAck element as it contain a Fault element  for the patterm InOut");
                }
                throw new IntegrationException("Test '" + test.getDescription() + "' must contain an Out or a Fault element for the patterm InOut");
            }
            if (test.getMessages().getInack() != null) {
                RMIClient.checkAcknowledgment(exchange, test.getMessages().getInack(), test.getDescription());
                continue;
            }
            if (test.getMessages().getOut() != null) {
                if (test.getMessages().getOutack() != null) {
                    RMIClient.checkConsumerOutMessage(exchange, test.getMessages().getOut(), test.getMessages().getOutack(), test.getDescription());
                    continue;
                }
                if (test.getMessages().getFault() != null) {
                    if (test.getMessages().getFaultack() != null) {
                        RMIClient.checkConsumerOutMessageWithFault(exchange, test.getMessages().getOut(), test.getMessages().getFault(), test.getDescription());
                        exchange = componentContext.getDeliveryChannel().accept(defautAcceptTimeout);
                        RMIClient.checkAcknowledgment(exchange, test.getMessages().getFaultack(), test.getDescription());
                        continue;
                    }
                    throw new IntegrationException("Test '" + test.getDescription() + "' must contain an FaulAck element as it contain Out and Fault elements for the patterm InOptionalOut");
                }
                throw new IntegrationException("Test '" + test.getDescription() + "' must contain an OutAck element as it contain Out element for the patterm InOptionalOut");
            }
            if (test.getMessages().getFault() != null) {
                if (test.getMessages().getFaultack() != null) {
                    RMIClient.checkConsumerFault(exchange, test.getMessages().getFault(), test.getMessages().getFaultack(), test.getDescription());
                    continue;
                }
                throw new IntegrationException("Test '" + test.getDescription() + "' must contain an OutAck element as it contain a Fault element  for the patterm InOptionalOut");
            }
            throw new IntegrationException("Test '" + test.getDescription() + "' must contain an Inack, Out or a Fault element for the patterm InOptionalOut");
        }
    }

    private static void checkAcknowledgment(MessageExchange exchange, Acknowledgment expectedAck, String testDescription) throws IntegrationException {
        if (exchange.getStatus().toString().equals(expectedAck.getAck())) {
            if (expectedAck.getError() != null) {
                if (expectedAck.getError().isRegularExpression() != null && expectedAck.getError().isRegularExpression().booleanValue()) {
                    Pattern pattern = Pattern.compile(expectedAck.getError().getValue(), 32);
                    if (!pattern.matcher(exchange.getError().getMessage()).matches()) {
                        throw new IntegrationException("Test '" + testDescription + "' failed. Expected exception pattern '" + expectedAck.getError().getValue() + "' and get exception '" + exchange.getError().getMessage() + "'");
                    }
                } else if (!exchange.getError().getMessage().equals(expectedAck.getError().getValue())) {
                    throw new IntegrationException("Test '" + testDescription + "' failed. Expected exception '" + expectedAck.getError().getValue() + "' and get exception '" + exchange.getError().getMessage() + "'");
                }
            }
        } else {
            String errorMessage = "";
            if (exchange.getError() != null) {
                errorMessage = " with exception '" + exchange.getError().getMessage();
            }
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected Acknowledgment '" + expectedAck.getAck() + "' and get Acknowledgment '" + exchange.getStatus().toString() + "'" + errorMessage);
        }
    }

    private static void checkConsumerFault(MessageExchange exchange, NormalizedMessageExchange expectedFault, Acknowledgment faultAck, String testDescription) throws IntegrationException, MessagingException, RemoteException, TransformerConfigurationException, TransformerException {
        for (Property property : expectedFault.getProperty()) {
            if (exchange.getFault().getProperty(property.getName()) != null && exchange.getFault().getProperty(property.getName()).equals(property.getValue())) continue;
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected Fault property named '" + property.getName() + "' with value '" + property.getValue() + "' and get value '" + exchange.getFault().getProperty(property.getName()) + "'");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        if (exchange == null) {
            throw new MessagingException("The exchange is null.");
        }
        if (exchange.getFault() == null) {
            throw new MessagingException("The exchange's fault is null.");
        }
        if (exchange.getFault().getContent() == null) {
            throw new MessagingException("The exchange's fault has no (XML) body.");
        }
        RMIClient.getTransformer().transform(exchange.getFault().getContent(), result);
        if (expectedFault.getContent().isRegularExpression() != null && expectedFault.getContent().isRegularExpression().booleanValue()) {
            Pattern pattern = Pattern.compile(expectedFault.getContent().getValue(), 32);
            if (!pattern.matcher(buffer.toString()).matches()) {
                throw new IntegrationException("Test '" + testDescription + "' failed. Expected Fault content pattern '" + expectedFault.getContent().getValue() + "' and get '" + buffer.toString() + "'");
            }
        } else if (!XMLComparator.isEquivalent((String)expectedFault.getContent().getValue(), (String)buffer.toString())) {
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected Fault content '" + expectedFault.getContent().getValue() + "' and get '" + buffer.toString() + "'");
        }
        RMIClient.checkAttachment((javax.jbi.messaging.NormalizedMessage)exchange.getFault(), expectedFault, testDescription);
        exchange.setStatus(ExchangeStatus.valueOf((String)faultAck.getAck()));
        if (faultAck.getError() != null) {
            exchange.setError(new Exception(faultAck.getError().getValue()));
        }
        componentContext.getDeliveryChannel().send(exchange);
    }

    private static void checkConsumerOutMessage(MessageExchange exchange, NormalizedMessageExchange expectedOut, Acknowledgment outAck, String testDescription) throws IntegrationException, MessagingException, RemoteException, TransformerConfigurationException, TransformerException {
        for (Property property : expectedOut.getProperty()) {
            if (exchange.getMessage("out").getProperty(property.getName()) != null && exchange.getMessage("out").getProperty(property.getName()).equals(property.getValue())) continue;
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected Out property named '" + property.getName() + "' with value '" + property.getValue() + "' and get value '" + exchange.getMessage("out").getProperty(property.getName()) + "'");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        RMIClient.getTransformer().transform(exchange.getMessage("out").getContent(), result);
        if (expectedOut.getContent().isRegularExpression() != null && expectedOut.getContent().isRegularExpression().booleanValue()) {
            String messageContentValue = expectedOut.getContent().getValue();
            IntegrationRegexUtils.storeReturnedValue((String)messageContentValue, (String)"ebm:Uuid", (String)"[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}", returnedUuids);
            Pattern pattern = Pattern.compile(messageContentValue, 32);
            if (!pattern.matcher(buffer.toString()).matches()) {
                throw new IntegrationException("Test '" + testDescription + "' failed. Expected Out content pattern '" + expectedOut.getContent().getValue() + "' and get '" + buffer.toString() + "'");
            }
        } else if (!XMLComparator.isEquivalent((String)expectedOut.getContent().getValue(), (String)buffer.toString())) {
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected Out content '" + expectedOut.getContent().getValue() + "' and get '" + buffer.toString() + "'");
        }
        RMIClient.checkAttachment(exchange.getMessage("out"), expectedOut, testDescription);
        exchange.setStatus(ExchangeStatus.valueOf((String)outAck.getAck()));
        if (outAck.getError() != null) {
            exchange.setError(new Exception(outAck.getError().getValue()));
        }
        componentContext.getDeliveryChannel().send(exchange);
    }

    private static void checkAttachment(javax.jbi.messaging.NormalizedMessage currentNM, NormalizedMessageExchange expectedNM, String testDescription) throws IntegrationException {
        for (Attachment attachment : expectedNM.getAttachment()) {
            if (currentNM.getAttachment(attachment.getName()) != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    currentNM.getAttachment(attachment.getName()).writeTo((OutputStream)byteArrayOutputStream);
                }
                catch (IOException e) {
                    throw new IntegrationException("Test '" + testDescription + "' failed. Expected attachment named '" + attachment.getName() + "' with value '" + attachment.getValue() + "' and get IOException : " + e.getMessage());
                }
                String contentType = attachment.getContentType();
                if (!(contentType != null && (contentType.equalsIgnoreCase("text/xml") || contentType.equalsIgnoreCase("application/xml")) ? !XMLComparator.isEquivalent((InputStream)new ByteArrayInputStream(attachment.getValue().getBytes()), (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray())) : !byteArrayOutputStream.toString().equals(attachment.getValue()))) continue;
                throw new IntegrationException("Test '" + testDescription + "' failed. Expected attachment named '" + attachment.getName() + "' with value '" + attachment.getValue() + "' and get value '" + byteArrayOutputStream.toString() + "'");
            }
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected attachment named '" + attachment.getName() + "' and get no attachment");
        }
    }

    private static void checkConsumerOutMessageWithFault(MessageExchange exchange, NormalizedMessageExchange expectedOut, NormalizedMessageExchange outFault, String testDescription) throws IntegrationException, MessagingException, RemoteException, TransformerConfigurationException, TransformerException {
        for (Property property : expectedOut.getProperty()) {
            if (exchange.getMessage("out").getProperty(property.getName()) != null && exchange.getMessage("out").getProperty(property.getName()).equals(property.getValue())) continue;
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected Out property named '" + property.getName() + "' with value '" + property.getValue() + "' and get value '" + exchange.getMessage("out").getProperty(property.getName()) + "'");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        RMIClient.getTransformer().transform(exchange.getMessage("out").getContent(), result);
        if (expectedOut.getContent().isRegularExpression() != null && expectedOut.getContent().isRegularExpression().booleanValue()) {
            Pattern pattern = Pattern.compile(expectedOut.getContent().getValue(), 32);
            if (!pattern.matcher(buffer.toString()).matches()) {
                throw new IntegrationException("Test '" + testDescription + "' failed. Expected Out content pattern '" + expectedOut.getContent().getValue() + "' and get '" + buffer.toString() + "'");
            }
        } else if (!XMLComparator.isEquivalent((String)expectedOut.getContent().getValue(), (String)buffer.toString())) {
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected Out content '" + expectedOut.getContent().getValue() + "' and get '" + buffer.toString() + "'");
        }
        RMIClient.checkAttachment(exchange.getMessage("out"), expectedOut, testDescription);
        Fault fault = new Fault();
        for (Property property : outFault.getProperty()) {
            fault.setProperty(property.getName(), (Object)property.getValue());
        }
        fault.setContent((Source)new StreamSource(new ByteArrayInputStream(outFault.getContent().getValue().getBytes())));
        exchange.setFault((javax.jbi.messaging.Fault)fault);
        componentContext.getDeliveryChannel().send(exchange);
    }

    private static void checkProviderInMessage(MessageExchange exchange, NormalizedMessageExchange expectedIn, String testDescription, QName operation, Mep mep) throws IntegrationException, MessagingException, RemoteException, TransformerConfigurationException, TransformerException {
        Pattern pattern;
        if (!(operation == null || exchange == null || exchange.getOperation() != null && exchange.getOperation().equals(operation))) {
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected operation named '" + operation + "' and get '" + exchange.getOperation() + "'");
        }
        if (exchange != null) {
            if (exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.IN_ONLY_PATTERN) && Mep.IN_ONLY != mep || exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.ROBUST_IN_ONLY_PATTERN) && Mep.ROBUST_IN_ONLY != mep || exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.IN_OUT_PATTERN) && Mep.IN_OUT != mep || exchange.getPattern().equals(org.objectweb.petals.tools.rmi.common.serializable.MessageExchange.IN_OPTIONAL_OUT_PATTERN) && Mep.IN_OPTIONAL_OUT != mep) {
                throw new IntegrationException("Test '" + testDescription + "' failed. Expected MEP '" + mep + "' and get pattern '" + exchange.getPattern() + "'");
            }
            for (Property property : expectedIn.getProperty()) {
                if (exchange.getMessage("in").getProperty(property.getName()) == null) {
                    throw new IntegrationException("Test '" + testDescription + "' failed. Expected In property named '" + property.getName() + "' and get no property of this name");
                }
                if (exchange.getMessage("in").getProperty(property.getName()).equals(property.getValue())) continue;
                throw new IntegrationException("Test '" + testDescription + "' failed. Expected In property named '" + property.getName() + "' with value '" + property.getValue() + "' and get value '" + exchange.getMessage("in").getProperty(property.getName()) + "'");
            }
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        RMIClient.getTransformer().transform(exchange.getMessage("in").getContent(), result);
        if (expectedIn.getContent().isRegularExpression() != null && expectedIn.getContent().isRegularExpression() != false ? !(pattern = Pattern.compile(expectedIn.getContent().getValue(), 32)).matcher(buffer.toString()).matches() : !XMLComparator.isEquivalent((String)expectedIn.getContent().getValue(), (String)buffer.toString())) {
            throw new IntegrationException("Test '" + testDescription + "' failed. Expected In content '" + expectedIn.getContent().getValue() + "' and get '" + buffer.toString() + "'");
        }
        RMIClient.checkAttachment(exchange.getMessage("in"), expectedIn, testDescription);
    }

    private static void handleProviderAcknowledgment(MessageExchange exchange, Acknowledgment ack) throws IntegrationException, MessagingException, RemoteException {
        exchange.setStatus(ExchangeStatus.valueOf((String)ack.getAck()));
        if (ack.getError() != null) {
            exchange.setError(new Exception(ack.getError().getValue()));
        }
        componentContext.getDeliveryChannel().send(exchange);
    }

    private static void handleProviderFault(MessageExchange exchange, NormalizedMessageExchange expectedFault, Acknowledgment faultAck, String testDescription) throws IntegrationException, MessagingException, IOException {
        Fault fault = new Fault();
        for (Property property : expectedFault.getProperty()) {
            fault.setProperty(property.getName(), (Object)property.getValue());
        }
        fault.setContent((Source)new StreamSource(new ByteArrayInputStream(expectedFault.getContent().getValue().getBytes())));
        for (Attachment attachment : expectedFault.getAttachment()) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource((InputStream)new ByteArrayInputStream(attachment.getValue().getBytes()), attachment.getContentType());
            fault.addAttachment(attachment.getName(), new DataHandler((DataSource)dataSource));
        }
        exchange.setFault((javax.jbi.messaging.Fault)fault);
        exchange = componentContext.getDeliveryChannel().sendSync(exchange);
        RMIClient.checkAcknowledgment(exchange, faultAck, testDescription);
    }

    private static void handleProviderOutMessage(MessageExchange exchange, NormalizedMessageExchange expectedOutMessage, Acknowledgment outAck, String testDescription) throws IntegrationException, MessagingException, IOException {
        NormalizedMessage outMessage = new NormalizedMessage();
        for (Property property : expectedOutMessage.getProperty()) {
            outMessage.setProperty(property.getName(), (Object)property.getValue());
        }
        outMessage.setContent((Source)new StreamSource(new ByteArrayInputStream(expectedOutMessage.getContent().getValue().getBytes())));
        for (Attachment attachment : expectedOutMessage.getAttachment()) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource((InputStream)new ByteArrayInputStream(attachment.getValue().getBytes()), attachment.getContentType());
            outMessage.addAttachment(attachment.getName(), new DataHandler((DataSource)dataSource));
        }
        exchange.setMessage((javax.jbi.messaging.NormalizedMessage)outMessage, "out");
        exchange = componentContext.getDeliveryChannel().sendSync(exchange);
        RMIClient.checkAcknowledgment(exchange, outAck, testDescription);
    }

    private static MessageExchange createMessageExchange(Test test, QName interfaz, QName service, String endpoint, RemoteComponentContext componentContext) throws MessagingException, IOException {
        InOnly msg = null;
        javax.jbi.messaging.NormalizedMessage nm = null;
        String inContent = null;
        if (Mep.IN_ONLY.equals((Object)test.getMep())) {
            msg = componentContext.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
            nm = msg.createMessage();
            msg.setInMessage(nm);
        } else if (Mep.IN_OUT.equals((Object)test.getMep())) {
            msg = componentContext.getDeliveryChannel().createExchangeFactory().createInOutExchange();
            nm = msg.createMessage();
            ((InOut)msg).setInMessage(nm);
        } else if (Mep.IN_OPTIONAL_OUT.equals((Object)test.getMep())) {
            msg = componentContext.getDeliveryChannel().createExchangeFactory().createInOptionalOutExchange();
            nm = msg.createMessage();
            ((InOptionalOut)msg).setInMessage(nm);
        } else if (Mep.ROBUST_IN_ONLY.equals((Object)test.getMep())) {
            msg = componentContext.getDeliveryChannel().createExchangeFactory().createRobustInOnlyExchange();
            nm = msg.createMessage();
            ((RobustInOnly)msg).setInMessage(nm);
        }
        if (endpoint != null) {
            if (componentContext.getEndpoint(service, endpoint) == null) {
                throw new MessagingException("Unable to find the endpoint '" + endpoint + "' with its associated service " + service + "'");
            }
            msg.setEndpoint(componentContext.getEndpoint(service, endpoint));
        }
        msg.setService(service);
        msg.setInterfaceName(interfaz);
        if (test.getOperation() != null) {
            msg.setOperation(test.getOperation());
        }
        for (Property property : test.getMessages().getProperty()) {
            msg.setProperty(property.getName(), (Object)property.getValue());
        }
        for (Property property : test.getMessages().getIn().getProperty()) {
            nm.setProperty(property.getName(), (Object)property.getValue());
        }
        try {
            inContent = test.getMessages().getIn().getContent().getValue();
            if (!returnedUuids.isEmpty()) {
                inContent = IntegrationRegexUtils.substituteKey((String)inContent, returnedUuids);
            }
            nm.setContent((Source)new StreamSource(new ByteArrayInputStream(inContent.getBytes(UTF8))));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (Attachment attachment : test.getMessages().getIn().getAttachment()) {
            ByteArrayDataSource dataSource;
            String contentType = "application/octet-stream";
            if (attachment.getContentType() != null) {
                contentType = attachment.getContentType();
            }
            if (attachment.getFile() == null) {
                dataSource = new ByteArrayDataSource(attachment.getValue().getBytes(), contentType);
            } else {
                File attachmentFile = new File(attachment.getFile());
                if (!attachmentFile.exists()) {
                    throw new IOException("File '" + attachmentFile.getCanonicalPath() + "' do not exist");
                }
                dataSource = new FileDataSource(attachmentFile);
            }
            nm.addAttachment(attachment.getName(), new DataHandler((DataSource)dataSource));
        }
        return msg;
    }

    private static synchronized Transformer getTransformer() throws TransformerConfigurationException {
        if (transformer == null) {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        return transformer;
    }

    private static void usage() {
        System.out.println("PEtALS integration RMI client usage: -integration integrationFilePath [-properties rmiPropertiesFilePath] ");
        System.out.println("-integration : the absolute location of the integration file");
        System.out.println("-properties : the absolute location of the RMI properties file");
        System.exit(-1);
    }

    static {
        rmiPort = 1099;
        rmiContext = "RMIComponentContext";
        rmiIP = "localhost";
        consumerDelay = 1000;
        defautAcceptTimeout = 60000L;
        returnedUuids = null;
    }
}

