/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.test;

import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.component.framework.api.message.Exchange;

public class HTTPSIntegrationServicePOJOImpl {
    private Logger logger;
    private static final String expectedMessageContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><pet:add xmlns:pet=\"http://petals.ow2.org/\"><a>5</a><b>9</b></pet:add>";
    private static final QName expectedOperation = new QName("http://petals.ow2.org/", "add");
    private static final String returnedMessageContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ns:addResponse xmlns:ns=\"http://petals.ow2.org/\"><r>The result is 14</r></ns:addResponse>\n";
    private static final String returnedFaultWrongOperation = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Fault xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:pojo=\"http://petals.ow2.org/components/pojo/version-2\"><faultcode>pojo:WrongOperation</faultcode><faultstring>The JBI operation is not the expected one</faultstring><faultactor>http://petals.ow2.org/petals-se-pojo</faultactor><detail>expected operation '%s' and get operation '%s'</detail></soapenv:Fault>";
    private static final String returnedFaultWrongMessageContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Fault xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:pojo=\"http://petals.ow2.org/components/pojo/version-2\"><faultcode>pojo:WrongMessageContent</faultcode><faultstring>The JBI message content is not the expected one</faultstring><faultactor>http://petals.ow2.org/petals-se-pojo</faultactor><detail>expected '%s' and get '%s'</detail></soapenv:Fault>";
    private static final String returnedFaultPresenceOfAttachment = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Fault xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:pojo=\"http://petals.ow2.org/components/pojo/version-2\"><faultcode>pojo:AtLeastAnAttachment</faultcode><faultstring>There is at least an attachment</faultstring><faultactor>http://petals.ow2.org/petals-se-pojo</faultactor><detail><Reason>Attachment names: %s</Reason></detail></soapenv:Fault>";

    public void init() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "POJO " + this.getClass().getName() + ": Initialized");
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean onExchange(Exchange exchange) throws Exception {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "POJO " + this.getClass().getName() + ": Receive a message exchange");
        }
        QName jbiOperation = exchange.getOperation();
        boolean isRightOperation = jbiOperation.equals(expectedOperation);
        Source inMessageContent = exchange.getInMessageContentAsSource();
        String inMessageContentStr = SourceHelper.toString((Source)inMessageContent);
        boolean isEquivalent = XMLComparator.isEquivalent((String)inMessageContentStr, (String)expectedMessageContent);
        int inMessageAttachmentsNb = exchange.getInMessageAttachments().size();
        if (!isRightOperation) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "POJO " + this.getClass().getName() + ": Wrong operation");
            }
            String faultContentStr = String.format(returnedFaultWrongOperation, expectedOperation, jbiOperation);
            HTTPSIntegrationServicePOJOImpl.setFault(exchange, faultContentStr);
        } else if (!isEquivalent) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "POJO " + this.getClass().getName() + ": Wrong message content");
            }
            String faultContentStr = String.format(returnedFaultWrongMessageContent, expectedMessageContent, inMessageContentStr);
            HTTPSIntegrationServicePOJOImpl.setFault(exchange, faultContentStr);
        } else if (inMessageAttachmentsNb != 0) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "POJO " + this.getClass().getName() + ": Presence of attachments");
            }
            String faultContentStr = String.format(returnedFaultPresenceOfAttachment, exchange.getInMessageAttachmentNames());
            HTTPSIntegrationServicePOJOImpl.setFault(exchange, faultContentStr);
        } else {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "POJO " + this.getClass().getName() + ": In message OK");
            }
            StringReader outMessageContentReader = new StringReader(returnedMessageContent);
            StreamSource outMessageContent = new StreamSource(outMessageContentReader);
            exchange.setOutMessageContent((Source)outMessageContent);
        }
        return true;
    }

    private static final void setFault(Exchange exchange, String faultContentStr) throws MessagingException {
        StringReader faultContentReader = new StringReader(faultContentStr);
        StreamSource faultContent = new StreamSource(faultContentReader);
        Fault fault = exchange.createFault();
        fault.setContent((Source)faultContent);
        exchange.setFault(fault);
    }
}

