/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Runtimelong;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.process.AbstractMessageManager;
import org.ow2.petals.component.framework.process.JBIAcceptorThreadFactory;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.MessageExchangeAcceptor;

public class JBIAcceptorManager
extends AbstractMessageManager
implements NotificationListener {
    protected static final long DEFAULT_ACCEPTOR_STOP_MAX_WAIT = 500L;
    private final List<MessageExchangeAcceptor> acceptorPool = new ArrayList<MessageExchangeAcceptor>();
    private final JBIAcceptorThreadFactory acceptorFactory;
    private final JBIProcessorManager jbiProcessorManager;
    private final RuntimeConfigurationNotifier runtimeConfiguration;

    public JBIAcceptorManager(AbstractComponent component, JBIProcessorManager jbiProcessorManager, RuntimeConfigurationNotifier runtimeConfiguration, Logger logger) {
        super(component, logger);
        this.jbiProcessorManager = jbiProcessorManager;
        this.runtimeConfiguration = runtimeConfiguration;
        this.acceptorFactory = new JBIAcceptorThreadFactory(component, this.jbiProcessorManager, this.logger);
    }

    private long getAcceptorStopMaxWait() {
        long acceptorStopMaxWaitValue;
        Runtimelong acceptorStopMaxWait = this.component.getComponentConfiguration().getAcceptorStopMaxWait();
        if (acceptorStopMaxWait == null) {
            acceptorStopMaxWaitValue = 500L;
        } else {
            acceptorStopMaxWaitValue = acceptorStopMaxWait.getValue();
            if (acceptorStopMaxWaitValue <= 0L) {
                acceptorStopMaxWaitValue = 500L;
                this.logger.warning("Invalid value for attribute 'acceptor-stop-max-wait': The value must be upper or equals to 1. Default value used (500).");
            }
        }
        return acceptorStopMaxWaitValue;
    }

    public void init() throws JBIException {
        this.runtimeConfiguration.addNotificationListener(this, null, null);
    }

    public void start() throws JBIException {
        this.logger.fine("Creating JBI Acceptor pool:");
        int corePoolSize = this.component.getComponentConfiguration().getAcceptorPoolSize().getValue();
        int retryMaxTryValue = this.getRetryMaxTry();
        long retryBaseDurationValue = this.getRetryBaseDuration();
        this.logger.fine("\t- core pool size: " + corePoolSize);
        this.logger.fine("\t- retry policy : max try number: " + retryMaxTryValue);
        this.logger.fine("\t- retry policy : base duration: " + retryBaseDurationValue);
        for (int i = 0; i < corePoolSize; ++i) {
            MessageExchangeAcceptor acceptorThread = this.acceptorFactory.newThread(retryMaxTryValue, retryBaseDurationValue);
            acceptorThread.start();
            this.acceptorPool.add(acceptorThread);
        }
    }

    public void stop() {
        for (MessageExchangeAcceptor acceptorThread : this.acceptorPool) {
            acceptorThread.interrupt();
        }
        Iterator<MessageExchangeAcceptor> itAcceptorPool = this.acceptorPool.iterator();
        while (itAcceptorPool.hasNext()) {
            MessageExchangeAcceptor acceptorThread;
            acceptorThread = itAcceptorPool.next();
            itAcceptorPool.remove();
            this.stopAcceptorThread(acceptorThread);
        }
    }

    public void shutdown() throws JBIException {
        try {
            this.runtimeConfiguration.removeNotificationListener(this, null, null);
        }
        catch (ListenerNotFoundException e) {
            throw new JBIException("Error unregistering the runtime configuration listener", (Throwable)e);
        }
    }

    private void stopAcceptorThread(MessageExchangeAcceptor acceptorThread) {
        acceptorThread.ends();
        try {
            acceptorThread.join(this.getAcceptorStopMaxWait());
            if (!acceptorThread.isInterrupted()) {
                acceptorThread.interrupt();
            }
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "The stop one acceptor of the acceptor thread pool was interrupted", e);
        }
    }

    private void setCorePoolSize(int size) {
        if (this.acceptorPool != null) {
            this.logger.info("Reset the acceptor thread pool size to " + size);
            if (size > this.acceptorPool.size()) {
                int nbThreadToCreate = size - this.acceptorPool.size();
                for (int i = 0; i < nbThreadToCreate; ++i) {
                    MessageExchangeAcceptor acceptorThread = this.acceptorFactory.newThread(this.getRetryMaxTry(), this.getRetryBaseDuration());
                    acceptorThread.start();
                    this.acceptorPool.add(acceptorThread);
                }
            } else if (size < this.acceptorPool.size()) {
                Iterator<MessageExchangeAcceptor> itAcceptorPool = this.acceptorPool.iterator();
                for (int nbThreadToStop = this.acceptorPool.size() - size; itAcceptorPool.hasNext() && nbThreadToStop > 0; --nbThreadToStop) {
                    MessageExchangeAcceptor acceptorThread = itAcceptorPool.next();
                    itAcceptorPool.remove();
                    this.stopAcceptorThread(acceptorThread);
                }
            } else {
                this.logger.fine("Unchange value, so no acceptor thread created or stopped !");
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object obj) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification attrNotif = (AttributeChangeNotification)notification;
            String attrName = attrNotif.getAttributeName();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Notification received by " + this.getClass().getName() + " for attribute : " + attrName);
            }
            if (attrName.equals("acceptorPoolSize")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                this.setCorePoolSize(newVal);
            } else {
                this.logger.log(Level.FINE, "Notification ignored by " + this.getClass().getName() + " for attribute : " + attrName);
            }
        }
    }
}

