/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SourceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Source source, File fileToWrite) throws TransformerException, IOException {
        FileWriter writer = new FileWriter(fileToWrite);
        StreamResult result = new StreamResult(writer);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, result);
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Source source) throws TransformerException {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, result);
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
        return writer.toString();
    }

    private static final Source forkStreamSource(StreamSource source) throws IOException {
        InputStreamForker streamForker = source.getInputStream() != null ? new InputStreamForker(source.getInputStream()) : new InputStreamForker((InputStream)new ReaderInputStream(source.getReader()));
        source.setInputStream(streamForker.fork());
        return new StreamSource(streamForker.fork());
    }

    public static Source fork(Source source) throws IOException {
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return SourceHelper.forkStreamSource((StreamSource)source);
        }
        throw new IllegalArgumentException("Only DOMSource or StreamSource are supported right now.");
    }

    public static InputSource sourceToInputSource(Source source, String publicId, String systemId) {
        InputSource is = null;
        if (source instanceof SAXSource) {
            is = ((SAXSource)source).getInputSource();
        } else if (source instanceof DOMSource) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Node node = ((DOMSource)source).getNode();
            if (node instanceof Document) {
                node = ((Document)node).getDocumentElement();
            }
            Element domElement = (Element)node;
            SourceHelper.ElementToStream(domElement, baos);
            InputSource isource = new InputSource(source.getSystemId());
            isource.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
            is = isource;
        } else if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            InputSource isource = new InputSource(ss.getSystemId());
            isource.setByteStream(ss.getInputStream());
            isource.setCharacterStream(ss.getReader());
            isource.setPublicId(ss.getPublicId());
            is = isource;
        } else {
            is = new InputSource(source.getSystemId());
        }
        if (is != null) {
            is.setPublicId(publicId);
            is.setSystemId(systemId);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ElementToStream(Element element, OutputStream out) {
        DOMSource source = new DOMSource(element);
        StreamResult result = new StreamResult(out);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, result);
        }
        catch (Exception ex) {
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
    }
}

