/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManagerObserver;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;

class MessageExchangeProcessorThreadPoolExecutor
extends ThreadPoolExecutor {
    private final GenericObjectPool processorObjectPool;
    private final Logger logger;
    private final List<JBIProcessorManagerObserver> jbiProccesorManagerObservers;

    public MessageExchangeProcessorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, GenericObjectPool processorObjectPool, List<JBIProcessorManagerObserver> jbiProccesorManagerObservers, Logger logger) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
        this.processorObjectPool = processorObjectPool;
        this.jbiProccesorManagerObservers = jbiProccesorManagerObservers;
        this.logger = logger;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ExchangeImpl exchange = ((MessageExchangeProcessor)r).getMessageExchange();
        this.notifyObserversBeforeProcessing(exchange);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ExchangeImpl exchange = ((MessageExchangeProcessor)r).getMessageExchange();
        this.notifyObserversAfterProcessing(exchange);
        ((MessageExchangeProcessor)r).clean();
        try {
            this.processorObjectPool.returnObject((Object)r);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to return a Message Exchange Processor instance to the Object pool", e);
        }
        super.afterExecute(r, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyObserversBeforeProcessing(ExchangeImpl exchange) {
        List<JBIProcessorManagerObserver> list = this.jbiProccesorManagerObservers;
        synchronized (list) {
            for (JBIProcessorManagerObserver jbiProccesorManagerObserver : this.jbiProccesorManagerObservers) {
                jbiProccesorManagerObserver.beforeProcessingMessage(exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyObserversAfterProcessing(ExchangeImpl exchange) {
        List<JBIProcessorManagerObserver> list = this.jbiProccesorManagerObservers;
        synchronized (list) {
            for (JBIProcessorManagerObserver jbiProccesorManagerObserver : this.jbiProccesorManagerObservers) {
                jbiProccesorManagerObserver.afterProcessingMessage(exchange);
            }
        }
    }
}

