/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.xsd2xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.All;
import org.ow2.easywsdl.schema.api.ComplexContent;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Enumeration;
import org.ow2.easywsdl.schema.api.Extension;
import org.ow2.easywsdl.schema.api.Restriction;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.SimpleType;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfAttribute;
import org.ow2.easywsdl.schema.api.absItf.AbsItfComplexType;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractAttributeImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractElementImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.impl.ComplexTypeImpl;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.FormChoice;
import org.ow2.easywsdl.tooling.xsd2xml.XSD2XML;

public class XSD2XMLImpl
extends XSD2XML {
    private final Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final Map<String, String> TYPED_DEFAULT_VALUES = new HashMap<String, String>();
    private static final Map<String, String> TYPED_SHORTEN_DEFAULT_VALUES = new HashMap<String, String>();

    @Override
    public Element generateElement(AbsItfElement eIn, Object value) throws SchemaException {
        Element res = null;
        if (eIn != null) {
            Map<Type, Object> values = null;
            values = value == null ? XSD2XML.createDefaultMap("") : XSD2XML.createDefaultMap(value);
            res = this.generateElement(eIn, values, ((AbstractElementImpl)eIn).getSchema().getElementFormDefault(), 1, false, false);
        }
        return res;
    }

    @Override
    public Element generateElement(AbsItfElement eIn, Map<Type, Object> values, FormChoice form, int minOccurs, boolean createOptionalElement, boolean createOptionalAttribute) throws SchemaException {
        if (values == null) {
            values = XSD2XMLImpl.createDefaultMap("");
        }
        Element eOut = null;
        if (minOccurs > 0) {
            Namespace ns = Namespace.getNamespace((String)eIn.getQName().getPrefix(), (String)eIn.getQName().getNamespaceURI());
            eOut = ((AbstractSchemaElementImpl)eIn).getParent() instanceof AbsItfSchema ? new Element(eIn.getQName().getLocalPart(), eIn.getQName().getPrefix(), eIn.getQName().getNamespaceURI()) : new Element(eIn.getQName().getLocalPart());
            if (form == FormChoice.QUALIFIED) {
                eOut.setNamespace(Namespace.getNamespace((String)eIn.getQName().getPrefix(), (String)eIn.getQName().getNamespaceURI()));
            }
            if (((AbstractElementImpl)eIn).getType() instanceof ComplexType) {
                if (((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getModel() != null) {
                    List<org.ow2.easywsdl.schema.api.Element> items = null;
                    if (((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getSequence() != null) {
                        items = ((Sequence)((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getSequence()).getElements();
                    } else if (((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getAll() != null) {
                        items = ((All)((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getAll()).getElements();
                    } else if (((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getComplexContent() != null && ((ComplexContent)((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getComplexContent()).getExtension() != null) {
                        items = this.getAllElementFindInAllInheritedParent((Type)((Extension)((ComplexContent)((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getComplexContent()).getExtension()).getBase());
                        if (((Extension)((ComplexContent)((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getComplexContent()).getExtension()).getSequence() != null) {
                            items.addAll(((Sequence)((Extension)((ComplexContent)((ComplexTypeImpl)((AbstractElementImpl)eIn).getType()).getComplexContent()).getExtension()).getSequence()).getElements());
                        }
                    }
                    if (items != null) {
                        for (org.ow2.easywsdl.schema.api.Element item : items) {
                            if (item.getRef() == null) {
                                String comment;
                                Element child;
                                org.ow2.easywsdl.schema.api.Element e = item;
                                FormChoice elmtFrom = null;
                                elmtFrom = e.getForm() != null ? e.getForm() : form;
                                int minOccursChildElmt = e.getMinOccurs();
                                if (createOptionalElement && minOccursChildElmt == 0) {
                                    minOccursChildElmt = 1;
                                }
                                if ((child = this.generateElement((AbsItfElement)e, values, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute)) == null) continue;
                                if (e.getType() instanceof SimpleType && (comment = this.buildComment((AbsItfElement<?>)e)) != null) {
                                    eOut.addContent((Content)new Comment(comment));
                                }
                                eOut.addContent(child.detach());
                                continue;
                            }
                            List listE = ((AbstractElementImpl)eIn).getParent().getSchema().findElementsInAllSchema(item.getRef());
                            if (listE != null && listE.size() > 0) {
                                String comment;
                                Element child;
                                AbsItfElement e = (AbsItfElement)listE.get(0);
                                FormChoice elmtFrom = null;
                                elmtFrom = e.getForm() != null ? e.getForm() : form;
                                int minOccursChildElmt = e.getMinOccurs();
                                if (createOptionalElement && minOccursChildElmt == 0) {
                                    minOccursChildElmt = 1;
                                }
                                if ((child = this.generateElement(e, values, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute)) == null) continue;
                                if (e.getType() instanceof SimpleType && (comment = this.buildComment(e)) != null) {
                                    eOut.addContent((Content)new Comment(comment));
                                }
                                eOut.addContent(child.detach());
                                continue;
                            }
                            throw new SchemaException("Impossible to find element corresponding to this reference: " + item.getRef());
                        }
                        for (org.ow2.easywsdl.schema.api.Attribute attr : ((ComplexType)((AbstractElementImpl)eIn).getType()).getAttributes()) {
                            Attribute a = null;
                            if (AbsItfAttribute.Use.REQUIRED.equals((Object)attr.getUse())) {
                                a = this.generateAttribute(eIn, (AbsItfAttribute)attr, values);
                            } else if (createOptionalAttribute) {
                                a = this.generateAttribute(eIn, (AbsItfAttribute)attr, values);
                            }
                            if (a == null) continue;
                            eOut.setAttribute(a);
                        }
                    }
                }
            } else {
                String val = this.findValue(eIn.getType(), values);
                if (val != null && !eIn.isNillable()) {
                    eOut.setText(val);
                }
            }
            List<Attribute> attrs = this.generateAttributes(eIn, values, ((AbstractElementImpl)eIn).getSchema().getAttributeFormDefault(), createOptionalAttribute);
            Attribute typeAttr = null;
            if (((AbstractElementImpl)eIn).getType() != null) {
                String type = null;
                if (((AbstractElementImpl)eIn).getType().getQName() != null) {
                    String prefix = ((AbstractElementImpl)eIn).getParent().getSchema().getAllNamespaces().getPrefix(((AbstractElementImpl)eIn).getType().getQName().getNamespaceURI());
                    if (prefix != null) {
                        type = prefix + ":" + ((AbstractElementImpl)eIn).getType().getQName().getLocalPart();
                        Namespace typeNs = Namespace.getNamespace((String)prefix, (String)((AbstractElementImpl)eIn).getParent().getSchema().getAllNamespaces().getNamespaceURI(prefix));
                        eOut.addNamespaceDeclaration(typeNs);
                        eOut.addNamespaceDeclaration(this.xsi);
                        typeAttr = new Attribute("type", type, this.xsi);
                    } else {
                        type = ((AbstractElementImpl)eIn).getType().getQName().getLocalPart();
                        eOut.addNamespaceDeclaration(this.xsi);
                        typeAttr = new Attribute("type", type, this.xsi);
                    }
                }
            }
            if (typeAttr != null) {
                attrs.add(typeAttr);
            }
            eOut.setAttributes(attrs);
        }
        return eOut;
    }

    private List<org.ow2.easywsdl.schema.api.Element> getAllElementFindInAllInheritedParent(Type base) {
        ArrayList<org.ow2.easywsdl.schema.api.Element> res = new ArrayList<org.ow2.easywsdl.schema.api.Element>();
        if (base instanceof ComplexType) {
            ComplexType ct = (ComplexType)base;
            if (ct.getAll() != null) {
                res.addAll(((All)ct.getAll()).getElements());
            } else if (ct.getSequence() != null) {
                res.addAll(((Sequence)ct.getSequence()).getElements());
            } else if (ct.getComplexContent() != null && ((ComplexContent)ct.getComplexContent()).getExtension() != null) {
                res.addAll(this.getAllElementFindInAllInheritedParent((Type)((Extension)((ComplexContent)ct.getComplexContent()).getExtension()).getBase()));
            }
        }
        return res;
    }

    private List<Attribute> generateAttributes(AbsItfElement eIn, Map<Type, Object> values, FormChoice attributeFormDefault, boolean createOptionalAttribute) {
        ArrayList<Attribute> res = new ArrayList<Attribute>();
        if (eIn.getType() instanceof ComplexType) {
            ComplexType ct = (ComplexType)eIn.getType();
            for (org.ow2.easywsdl.schema.api.Attribute attr : ct.getAttributes()) {
                if (!AbsItfAttribute.Use.REQUIRED.equals((Object)attr.getUse()) && !createOptionalAttribute) continue;
                Attribute a = null;
                String prefix = ((AbstractElementImpl)eIn).getSchema().getAllNamespaces().getPrefix(attr.getNamespaceUri());
                a = prefix != null && !attr.getNamespaceUri().equals(eIn.getQName().getNamespaceURI()) && attributeFormDefault == FormChoice.QUALIFIED ? new Attribute(attr.getName(), this.findValue(attr.getType(), values), Namespace.getNamespace((String)prefix, (String)attr.getNamespaceUri())) : new Attribute(attr.getName(), this.findValue(attr.getType(), values));
                res.add(a);
            }
        }
        return res;
    }

    private String findValue(AbsItfType key, Map<Type, Object> values) {
        String res = null;
        if (values.get(key) != null) {
            res = values.get(key).toString();
        }
        if (res == null || res.trim().length() == 0) {
            String type = key.toString().toLowerCase();
            String string = type = type.startsWith("{http://www.w3.org/2001/xmlschema}") ? type.substring(34) : null;
            if (type == null) {
                SimpleType st;
                if (key instanceof SimpleType && (st = (SimpleType)key).getRestriction() != null && ((Restriction)st.getRestriction()).getEnumerations() != null && !((Restriction)st.getRestriction()).getEnumerations().isEmpty()) {
                    res = ((Enumeration)((Restriction)st.getRestriction()).getEnumerations().get(0)).getValue();
                }
            } else {
                String typeName = TYPED_SHORTEN_DEFAULT_VALUES.get(type);
                res = typeName == null ? "" : TYPED_DEFAULT_VALUES.get(typeName);
            }
        }
        return res;
    }

    private String buildComment(AbsItfElement<?> element) {
        String res;
        AbsItfType key = element.getType();
        String type = key.toString().toLowerCase();
        String string = type = type.startsWith("{http://www.w3.org/2001/xmlschema}") ? type.substring(34) : null;
        if (type == null) {
            res = "Unknown";
            if (key instanceof SimpleType && ((SimpleType)key).getRestriction() != null && ((Restriction)((SimpleType)key).getRestriction()).getEnumerations() != null) {
                res = "Enumeration";
            }
        } else {
            String typeName = TYPED_SHORTEN_DEFAULT_VALUES.get(type);
            res = typeName == null ? "Unknown Type" : typeName;
        }
        StringBuilder sb = new StringBuilder(res);
        sb.append(", card: [ ");
        sb.append(element.getMinOccurs());
        sb.append(", ");
        sb.append(element.getMaxOccurs());
        sb.append(" ]");
        if (element.isNillable()) {
            sb.append(", Nillable (xsi:nil=\"true\") ");
        } else {
            sb.append(" ");
        }
        sb.insert(0, " ");
        return sb.toString();
    }

    public Attribute generateAttribute(AbsItfElement eIn, AbsItfAttribute aIn, Map<Type, Object> value) {
        Attribute attr = null;
        if (aIn.getName() != null) {
            String prefix = null;
            Namespace ns = null;
            if (!aIn.getNamespaceUri().equals(eIn.getQName().getNamespaceURI()) && ((AbstractElementImpl)eIn).getParent().getSchema().getAllNamespaces().getPrefix(aIn.getNamespaceUri()) != null) {
                prefix = ((AbstractElementImpl)eIn).getParent().getSchema().getAllNamespaces().getPrefix(aIn.getNamespaceUri());
                ns = Namespace.getNamespace((String)prefix, (String)aIn.getNamespaceUri());
            }
            attr = ((AbstractAttributeImpl)aIn).getSchema().getAttributeFormDefault() == FormChoice.QUALIFIED ? new Attribute(aIn.getName(), this.findValue(aIn.getType(), value), ns) : new Attribute(aIn.getName(), this.findValue(aIn.getType(), value), null);
        }
        return attr;
    }

    @Override
    public String printXml(AbsItfElement e, Object value) throws SchemaException {
        Element eOut = this.generateElement(e, value);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
    }

    @Override
    public String printXml(Element element, Format formatter) {
        HashMap<String, String> prefixToUri = new HashMap<String, String>();
        for (Object o : element.getAdditionalNamespaces()) {
            if (!(o instanceof Namespace)) continue;
            prefixToUri.put(((Namespace)o).getPrefix(), ((Namespace)o).getURI());
        }
        ArrayList<Element> toProcess = new ArrayList<Element>();
        toProcess.add(element);
        while (!toProcess.isEmpty()) {
            Element current = (Element)toProcess.remove(0);
            for (Object o : current.getChildren()) {
                if (!(o instanceof Element)) continue;
                Element child = (Element)o;
                toProcess.add(child);
                ArrayList<Namespace> toRemove = new ArrayList<Namespace>();
                for (Object oo : child.getAdditionalNamespaces()) {
                    if (!(oo instanceof Namespace)) continue;
                    Namespace ns = (Namespace)oo;
                    if (ns.getURI() == null) {
                        toRemove.add(ns);
                        continue;
                    }
                    String currentUri = (String)prefixToUri.get(ns.getPrefix());
                    if (currentUri == null) {
                        element.addNamespaceDeclaration(ns);
                        toRemove.add(ns);
                        continue;
                    }
                    if (!ns.getURI().equals(currentUri)) continue;
                    toRemove.add(ns);
                }
                for (Namespace ns : toRemove) {
                    child.removeNamespaceDeclaration(ns);
                }
            }
        }
        String result = new XMLOutputter(formatter).outputString(element);
        return result;
    }

    @Override
    public String printXml(Element element) {
        Format formatter = Format.getPrettyFormat().setIndent("\t").setExpandEmptyElements(true).setEncoding("UTF-8");
        return this.printXml(element, formatter);
    }

    @Override
    public Element addMinOccursEqual0OrArrayElement(AbsItfElement childDefinition, Element parentElement) throws SchemaException {
        String maxOccurs = childDefinition.getMaxOccurs();
        int maxOcc = -1;
        maxOcc = maxOccurs == null ? 1 : (maxOccurs.toUpperCase().equals("UNBOUNDED") ? 10 : Integer.parseInt(maxOccurs));
        Element child = null;
        if (childDefinition.getMinOccurs() == 0 || maxOcc > 1) {
            child = this.generateElement(childDefinition, XSD2XMLImpl.createDefaultMap(""), ((AbstractElementImpl)childDefinition).getSchema().getElementFormDefault(), 1, false, true);
            ComplexType parentType = this.findParentType((AbstractSchemaElementImpl)childDefinition);
            if (parentType.getSequence() != null) {
                this.addChildInGoodPlace(childDefinition, parentElement, child, parentType);
            } else if (parentType.getAll() != null) {
                this.addChildInGoodPlace(childDefinition, parentElement, child, parentType);
            } else {
                parentElement.addContent(child.detach());
            }
        } else {
            throw new SchemaException("this element (" + childDefinition.getQName() + ") is not an array or not minOccurs = 0");
        }
        return child;
    }

    private void addChildInGoodPlace(AbsItfElement childDefinition, Element parentElement, Element child, ComplexType parentType) {
        int index = 0;
        Element elmtInP = null;
        for (org.ow2.easywsdl.schema.api.Element elmt : ((Sequence)parentType.getSequence()).getElements()) {
            if (elmt.getQName().equals(childDefinition.getQName())) {
                List arrayElmts = parentElement.getChildren(childDefinition.getQName().getLocalPart());
                if (arrayElmts == null || arrayElmts.size() == 0) {
                    arrayElmts = parentElement.getChildren(childDefinition.getQName().getLocalPart(), Namespace.getNamespace((String)childDefinition.getQName().getNamespaceURI()));
                }
                if (arrayElmts != null && arrayElmts.size() > 0) {
                    arrayElmts.add((Element)child.detach());
                    break;
                }
                parentElement.addContent(index, child.detach());
                break;
            }
            elmtInP = parentElement.getChild(elmt.getQName().getLocalPart());
            if (elmtInP == null) {
                elmtInP = parentElement.getChild(elmt.getQName().getLocalPart(), Namespace.getNamespace((String)elmt.getQName().getNamespaceURI()));
            }
            if (elmtInP == null) continue;
            ++index;
        }
    }

    private ComplexType findParentType(AbstractSchemaElementImpl childDefinition) {
        ComplexType parentType = null;
        AbstractSchemaElementImpl parent = childDefinition.getParent();
        if (parent != null) {
            parentType = parent instanceof AbsItfElement ? (ComplexType)((AbsItfElement)parent).getType() : (parent instanceof AbsItfComplexType ? (ComplexType)((AbsItfComplexType)parent) : this.findParentType(parent));
        }
        return parentType;
    }

    @Override
    public String printXml(AbsItfElement eIn, Map<Type, Object> values, boolean createOptionalElement, boolean createOptionalAttribute) throws SchemaException {
        Element eOut = this.generateElement(eIn, values, ((AbstractElementImpl)eIn).getSchema().getElementFormDefault(), 1, createOptionalElement, createOptionalAttribute);
        return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
    }

    static {
        TYPED_DEFAULT_VALUES.put("Any Simple Type", "");
        TYPED_DEFAULT_VALUES.put("Any URI", "http://google.fr");
        TYPED_DEFAULT_VALUES.put("Base64 Binary", "");
        TYPED_DEFAULT_VALUES.put("Boolean", "true");
        TYPED_DEFAULT_VALUES.put("Byte", "");
        TYPED_DEFAULT_VALUES.put("Date", "2002-10-10-05:00");
        TYPED_DEFAULT_VALUES.put("Date Time", "2002-10-10T17:00:00Z");
        TYPED_DEFAULT_VALUES.put("Decimal", "12.54");
        TYPED_DEFAULT_VALUES.put("Double", "12.78e-2");
        TYPED_DEFAULT_VALUES.put("Duration", "P1Y2MT2H");
        TYPED_DEFAULT_VALUES.put("Float", "12.54E12");
        TYPED_DEFAULT_VALUES.put("gDay", "---21");
        TYPED_DEFAULT_VALUES.put("gMonth", "--11");
        TYPED_DEFAULT_VALUES.put("gMonthDay", "--05-01");
        TYPED_DEFAULT_VALUES.put("gYear", "1999");
        TYPED_DEFAULT_VALUES.put("gYearMonth", "1999-05");
        TYPED_DEFAULT_VALUES.put("HexBinary", "FF");
        TYPED_DEFAULT_VALUES.put("Int", "5");
        TYPED_DEFAULT_VALUES.put("Integer", "5");
        TYPED_DEFAULT_VALUES.put("Language", "fr-FR");
        TYPED_DEFAULT_VALUES.put("Long", "5");
        TYPED_DEFAULT_VALUES.put("Name", "");
        TYPED_DEFAULT_VALUES.put("NCName", "");
        TYPED_DEFAULT_VALUES.put("Negative Integer", "-1");
        TYPED_DEFAULT_VALUES.put("Non Negative Integer", "1");
        TYPED_DEFAULT_VALUES.put("Non Positive Integer", "-1");
        TYPED_DEFAULT_VALUES.put("Normalized String", "");
        TYPED_DEFAULT_VALUES.put("Positive Integer", "1");
        TYPED_DEFAULT_VALUES.put("QName", "");
        TYPED_DEFAULT_VALUES.put("Short", "5");
        TYPED_DEFAULT_VALUES.put("String", "");
        TYPED_DEFAULT_VALUES.put("Time", "13:20:00-05:00");
        TYPED_DEFAULT_VALUES.put("Token", "");
        TYPED_DEFAULT_VALUES.put("Unsigned Byte", "255");
        TYPED_DEFAULT_VALUES.put("Unsigned Int", "255");
        TYPED_DEFAULT_VALUES.put("Unsigned Long", "255");
        TYPED_DEFAULT_VALUES.put("Unsigned Short", "255");
        for (String key : TYPED_DEFAULT_VALUES.keySet()) {
            String newKey = key.toLowerCase().replace(" ", "");
            TYPED_SHORTEN_DEFAULT_VALUES.put(newKey, key);
        }
    }
}

