/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentJbiGenerator;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.component.api.ComponentConfiguration;

public class ComponentJbiGeneratorTest {
    @Test
    public void testGenerateFromEmptyComponentConfiguration() throws Exception {
        URL defaultJbiUrl = this.getClass().getClassLoader().getResource("jbi/jbi.xml");
        File tempInstallationRoot = FileSystemHelper.createTempDir((String)"installationRoot");
        ComponentConfiguration componentConfiguration = new ComponentConfiguration("componentName", Logger.getAnonymousLogger());
        ComponentJbiGenerator componentJbiGenerator = new ComponentJbiGenerator(ComponentType.BC_FILETRANSFER, componentConfiguration, tempInstallationRoot);
        File defaultJbi = new File(defaultJbiUrl.getFile());
        Assert.assertTrue((boolean)defaultJbi.isAbsolute());
        String defaultJbiContent = IOHelper.readFileAsString((File)defaultJbi);
        File generatedComponentJbi = componentJbiGenerator.generate();
        String generatedComponentJbiContent = IOHelper.readFileAsString((File)generatedComponentJbi);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)defaultJbiContent.replaceAll("<jbi:name>petals-bc-filetransfer</jbi:name>", "<jbi:name>componentName</jbi:name>"), (String)generatedComponentJbiContent));
    }

    @Test(expected=UncheckedException.class)
    public void testGenerateButNoDefaultJbiXmlFoundInClasspath() throws Exception {
        File tempInstallationRoot = FileSystemHelper.createTempDir((String)"installationRoot");
        ComponentConfiguration componentConfiguration = new ComponentConfiguration("componentName", Logger.getAnonymousLogger());
        new ComponentJbiGenerator(ComponentType.BC_FTP, componentConfiguration, tempInstallationRoot);
    }
}

