/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.jbi.adaptor.impl.ServiceUnitJbiGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.component.api.ServiceConfiguration;

public class ServiceUnitJbiGeneratorTest {
    private static final String NAMESPACE0 = "http://testNamespace0";
    private static final String NAMESPACE1 = "http://testNamespace1";
    private static final String NAMESPACE2 = "http://testNamespace2";
    private static final QName INTERFACE0 = new QName("http://testNamespace0", "interfaceName0");
    private static final QName INTERFACE1 = new QName("http://testNamespace1", "interfaceName1");
    private static final QName INTERFACE2 = new QName("http://testNamespace2", "interfaceName2");
    private static final QName SERVICE0 = new QName("http://testNamespace0", "serviceName0");
    private static final QName SERVICE1 = new QName("http://testNamespace1", "serviceName1");
    private static final QName SERVICE2 = new QName("http://testNamespace2", "serviceName2");

    @Test
    public void testGenerateFromProvideServiceUnitConfigurationWithoutParameter() throws Exception {
        URL provideServiceUnitJbi0 = this.getClass().getClassLoader().getResource("provide-service-unit-jbi-0.xml");
        ServiceConfiguration internalServiceConfiguration = new ServiceConfiguration("testConfigurationName0", INTERFACE0, SERVICE0, "endpointName0", ServiceConfiguration.ServiceType.PROVIDE);
        this.testGenerateServiceUnitConfiguration(internalServiceConfiguration, provideServiceUnitJbi0);
    }

    @Test
    public void testGenerateFromProvideServiceUnitConfigurationWithParameters() throws Exception {
        URL provideServiceUnitJbi1 = this.getClass().getClassLoader().getResource("provide-service-unit-jbi-1.xml");
        ServiceConfiguration internalServiceConfiguration = new ServiceConfiguration("testConfigurationName1", INTERFACE1, SERVICE1, "endpointName1", ServiceConfiguration.ServiceType.PROVIDE);
        internalServiceConfiguration.setParameter("{http://parameterNamespace1}parameterName1", "parameterValue1");
        this.testGenerateServiceUnitConfiguration(internalServiceConfiguration, provideServiceUnitJbi1);
    }

    @Test
    public void testGenerateFromConsumeServiceUnitConfigurationWithoutParameter() throws Exception {
        URL provideServiceUnitJbi0 = this.getClass().getClassLoader().getResource("consume-service-unit-jbi-0.xml");
        ServiceConfiguration externalServiceConfiguration = new ServiceConfiguration("testConfigurationName0", INTERFACE0, SERVICE0, "endpointName0", ServiceConfiguration.ServiceType.CONSUME);
        this.testGenerateServiceUnitConfiguration(externalServiceConfiguration, provideServiceUnitJbi0);
    }

    @Test
    public void testGenerateFromConsumeServiceUnitConfigurationWithParameters() throws Exception {
        URL provideServiceUnitJbi1 = this.getClass().getClassLoader().getResource("consume-service-unit-jbi-1.xml");
        ServiceConfiguration externalServiceConfiguration = new ServiceConfiguration("testConfigurationName1", INTERFACE1, SERVICE1, "endpointName1", ServiceConfiguration.ServiceType.CONSUME);
        externalServiceConfiguration.setParameter("{http://parameterNamespace1}parameterName1", "parameterValue1");
        externalServiceConfiguration.setParameter("{http://petals.ow2.org/components/extensions/version-5}operation", "operation1");
        externalServiceConfiguration.setParameter("{http://petals.ow2.org/components/extensions/version-5}mep", "InOut");
        this.testGenerateServiceUnitConfiguration(externalServiceConfiguration, provideServiceUnitJbi1);
    }

    @Test
    public void testGenerateFromMultiServiceConfigurationWithParamaters() throws Exception {
        URL eipServiceUnitJbi1 = this.getClass().getClassLoader().getResource("eip-service-unit-jbi-0.xml");
        ServiceConfiguration provideServiceConfiguration = new ServiceConfiguration("testConfigurationName1", INTERFACE0, SERVICE0, "endpointName0", ServiceConfiguration.ServiceType.PROVIDE);
        provideServiceConfiguration.setParameter("{http://petals.ow2.org/components/eip/version-2}eip", "splitter");
        ServiceConfiguration consumeServiceConfiguration1 = new ServiceConfiguration("testConfigurationName2", INTERFACE1, SERVICE1, "endpointName1", ServiceConfiguration.ServiceType.CONSUME);
        consumeServiceConfiguration1.setParameter("{http://petals.ow2.org/components/extensions/version-5}mep", "InOut");
        consumeServiceConfiguration1.setParameter("{http://petals.ow2.org/components/extensions/version-5}operation", "operation1");
        ServiceConfiguration consumeServiceConfiguration2 = new ServiceConfiguration("testConfigurationName3", INTERFACE2, SERVICE2, "endpointName2", ServiceConfiguration.ServiceType.CONSUME);
        consumeServiceConfiguration2.setParameter("{http://petals.ow2.org/components/extensions/version-5}mep", "InOut");
        consumeServiceConfiguration2.setParameter("{http://petals.ow2.org/components/extensions/version-5}operation", "operation2");
        provideServiceConfiguration.addServiceConfigurationDependency(consumeServiceConfiguration1);
        provideServiceConfiguration.addServiceConfigurationDependency(consumeServiceConfiguration2);
        this.testGenerateServiceUnitConfiguration(provideServiceConfiguration, eipServiceUnitJbi1, true);
    }

    private void testGenerateServiceUnitConfiguration(ServiceConfiguration serviceConfiguration, URL expectedJbiFileUrl, boolean multiServiceGeneration) throws Exception {
        File tempInstallationRoot = FileSystemHelper.createTempDir((String)"installationRoot");
        ServiceUnitJbiGenerator provideServiceUnitJbiGenerator = new ServiceUnitJbiGenerator(serviceConfiguration, tempInstallationRoot);
        File generatedServiceUnitJbi = provideServiceUnitJbiGenerator.generate(multiServiceGeneration);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)expectedJbiFileUrl.openStream(), (InputStream)new FileInputStream(generatedServiceUnitJbi)));
    }

    private void testGenerateServiceUnitConfiguration(ServiceConfiguration serviceConfiguration, URL expectedJbiFileUrl) throws Exception {
        this.testGenerateServiceUnitConfiguration(serviceConfiguration, expectedJbiFileUrl, false);
    }
}

