/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.DOMHelper;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ComponentJbiGenerator {
    private static final Map<ComponentType, DOMSource> defaultComponentJbiUrlsByType = ComponentJbiGenerator.initializeDefaultComponentJbiUrlsByType();
    private final DOMSource jbiSource;
    private final ComponentConfiguration componentConfiguration;
    private final File installationRoot;

    public ComponentJbiGenerator(ComponentType componentType, ComponentConfiguration componentConfiguration, File installationRoot) {
        assert (componentType != null);
        assert (componentConfiguration != null);
        assert (installationRoot != null);
        this.jbiSource = this.getDefaultComponentJbiUrl(componentType);
        this.installationRoot = installationRoot;
        this.componentConfiguration = componentConfiguration;
    }

    private DOMSource getDefaultComponentJbiUrl(ComponentType componentType) {
        DOMSource domSource = defaultComponentJbiUrlsByType.get((Object)componentType);
        if (domSource == null) {
            throw new UncheckedException(String.format("Cannot generate jbi.xml for component of type '%s' ; no default jbi.xml found in classpath.", new Object[]{componentType}));
        }
        return domSource;
    }

    private static Map<ComponentType, DOMSource> initializeDefaultComponentJbiUrlsByType() {
        HashMap<ComponentType, DOMSource> jbiUrlsByType = new HashMap<ComponentType, DOMSource>();
        try {
            Enumeration<URL> defaultComponentJbiUrls = ComponentJbiGenerator.class.getClassLoader().getResources("jbi/jbi.xml");
            while (defaultComponentJbiUrls.hasMoreElements()) {
                URL defaultComponentJbiUrl = defaultComponentJbiUrls.nextElement();
                DOMSource defaultJbiSource = DOMHelper.parseAsDOMSource((URL)defaultComponentJbiUrl);
                Document document = (Document)defaultJbiSource.getNode();
                NodeList nodeList = document.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi", "component-class-name");
                assert (nodeList.getLength() == 1);
                String componentClassName = nodeList.item(0).getTextContent();
                jbiUrlsByType.put(ComponentType.fromClassName(componentClassName), defaultJbiSource);
            }
            return jbiUrlsByType;
        }
        catch (IOException ioe) {
            throw new UncheckedException((Throwable)ioe);
        }
    }

    public File generate() {
        this.replaceJbiParametersWithComponentConfigurationParameters(this.jbiSource);
        File installationRootMetaInf = new File(this.installationRoot, "META-INF");
        File jbiDumpTarget = new File(installationRootMetaInf, "jbi.xml");
        this.dumpModifiedJbi(this.jbiSource, jbiDumpTarget);
        return jbiDumpTarget;
    }

    private void dumpModifiedJbi(DOMSource jbiSource, File jbiDumpTarget) {
        StreamResult result = new StreamResult(jbiDumpTarget);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(jbiSource, result);
        }
        catch (TransformerConfigurationException tce) {
            throw new UncheckedException((Throwable)tce);
        }
        catch (TransformerException te) {
            throw new UncheckedException((Throwable)te);
        }
        finally {
            Transformers.releaseTransformer((Transformer)transformer);
        }
    }

    private void replaceJbiParameterWithComponentConfigurationParameter(DOMSource jbiSource, String componentConfigurationParameterName, String componentConfigurationParameterValue) {
        boolean isTagFound;
        assert (componentConfigurationParameterName != null);
        QName parameterQName = QName.valueOf(componentConfigurationParameterName);
        Document jbiDocument = (Document)jbiSource.getNode();
        assert (jbiDocument != null);
        NodeList parameterNodeList = jbiDocument.getElementsByTagNameNS(parameterQName.getNamespaceURI(), parameterQName.getLocalPart());
        int parameterNodeListLength = parameterNodeList.getLength();
        assert (parameterNodeListLength <= 1);
        boolean bl = isTagFound = parameterNodeListLength == 1;
        if (isTagFound) {
            Node parameterNode = parameterNodeList.item(0);
            parameterNode.setTextContent(componentConfigurationParameterValue);
        } else {
            Element parameterNode = jbiDocument.createElementNS(parameterQName.getNamespaceURI(), parameterQName.getLocalPart());
            parameterNode.setTextContent(componentConfigurationParameterValue);
            NodeList componentNodeList = jbiDocument.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi", "");
            int componentNodeListLength = componentNodeList.getLength();
            assert (componentNodeListLength == 1);
            Node componentNode = componentNodeList.item(0);
            componentNode.appendChild(parameterNode);
        }
    }

    private void replaceJbiParametersWithComponentConfigurationParameters(DOMSource jbiSource) {
        this.replaceJbiParameterWithComponentConfigurationParameter(jbiSource, String.format("{%s}name", "http://java.sun.com/xml/ns/jbi"), this.componentConfiguration.getConfigurationName());
        for (String parameterName : this.componentConfiguration.getParameterNames()) {
            this.replaceJbiParameterWithComponentConfigurationParameter(jbiSource, parameterName, this.componentConfiguration.getParameter(parameterName));
        }
    }
}

