/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.component.api.ServiceConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceUnitJbiGenerator {
    private static final String SERVICE_NAMESPACE_PREFIX = "srvNs";
    private static final String INTERFACE_NAMESPACE_PREFIX = "itfNs";
    private final ServiceConfiguration serviceConfiguration;
    private final File installationRoot;

    public ServiceUnitJbiGenerator(ServiceConfiguration serviceConfiguration, File installationRoot) {
        assert (serviceConfiguration != null);
        assert (installationRoot != null);
        this.serviceConfiguration = serviceConfiguration;
        this.installationRoot = installationRoot;
    }

    public final File generate(boolean multiservice) {
        File serviceUnitMetaInfDir = new File(this.installationRoot, "META-INF");
        File jbiDumpTarget = new File(serviceUnitMetaInfDir, "jbi.xml");
        StreamResult result = new StreamResult(jbiDumpTarget);
        Document document = DocumentBuilders.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        HashMap<String, String> jbiEltAttr = new HashMap<String, String>();
        jbiEltAttr.put("version", "1.0");
        Element jbiElement = ServiceUnitJbiGenerator.addElement(document, (Node)document, "http://java.sun.com/xml/ns/jbi", "jbi:jbi", jbiEltAttr);
        jbiElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        HashMap<String, String> servicesEltAttr = new HashMap<String, String>();
        servicesEltAttr.put("binding-component", "true");
        Element servicesElement = ServiceUnitJbiGenerator.addElement(document, (Node)jbiElement, "http://java.sun.com/xml/ns/jbi", "jbi:services", servicesEltAttr);
        this.generateServiceTypeElement(document, servicesElement, this.serviceConfiguration);
        if (multiservice) {
            for (ServiceConfiguration s : this.serviceConfiguration.getServiceConfigurationDependencies()) {
                this.generateServiceTypeElement(document, servicesElement, s);
            }
        }
        DOMSource domSource = new DOMSource(document);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(domSource, result);
            File i$ = jbiDumpTarget;
            return i$;
        }
        catch (TransformerException e) {
            throw new UncheckedException("Impossible to generate the JBI file", (Throwable)e);
        }
        finally {
            Transformers.releaseTransformer((Transformer)transformer);
        }
    }

    private void generateServiceTypeElement(Document document, Element servicesElement, ServiceConfiguration serviceConfiguration) {
        String serviceTypeElementName = "jbi:provides";
        if (ServiceConfiguration.ServiceType.CONSUME.equals((Object)serviceConfiguration.getServiceType())) {
            serviceTypeElementName = "jbi:consumes";
        }
        HashMap<String, String> serviceTypeEltAttr = new HashMap<String, String>();
        serviceTypeEltAttr.put("endpoint-name", serviceConfiguration.getEndpointName());
        serviceTypeEltAttr.put("interface-name", "itfNs:" + serviceConfiguration.getInterfaceQName().getLocalPart());
        serviceTypeEltAttr.put("service-name", "srvNs:" + serviceConfiguration.getServiceQName().getLocalPart());
        serviceTypeEltAttr.put("xmlns:srvNs", serviceConfiguration.getServiceQName().getNamespaceURI());
        serviceTypeEltAttr.put("xmlns:itfNs", serviceConfiguration.getInterfaceQName().getNamespaceURI());
        Element providesElement = ServiceUnitJbiGenerator.addElement(document, (Node)servicesElement, "http://java.sun.com/xml/ns/jbi", serviceTypeElementName, serviceTypeEltAttr);
        if (ServiceConfiguration.ServiceType.PROVIDE.equals((Object)serviceConfiguration.getServiceType())) {
            if (serviceConfiguration.getServiceDescription() != null) {
                ServiceUnitJbiGenerator.addElement(document, (Node)providesElement, "http://petals.ow2.org/components/extensions/version-5", "cdk:wsdl", serviceConfiguration.getServiceDescription().toString());
            } else {
                ServiceUnitJbiGenerator.addElement(document, providesElement, "http://petals.ow2.org/components/extensions/version-5", "cdk:wsdl");
            }
        } else if (serviceConfiguration.getParameter("{http://petals.ow2.org/components/extensions/version-5}mep") == null) {
            HashMap<String, String> mepAttr = new HashMap<String, String>();
            mepAttr.put("xsi:nil", "true");
            ServiceUnitJbiGenerator.addElement(document, (Node)providesElement, "http://petals.ow2.org/components/extensions/version-5", "cdk:mep", mepAttr);
        }
        for (String specificParameterName : serviceConfiguration.getParameterNames()) {
            if (specificParameterName.equals("{http://petals.ow2.org/components/extensions/version-5}operation")) {
                String operationQName = serviceConfiguration.getParameter(specificParameterName);
                ServiceUnitJbiGenerator.addElement(document, (Node)providesElement, "http://petals.ow2.org/components/extensions/version-5", "cdk:operation", "srvNs:" + operationQName.substring(operationQName.lastIndexOf("}") + 1));
                continue;
            }
            QName specificParameterQName = QName.valueOf(specificParameterName);
            ServiceUnitJbiGenerator.addElement(document, (Node)providesElement, specificParameterQName.getNamespaceURI(), specificParameterQName.getLocalPart(), serviceConfiguration.getParameter(specificParameterName));
        }
    }

    private static final Element addElement(Document document, Node parentNode, String namespaceUri, String qualifiedName) {
        return ServiceUnitJbiGenerator.addElement(document, parentNode, namespaceUri, qualifiedName, null, new HashMap<String, String>());
    }

    private static final Element addElement(Document document, Node parentNode, String namespaceUri, String qualifiedName, Map<String, String> attributes) {
        return ServiceUnitJbiGenerator.addElement(document, parentNode, namespaceUri, qualifiedName, null, attributes);
    }

    private static final Element addElement(Document document, Node parentNode, String namespaceUri, String qualifiedName, String value) {
        return ServiceUnitJbiGenerator.addElement(document, parentNode, namespaceUri, qualifiedName, value, new HashMap<String, String>());
    }

    private static final Element addElement(Document document, Node parentNode, String namespaceUri, String qualifiedName, String value, Map<String, String> attributes) {
        Element newElement = document.createElementNS(namespaceUri, qualifiedName);
        if (value != null) {
            newElement.setTextContent(value);
        }
        for (String attributeName : attributes.keySet()) {
            newElement.setAttribute(attributeName, attributes.get(attributeName));
        }
        parentNode.appendChild(newElement);
        return newElement;
    }
}

