/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.io.ZipHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.jbi.adaptor.impl.AbstractWrappedToComponentMessage;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentJbiGenerator;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.ServiceUnitJbiGenerator;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestFromConsumerMessage;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedResponseFromProviderMessage;
import com.ebmwebsourcing.jbi.adaptor.impl.mock.MockComponentContext;
import com.ebmwebsourcing.jbi.adaptor.impl.mock.MockDeliveryChannel;
import com.ebmwebsourcing.jbi.adaptor.impl.mock.MockInstallationContext;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.jbi.JBIException;
import javax.jbi.component.InstallationContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.component.api.Component;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.ow2.petals.component.api.Message;
import org.ow2.petals.component.api.ServiceConfiguration;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.JBIBootstrap;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.JBIProcessorManagerObserver;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class WrappedComponent
implements Component {
    private static final List<String> startedComponents = new ArrayList<String>();
    private static final String JBI_DIR_NAME = "jbi";
    private final File componentRepositoryRoot;
    private final ComponentType componentType;
    private final ComponentConfiguration componentConfiguration;
    private final Jbi jbi;
    private final AbstractComponent component;
    private MockComponentContext mockComponentContext;

    public WrappedComponent(ComponentType componentType, ComponentConfiguration componentConfiguration) {
        assert (componentConfiguration != null);
        this.componentRepositoryRoot = WrappedComponent.createComponentRepositoryRoot();
        System.out.println(String.format("------------- Created component repository root '%s'", this.componentRepositoryRoot));
        this.componentType = componentType;
        this.componentConfiguration = componentConfiguration;
        this.jbi = this.generateComponentJbi();
        this.copyOthersJbiResources();
        this.copyJbiResources(componentConfiguration.getResources(), this.getInstallRoot());
        this.component = this.createComponent(this.jbi.getComponent().getComponentClassName().getContent());
        this.initialize();
    }

    private final File getInstallRoot() {
        return new File(this.componentRepositoryRoot, "install");
    }

    private final File getWorkspaceRoot() {
        return new File(this.componentRepositoryRoot, "work");
    }

    private Jbi generateComponentJbi() {
        FileInputStream fis;
        ComponentJbiGenerator componentJbiGenerator = new ComponentJbiGenerator(this.componentType, this.componentConfiguration, this.getInstallRoot());
        componentJbiGenerator.generate();
        File generatedJbiFile = new File(this.getInstallRoot() + File.separator + "META-INF" + File.separator, "jbi.xml");
        assert (generatedJbiFile.exists());
        try {
            fis = new FileInputStream(generatedJbiFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new UncheckedException((Throwable)fnfe);
        }
        assert (generatedJbiFile.exists());
        try {
            Jbi fnfe = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)fis);
            return fnfe;
        }
        catch (CDKJBIDescriptorException cjde) {
            throw new UncheckedException((Throwable)cjde);
        }
        finally {
            IOHelper.close((Closeable)fis);
        }
    }

    private final String getComponentName() {
        return this.jbi.getComponent().getIdentification().getName();
    }

    private void copyOthersJbiResources() {
        String componentClassName = this.componentType.getClassName();
        String componentClassFilePath = componentClassName.replaceAll("\\.", "/") + ".class";
        URL componentClassFileUrl = this.getClass().getClassLoader().getResource(componentClassFilePath);
        assert (componentClassFileUrl != null);
        String componentClassFileUrlStr = componentClassFileUrl.toString();
        String componentBasePathPrefix = componentClassFileUrlStr.substring(0, componentClassFileUrlStr.indexOf(componentClassFilePath));
        URL executionDirUrl = null;
        try {
            Enumeration<URL> jbiFolderUrls = this.getClass().getClassLoader().getResources(JBI_DIR_NAME);
            while (jbiFolderUrls.hasMoreElements()) {
                URL jbiFolderUrl = jbiFolderUrls.nextElement();
                if (!jbiFolderUrl.toString().startsWith(componentBasePathPrefix)) continue;
                executionDirUrl = jbiFolderUrl;
            }
        }
        catch (IOException ioe) {
            throw new UncheckedException((Throwable)ioe);
        }
        assert (executionDirUrl != null);
        try {
            if (executionDirUrl.getProtocol().equals("jar")) {
                String executionDirStr = executionDirUrl.toString();
                int executionJarEndIndex = executionDirStr.indexOf(".jar!") + ".jar".length();
                assert (executionJarEndIndex != -1);
                String executionJarStr = executionDirStr.substring("jar:file:".length(), executionJarEndIndex);
                JarFile executionJar = new JarFile(executionJarStr);
                File jbiDirExtractedFromComponentJar = FileSystemHelper.createTempDir((String)"jbiDirExtractedFromComponentJar");
                ZipHelper.extractEntriesFromArchive((ZipFile)executionJar, (String)(JBI_DIR_NAME + File.separator), (File)jbiDirExtractedFromComponentJar);
                this.copyAllJbiDirContentExceptJbiXmlFile(new File(jbiDirExtractedFromComponentJar, JBI_DIR_NAME));
            } else {
                File executionDir = new File(executionDirUrl.toURI());
                this.copyAllJbiDirContentExceptJbiXmlFile(executionDir);
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    private void copyAllJbiDirContentExceptJbiXmlFile(File jbiDir) throws IOException {
        for (File fileInJbiDir : jbiDir.listFiles()) {
            if ("jbi.xml".equals(fileInJbiDir.getName())) continue;
            if (fileInJbiDir.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)fileInJbiDir, (File)this.getInstallRoot());
                continue;
            }
            FileUtils.copyFileToDirectory((File)fileInJbiDir, (File)this.getInstallRoot());
        }
    }

    private void copyJbiResources(URL[] resourceUrls, File installationRoot) {
        for (URL resourceUrl : resourceUrls) {
            try {
                if (resourceUrl.getProtocol().equals("jar")) continue;
                File resourceFile = new File(resourceUrl.toURI());
                if (resourceFile.isDirectory()) {
                    FileUtils.copyDirectory((File)resourceFile, (File)installationRoot);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)resourceFile, (File)installationRoot);
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e);
            }
        }
    }

    private AbstractComponent createComponent(String componentClassName) {
        try {
            return (AbstractComponent)Class.forName(componentClassName).newInstance();
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    private static final File createComponentRepositoryRoot() {
        try {
            return FileSystemHelper.createTempDir((String)"repository");
        }
        catch (IOException ioe) {
            throw new UncheckedException((Throwable)ioe);
        }
    }

    public void initialize() {
        this.mockComponentContext = new MockComponentContext(this.jbi.getComponent().getIdentification().getName(), this.component, this.getInstallRoot().getAbsolutePath(), this.getWorkspaceRoot().getAbsolutePath(), this.componentConfiguration.getLogger());
        MockInstallationContext mockInstallationContext = new MockInstallationContext(this.getInstallRoot(), this.jbi, this.mockComponentContext, true);
        try {
            Class<?> jbiBootstrapClass = Class.forName(this.jbi.getComponent().getBootstrapClassName());
            JBIBootstrap jbiBootstrap = (JBIBootstrap)jbiBootstrapClass.newInstance();
            jbiBootstrap.init((InstallationContext)mockInstallationContext);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
        try {
            this.component.init(mockInstallationContext.getContext());
        }
        catch (JBIException jbie) {
            throw new UncheckedException((Throwable)jbie);
        }
    }

    public void start() {
        try {
            this.component.start();
            startedComponents.add(this.getComponentName());
        }
        catch (JBIException e) {
            throw new UncheckedException("Impossible to start the wrapped component", (Throwable)e);
        }
    }

    public boolean isStarted() {
        return startedComponents.contains(this.getComponentName());
    }

    public void stop() {
        try {
            AbstractServiceUnitManager serviceUnitManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
            for (String serviceUnitName : serviceUnitManager.getServiceUnitDataHandlers().keySet()) {
                serviceUnitManager.stop(serviceUnitName);
            }
            this.component.stop();
            this.component.shutDown();
            startedComponents.remove(this.getComponentName());
        }
        catch (JBIException e) {
            throw new UncheckedException("Impossible to stop the wrapped component", (Throwable)e);
        }
    }

    public boolean isStopped() {
        return !this.isStarted();
    }

    public void installService(ServiceConfiguration serviceConfiguration) {
        try {
            AbstractServiceUnitManager serviceUnitManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
            File serviceAssembliesInstallRoot = new File(this.componentRepositoryRoot, "service-assembliesInstall");
            String suName = serviceConfiguration.getConfigurationName();
            File serviceUnitDir = new File(serviceAssembliesInstallRoot, suName);
            this.copyJbiResources(serviceConfiguration.getResources(), serviceUnitDir);
            ServiceUnitJbiGenerator serviceUnitJbiGenerator = new ServiceUnitJbiGenerator(serviceConfiguration, serviceUnitDir);
            boolean multiservice = false;
            if (ComponentType.SE_EIP.equals((Object)this.componentType)) {
                multiservice = true;
            }
            serviceUnitJbiGenerator.generate(multiservice);
            serviceUnitManager.deploy(suName, serviceUnitDir.getAbsolutePath());
            serviceUnitManager.init(suName, serviceUnitDir.getAbsolutePath());
            serviceUnitManager.start(suName);
        }
        catch (DeploymentException e) {
            throw new UncheckedException("Impossible to install the specified service", (Throwable)e);
        }
    }

    public void uninstallService(ServiceConfiguration serviceConfiguration) {
        try {
            AbstractServiceUnitManager serviceUnitManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
            Map serviceUnitDataHandlers = serviceUnitManager.getServiceUnitDataHandlers();
            String suName = serviceConfiguration.getConfigurationName();
            ServiceUnitDataHandler serviceUnitDataHandler = (ServiceUnitDataHandler)serviceUnitDataHandlers.get(suName);
            serviceUnitManager.stop(suName);
            serviceUnitManager.shutDown(suName);
            serviceUnitManager.undeploy(suName, serviceUnitDataHandler.getInstallRoot());
        }
        catch (DeploymentException e) {
            throw new UncheckedException("Impossible to uninstall the specified service", (Throwable)e);
        }
    }

    public void uninstallAllServices() {
        try {
            AbstractServiceUnitManager serviceUnitManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
            for (ServiceUnitDataHandler serviceUnitDataHandler : serviceUnitManager.getServiceUnitDataHandlers().values()) {
                String suName = serviceUnitDataHandler.getName();
                serviceUnitManager.stop(suName);
                serviceUnitManager.shutDown(suName);
                serviceUnitManager.undeploy(suName, serviceUnitDataHandler.getInstallRoot());
            }
        }
        catch (DeploymentException e) {
            throw new UncheckedException("Impossible to uninstall all the services", (Throwable)e);
        }
    }

    public boolean isServiceInstalled(ServiceConfiguration serviceConfiguration) {
        AbstractServiceUnitManager serviceUnitManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
        String suName = serviceConfiguration.getConfigurationName();
        return serviceUnitManager.getServiceUnitDataHandlers().containsKey(suName);
    }

    public void processMessageFromServiceBus(Message message) {
        assert (message instanceof AbstractWrappedToComponentMessage);
        AbstractWrappedToComponentMessage wrappedMessage = (AbstractWrappedToComponentMessage)message;
        try {
            final MessageExchange msgExchange = wrappedMessage.getMessageExchange();
            final Semaphore sem = new Semaphore(0);
            JBIProcessorManager processorManager = this.component.getProcessorManager();
            JBIProcessorManagerObserver jbiProccesorManagerObserver = new JBIProcessorManagerObserver(){

                public void beforeProcessingMessage(Exchange exchange) {
                }

                public void afterProcessingMessage(Exchange exchange) {
                    try {
                        MessageExchange msgExchangeProcessed = ((ExchangeImpl)exchange).getMessageExchange();
                        if (msgExchangeProcessed.getExchangeId().equals(msgExchange.getExchangeId())) {
                            sem.release();
                        }
                    }
                    catch (MessagingException e) {
                        throw new UncheckedException("Impossible to send a message from kernel", (Throwable)e);
                    }
                }
            };
            processorManager.addObserver(jbiProccesorManagerObserver);
            ((MockDeliveryChannel)this.component.getContext().getDeliveryChannel()).enqueueIncomingMessage(msgExchange);
            sem.acquire();
            processorManager.deleteObserver(jbiProccesorManagerObserver);
        }
        catch (InterruptedException e) {
            throw new UncheckedException("Impossible to send a message from kernel", (Throwable)e);
        }
        catch (MessagingException e) {
            throw new UncheckedException("Impossible to send a message from kernel", (Throwable)e);
        }
    }

    private final void pushMessageInDeliveryChannel(Message message) {
        AbstractWrappedToComponentMessage wrappedMessage = (AbstractWrappedToComponentMessage)message;
        try {
            MessageExchange msgExchange = wrappedMessage.getMessageExchange();
            ((MockDeliveryChannel)this.component.getContext().getDeliveryChannel()).enqueueIncomingMessage(msgExchange);
        }
        catch (MessagingException e) {
            throw new UncheckedException("Impossible to push a message", (Throwable)e);
        }
    }

    public void pushRequestToProvider(Message message) {
        this.pushMessageInDeliveryChannel(message);
    }

    public void pushResponseToConsumer(Message message) {
        this.pushMessageInDeliveryChannel(message);
    }

    public Message pollResponseFromProvider() {
        try {
            MessageExchange msgExchange = ((MockDeliveryChannel)this.component.getContext().getDeliveryChannel()).dequeueResponseToClient();
            assert (!msgExchange.getPattern().equals(Message.MEPConstants.IN_ONLY_PATTERN)) : "Polling response from provider while processing an in only exchange is meaningless.";
            return new WrappedResponseFromProviderMessage(msgExchange);
        }
        catch (MessagingException e) {
            throw new UncheckedException("Impossible to poll response to consumer message", (Throwable)e);
        }
    }

    public Message pollRequestFromConsumer() {
        try {
            MessageExchange msgExchange = ((MockDeliveryChannel)this.component.getContext().getDeliveryChannel()).dequeueRequestToServer();
            return new WrappedRequestFromConsumerMessage(msgExchange);
        }
        catch (MessagingException e) {
            throw new UncheckedException("Impossible to poll request to provider message", (Throwable)e);
        }
    }
}

