/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.jbi.adaptor.impl.AbstractWrappedToComponentMessage;
import java.io.InputStream;
import java.net.URI;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.mockito.Mockito;
import org.ow2.petals.commons.log.FlowAttributes;
import org.ow2.petals.component.api.ServiceConfiguration;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;

public class WrappedRequestToProviderMessage
extends AbstractWrappedToComponentMessage {
    public WrappedRequestToProviderMessage(ServiceConfiguration serviceConfiguration, QName operation, URI mep, InputStream inMessageContentStream, FlowAttributes flowAttributes) {
        super(serviceConfiguration, operation, mep, flowAttributes);
        try {
            this.setRole(MessageExchange.Role.CONSUMER);
            NormalizedMessage inNm = this.messageExchange.createMessage();
            inNm.setContent((Source)new StreamSource(inMessageContentStream));
            this.messageExchange.setMessage(inNm, "in");
            this.setRole(MessageExchange.Role.PROVIDER);
        }
        catch (MessagingException e) {
            throw new UncheckedException("Impossible to create a message exchange", (Throwable)e);
        }
    }

    public WrappedRequestToProviderMessage(MessageExchange messageExchange) {
        super(messageExchange);
        ServiceEndpoint mockServiceEndpoint = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);
        ServiceEndpoint endpoint = messageExchange.getEndpoint();
        String endpointName = null;
        if (endpoint != null) {
            endpointName = endpoint.getEndpointName();
        }
        QName serviceName = messageExchange.getService();
        Mockito.when((Object)mockServiceEndpoint.getEndpointName()).thenReturn((Object)endpointName);
        Mockito.when((Object)mockServiceEndpoint.getServiceName()).thenReturn((Object)serviceName);
        messageExchange.setEndpoint(mockServiceEndpoint);
        ((MessageExchangeWrapper)messageExchange).setObserverRole(MessageExchange.Role.PROVIDER);
        this.setRole(MessageExchange.Role.PROVIDER);
    }

    public String getPayload() {
        return this.getPayload("in");
    }
}

