/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl.mock;

import com.ebmwebsourcing.jbi.adaptor.impl.mock.MockDeliveryChannel;
import com.ebmwebsourcing.jbi.adaptor.impl.mock.MockServiceEndpoint;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.mockito.Mockito;
import org.ow2.petals.component.framework.AbstractComponent;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class MockComponentContext
implements ComponentContext {
    private final String installRoot;
    private final String workspaceRoot;
    private final Logger logger;
    private final MockDeliveryChannel deliveryChannel;
    private final MBeanServer mockMBeanServer;
    private final MBeanNames mockMBeanNames;
    private final String componentName;
    private static Vector<MockServiceEndpoint> serviceEndpoints = new Vector();
    private final AbstractComponent jbiComponent;

    public MockComponentContext(String componentName, AbstractComponent jbiComponent, String installRoot, String workspaceRoot, Logger logger) {
        this.componentName = componentName;
        this.installRoot = installRoot;
        this.workspaceRoot = workspaceRoot;
        this.jbiComponent = jbiComponent;
        this.logger = logger;
        this.deliveryChannel = new MockDeliveryChannel(logger);
        this.mockMBeanServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        this.mockMBeanNames = (MBeanNames)Mockito.mock(MBeanNames.class);
    }

    public ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        MockServiceEndpoint mockServiceEndpoint = new MockServiceEndpoint(endpointName, serviceName);
        Document description = this.jbiComponent.getServiceDescription((ServiceEndpoint)mockServiceEndpoint);
        mockServiceEndpoint.setDescription(description);
        serviceEndpoints.add(mockServiceEndpoint);
        return mockServiceEndpoint;
    }

    public void deactivateEndpoint(ServiceEndpoint endpoint) throws JBIException {
        serviceEndpoints.remove(endpoint);
    }

    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
    }

    public String getComponentName() {
        return this.componentName;
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        return this.deliveryChannel;
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        return this.resolveServiceEndpoint(service, name);
    }

    private MockServiceEndpoint resolveServiceEndpoint(QName service, String name) {
        MockServiceEndpoint result = null;
        for (MockServiceEndpoint serviceEndpoint : serviceEndpoints) {
            if (!name.equals(serviceEndpoint.getEndpointName()) || !service.equals(serviceEndpoint.getServiceName())) continue;
            result = serviceEndpoint;
            break;
        }
        return result;
    }

    public static ServiceEndpoint resolveServiceEndpoint(QName service) {
        MockServiceEndpoint result = null;
        for (MockServiceEndpoint serviceEndpoint : serviceEndpoints) {
            if (!service.equals(serviceEndpoint.getServiceName())) continue;
            result = serviceEndpoint;
            break;
        }
        return result;
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        MockServiceEndpoint mockServiceEnpoint = this.resolveServiceEndpoint(endpoint.getServiceName(), endpoint.getEndpointName());
        Document description = mockServiceEnpoint.getDescription();
        return description;
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        return null;
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        return null;
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        return null;
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        return null;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public Logger getLogger(String suffix, String resourceBundleName) throws MissingResourceException, JBIException {
        return this.logger;
    }

    public MBeanNames getMBeanNames() {
        return this.mockMBeanNames;
    }

    public MBeanServer getMBeanServer() {
        return this.mockMBeanServer;
    }

    public InitialContext getNamingContext() {
        return null;
    }

    public Object getTransactionManager() {
        return null;
    }

    public String getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }
}

