/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.jbi.adaptor.impl.mock;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.jbi.adaptor.impl.exchange.ContextualMessageExchangeFactoryImpl;
import com.ebmwebsourcing.jbi.adaptor.impl.mock.MockComponentContext;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.mockito.Mockito;

public class MockDeliveryChannel
implements DeliveryChannel {
    private final Logger logger;
    private final LinkedBlockingQueue<MessageExchange> incomingMessagesQueue;
    private final LinkedBlockingQueue<MessageExchange> responsesToClientQueue;
    private final LinkedBlockingQueue<MessageExchange> requestsToServerQueue;
    private String synchronousExchangeId;
    private final Semaphore synchronousExchangeSemaphore = new Semaphore(0);

    public MockDeliveryChannel(Logger logger) {
        this.logger = logger;
        this.incomingMessagesQueue = new LinkedBlockingQueue();
        this.responsesToClientQueue = new LinkedBlockingQueue();
        this.requestsToServerQueue = new LinkedBlockingQueue();
    }

    public void enqueueIncomingMessage(MessageExchange msgExchange) {
        try {
            this.incomingMessagesQueue.put(msgExchange);
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public void enqueueRequestToServer(MessageExchange msgExchange) {
        try {
            this.requestsToServerQueue.put(msgExchange);
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public void enqueueResponseToClient(MessageExchange msgExchange) {
        try {
            this.responsesToClientQueue.put(msgExchange);
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public MessageExchange dequeueIncomingMessage() {
        try {
            return this.incomingMessagesQueue.take();
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public MessageExchange dequeueRequestToServer() {
        try {
            return this.requestsToServerQueue.take();
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public MessageExchange dequeueResponseToClient() {
        try {
            return this.responsesToClientQueue.take();
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public MessageExchange accept() throws MessagingException {
        try {
            MessageExchange exchange = this.incomingMessagesQueue.take();
            if (exchange.getExchangeId().equals(this.synchronousExchangeId)) {
                this.synchronousExchangeSemaphore.release();
                return this.accept();
            }
            return exchange;
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public MessageExchange accept(long timeoutMS) throws MessagingException, IllegalArgumentException {
        return null;
    }

    public void close() throws MessagingException {
    }

    public MessageExchangeFactory createExchangeFactory() {
        ContextualMessageExchangeFactoryImpl exchangeFactoryImpl = ContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactory((ServiceEndpoint)Mockito.mock(ServiceEndpoint.class), this.logger);
        return exchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        ContextualMessageExchangeFactoryImpl exchangeFactoryImpl = ContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForInterface((ServiceEndpoint)Mockito.mock(ServiceEndpoint.class), this.logger, interfaceName);
        return exchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        ContextualMessageExchangeFactoryImpl exchangeFactoryImpl = ContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForEndpoint((ServiceEndpoint)Mockito.mock(ServiceEndpoint.class), this.logger, endpoint);
        return exchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        ContextualMessageExchangeFactoryImpl exchangeFactoryImpl = ContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForService((ServiceEndpoint)Mockito.mock(ServiceEndpoint.class), this.logger, serviceName);
        return exchangeFactoryImpl;
    }

    public void send(MessageExchange messageExchange) throws MessagingException {
        if (messageExchange.getEndpoint() == null) {
            this.resolveEndpoint(messageExchange);
        }
        try {
            if (messageExchange.getRole().equals(MessageExchange.Role.PROVIDER)) {
                this.responsesToClientQueue.put(messageExchange);
            } else {
                this.requestsToServerQueue.put(messageExchange);
            }
        }
        catch (InterruptedException e) {
            new UncheckedException((Throwable)e);
        }
    }

    private void resolveEndpoint(MessageExchange messageExchange) throws MessagingException {
        ServiceEndpoint endpoint = MockComponentContext.resolveServiceEndpoint(messageExchange.getService());
        if (endpoint == null) {
            throw new MessagingException("Endpoint not avalaible");
        }
        messageExchange.setEndpoint(endpoint);
    }

    public boolean sendSync(MessageExchange msgExchange) throws MessagingException {
        return this.sendSync(msgExchange, 0L);
    }

    public boolean sendSync(MessageExchange msgExchange, long timeoutMS) throws MessagingException {
        boolean returnValue = false;
        this.synchronousExchangeId = msgExchange.getExchangeId();
        this.send(msgExchange);
        try {
            if (timeoutMS > 0L) {
                returnValue = this.synchronousExchangeSemaphore.tryAcquire(timeoutMS, TimeUnit.MILLISECONDS);
            } else {
                this.synchronousExchangeSemaphore.acquire();
                returnValue = true;
            }
        }
        catch (InterruptedException e) {
            new UncheckedException((Throwable)e);
        }
        return returnValue;
    }
}

