/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.junit.Before;
import org.ow2.petals.plugin.jbiplugin.JBIPackageMojo;
import org.ow2.petals.plugin.jbiplugin.environement.GlobalUnitTestEnvironnement;

public abstract class JBIAbstractTestMojo
extends AbstractMojoTestCase {
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactResolver mavenArtifactResolver;
    protected ArtifactFactory mavenArtifactFactory;
    protected MavenSettingsBuilder mavenSettingsBuilder;
    protected MavenEmbedder mavenEmbedder = new MavenEmbedder();
    private static final String DEBUGMODE_PROP_NAME = "DEBUG_MODE";
    protected boolean debugMode;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.debugMode = Boolean.valueOf(System.getenv(DEBUGMODE_PROP_NAME));
        this.mavenProjectBuilder = (MavenProjectBuilder)this.getContainer().lookup(MavenProjectBuilder.ROLE);
        this.mavenArtifactResolver = (ArtifactResolver)this.getContainer().lookup(ArtifactResolver.ROLE);
        this.mavenArtifactFactory = (ArtifactFactory)this.getContainer().lookup(ArtifactFactory.ROLE);
        this.mavenSettingsBuilder = (MavenSettingsBuilder)this.getContainer().lookup(MavenSettingsBuilder.ROLE);
        this.mavenEmbedder.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.mavenEmbedder.setLogger((MavenEmbedderLogger)new MavenEmbedderConsoleLogger());
        if (this.debugMode) {
            this.mavenEmbedder.getLogger().setThreshold(0);
        }
        this.mavenEmbedder.start();
    }

    protected JBIPackageMojo getPackageMojo(File pomXml) throws Exception {
        JBIPackageMojo mojo = (JBIPackageMojo)this.lookupMojo("jbi-package", pomXml);
        MavenProject componentProject = this.mavenEmbedder.readProjectWithDependencies(pomXml);
        mojo.mavenProjectBuilder = this.mavenProjectBuilder;
        mojo.artifactResolver = this.mavenArtifactResolver;
        mojo.artifactFactory = this.mavenArtifactFactory;
        mojo.localRepository = this.mavenEmbedder.createLocalRepository(this.mavenSettingsBuilder.buildSettings(true));
        mojo.toExcludes = "foo";
        mojo.verbose = true;
        mojo.project = componentProject;
        mojo.projectArtifact = componentProject.getArtifact();
        mojo.jbiName = componentProject.getArtifactId() + "-" + componentProject.getVersion();
        mojo.jbiDirectory = new File(new File(GlobalUnitTestEnvironnement.PACKAGE_UNIT_TESTS_SRC_HOME, componentProject.getArtifactId()), "/src/main/jbi");
        mojo.outputDirectory = new File(new File(GlobalUnitTestEnvironnement.UNIT_TESTS_TARGET_HOME, componentProject.getArtifactId()), "target");
        mojo.updateJBIXml = true;
        mojo.componentNameMapping = "${artifactId}";
        return mojo;
    }

    protected JBIPackageMojo getPackageMojo(File pomXml, String goal) throws Exception {
        JBIPackageMojo mojo = (JBIPackageMojo)this.lookupMojo(goal, pomXml);
        MavenProject componentProject = this.mavenEmbedder.readProjectWithDependencies(pomXml);
        mojo.mavenProjectBuilder = this.mavenProjectBuilder;
        mojo.artifactResolver = this.mavenArtifactResolver;
        mojo.artifactFactory = this.mavenArtifactFactory;
        mojo.localRepository = this.mavenEmbedder.createLocalRepository(this.mavenSettingsBuilder.buildSettings(true));
        mojo.toExcludes = "foo";
        mojo.verbose = true;
        mojo.project = componentProject;
        mojo.projectArtifact = componentProject.getArtifact();
        mojo.jbiName = componentProject.getArtifactId() + "-" + componentProject.getVersion();
        mojo.jbiDirectory = new File(new File(GlobalUnitTestEnvironnement.PACKAGE_UNIT_TESTS_SRC_HOME, componentProject.getArtifactId()), "/src/main/jbi");
        mojo.outputDirectory = new File(new File(GlobalUnitTestEnvironnement.UNIT_TESTS_TARGET_HOME, componentProject.getArtifactId()), "target");
        mojo.updateJBIXml = true;
        mojo.componentNameMapping = "${artifactId}";
        return mojo;
    }
}

