/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junitx.framework.Assert;
import org.junit.Test;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.ClassPath;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractTestMojo;
import org.ow2.petals.plugin.jbiplugin.JBIPackageMojo;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithAdditionalJBIResources;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithReleaseTransitiveDependency;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithSnapshotTransitiveDependency;

public class JBIPackageMojoTest
extends JBIAbstractTestMojo {
    @Test
    public void testPackageComponentWithSnapshotTransitiveDependency() throws Exception {
        File componentPomFile = new File(ComponentWithSnapshotTransitiveDependency.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithSnapshotTransitiveDependency.TARGET_HOME, "component-with-snapshot-transitive-dependency-1.0.0-TEST-SNAPSHOT.zip"));
        Assert.assertNotNull((String)"Snapshot dependency is missing in the packaged JBI component", (Object)packagedComponentFile.getEntry("test-1.0-SNAPSHOT.jar"));
        Assert.assertNotNull((String)"Snapshot transitive dependency is missing in the packaged JBI component", (Object)packagedComponentFile.getEntry("transitive-test-1.0-SNAPSHOT.jar"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        ClassPath jbiClassPath = jbiComponent.getBootstrapClassPath();
        Assert.assertNotNull((String)"The boostrap classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        List jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"Snapshot dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0-SNAPSHOT.jar"));
        Assert.assertTrue((String)"Snapshot transitive dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0-SNAPSHOT.jar"));
        jbiClassPath = jbiComponent.getComponentClassPath();
        Assert.assertNotNull((String)"The component classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"Snapshot dependency is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0-SNAPSHOT.jar"));
        Assert.assertTrue((String)"Snapshot transitive dependency is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0-SNAPSHOT.jar"));
    }

    @Test
    public void testPackageComponentWithRealeaseTransitiveDependency() throws Exception {
        File componentPomFile = new File(ComponentWithReleaseTransitiveDependency.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithReleaseTransitiveDependency.TARGET_HOME, "component-with-release-transitive-dependency-1.0.0-TEST.zip"));
        Assert.assertNotNull((String)"Release dependency is missing in the packaged JBI component", (Object)packagedComponentFile.getEntry("test-1.0.jar"));
        Assert.assertNotNull((String)"Release transitive dependency is missing in the packaged JBI component", (Object)packagedComponentFile.getEntry("transitive-test-1.0.jar"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        ClassPath jbiClassPath = jbiComponent.getBootstrapClassPath();
        Assert.assertNotNull((String)"The boostrap classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        List jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"Release dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"Release transitive dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0.jar"));
        jbiClassPath = jbiComponent.getComponentClassPath();
        Assert.assertNotNull((String)"The component classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"Release dependency is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"Release transitive dependency is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0.jar"));
    }

    @Test
    public void testPackageComponentWithAdditionalJBIResources() throws Exception {
        File componentPomFile = new File(ComponentWithAdditionalJBIResources.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithAdditionalJBIResources.TARGET_HOME, "component-with-additional-jbi-resources-1.0.0-TEST.zip"));
        Assert.assertNotNull((String)"Addition JBI resource is missing in the packaged JBI component", (Object)packagedComponentFile.getEntry("additional.wsdl"));
        Assert.assertNotNull((String)"Addition JBI resource is missing in the packaged JBI component", (Object)packagedComponentFile.getEntry("/additionalDirectory/"));
        Assert.assertTrue((String)"Addition JBI resource isn't a directory", (boolean)packagedComponentFile.getEntry("/additionalDirectory/").isDirectory());
        Assert.assertNotNull((String)"Addition JBI resource is missing in the packaged JBI component", (Object)packagedComponentFile.getEntry("/additionalDirectory/additional2.wsdl"));
    }
}

