/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin;

import java.net.URL;
import org.ow2.petals.admin.RegistryMock;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.lifecycle.ServiceAssemblyLifecycle;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;

public class ServiceAssemblyLifecycleMock
extends ServiceAssemblyLifecycle {
    public ServiceAssemblyLifecycleMock(ServiceAssembly sa) {
        super(sa);
    }

    public void deploy(URL artifactUrl) throws ArtifactAdministrationException {
        RegistryMock.getInstance().add((Artifact)this.getServiceAssembly());
    }

    public void start() throws ArtifactAdministrationException {
        ServiceAssembly found = (ServiceAssembly)RegistryMock.getInstance().get((Artifact)this.getServiceAssembly());
        if (found == null) {
            throw new ArtifactAdministrationException("Artifact not found in registry. Can not update state");
        }
        found.setState(ArtifactState.State.STARTED);
    }

    public void stop() throws ArtifactAdministrationException {
        ServiceAssembly found = (ServiceAssembly)RegistryMock.getInstance().get((Artifact)this.getServiceAssembly());
        if (found == null) {
            throw new ArtifactAdministrationException("Artifact not found in registry. Can not update state");
        }
        found.setState(ArtifactState.State.STOPPED);
    }

    public void undeploy() throws ArtifactAdministrationException {
        RegistryMock.getInstance().remove((Artifact)this.getServiceAssembly());
    }

    public void updateState() throws ArtifactAdministrationException {
        ServiceAssembly found = (ServiceAssembly)RegistryMock.getInstance().get((Artifact)this.getServiceAssembly());
        if (found == null) {
            throw new ArtifactAdministrationException("Artifact not found in registry. Can not update state");
        }
        this.getServiceAssembly().setState(found.getState());
    }
}

