/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PutFileService
extends AbstractFileService {
    public PutFileService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process PUT operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("put", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        Node root = inMessageDoc.getFirstChild();
        if (root == null || !"put".equalsIgnoreCase(root.getLocalName())) {
            throw new MessagingException("Missing element : put");
        }
        try {
            Node filePatternNode = XMLHelper.findChild((Node)inMessageDoc.getFirstChild(), null, (String)"filename", (boolean)false);
            String filePattern = null;
            if (filePatternNode != null) {
                filePattern = filePatternNode.getTextContent();
            }
            this.addMonitBeginStepExtTrace(filePattern, FileTransferUtils.getFolderPath(this.extensions).getName());
            this.copySource(exchange, root.getFirstChild());
        }
        catch (TransformerException e) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put non-xml content : TransformerException : ");
            errorSB.append(e.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        catch (IOException e) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put XML content : IOException : ");
            errorSB.append(e.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        catch (PoolException e) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Unable to get a XML transformer : PoolException : ");
            errorSB.append(e.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("PUT operation ended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySource(Exchange exchange, Node contentNode) throws IOException, TransformerException {
        File directory = FileTransferUtils.getFolderPath(this.extensions);
        String fileName = this.getTargetFileName(exchange);
        File target = new File(directory, fileName);
        this.logger.info("Source transfer to file : " + target.getAbsolutePath());
        DOMSource source = new DOMSource(contentNode);
        FileOutputStream fos = new FileOutputStream(target);
        StreamResult streamResult = new StreamResult(fos);
        Transformer transformer = Transformers.takeTransformer();
        if (contentNode.getNodeType() == 3) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("process content as text");
            }
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("process content as xml");
            }
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
        }
        try {
            transformer.transform(source, streamResult);
        }
        finally {
            fos.close();
            Transformers.releaseTransformer((Transformer)transformer);
        }
    }
}

