/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.consume;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.bc.filetransfer.FileTransferComponent;
import org.ow2.petals.bc.filetransfer.FileTransferConsumeFlowStepBeginLogData;
import org.ow2.petals.bc.filetransfer.listeners.FileTransferExternalListener;
import org.ow2.petals.bc.filetransfer.service.consume.ConsumeConfiguration;
import org.ow2.petals.bc.filetransfer.service.consume.ExternalEventPoller;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.LoggingUtil;
import org.w3c.dom.Document;

public class ExternalEventProcessor
implements Runnable {
    private final ConsumeConfiguration configuration;
    private final FileTransferExternalListener consumeContext;
    private final Logger logger;
    private final File originalFile;

    public ExternalEventProcessor(File file, ExternalEventPoller pollerContext) {
        this.originalFile = file;
        this.consumeContext = pollerContext.getConsumeContext();
        this.configuration = pollerContext.getConfiguration();
        this.logger = pollerContext.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            Document finalMsg = null;
            Exchange exchange = null;
            String fileName = this.originalFile.getName();
            File backupFile = null;
            File lockFile = new File(this.originalFile.getAbsolutePath() + ".lock");
            PetalsExecutionContext.initFlowInstanceId();
            PetalsExecutionContext.nextFlowStepId();
            try {
                if (lockFile.createNewFile()) {
                    try {
                        if (this.originalFile.exists()) {
                            this.logger.info("process file : " + this.originalFile.getName());
                            backupFile = this.configuration.getBackupDirectory() == null ? this.moveFile(this.originalFile, new File(System.getProperty("java.io.tmpdir"))) : this.moveFile(this.originalFile, this.configuration.getBackupDirectory());
                            if (this.configuration.isBaseMsgOn()) {
                                if (this.logger.isLoggable(Level.FINE)) {
                                    this.logger.fine("reading and setting the processed file in the base message.");
                                }
                                finalMsg = FileTransferUtils.createMessageOnBaseMsg(backupFile, fileName, this.configuration.getBaseMsg(), this.configuration.getTransferMode());
                            } else {
                                if (this.logger.isLoggable(Level.FINE)) {
                                    this.logger.fine("reading and setting the processed file in the default message.");
                                }
                                finalMsg = FileTransferUtils.createMessageOnDefaultMsg(backupFile, fileName, this.configuration.getTransferMode());
                            }
                            exchange = this.consumeContext.createConsumeExchange(this.consumeContext.getConsumes(), Message.MEPConstants.IN_ONLY_PATTERN);
                            exchange.setInMessageContent(finalMsg);
                            String flowInstanceId = ExecutionContext.getProperties().getProperty("flowInstanceId");
                            String flowStepId = ExecutionContext.getProperties().getProperty("flowStepId");
                            Consumes consumes = this.consumeContext.getConsumes();
                            this.logger.log(Level.MONIT, "", (Object)new FileTransferConsumeFlowStepBeginLogData(flowInstanceId, flowStepId, StringHelper.nonNullValue((Object)consumes.getInterfaceName()), StringHelper.nonNullValue((Object)consumes.getServiceName()), consumes.getEndpointName(), StringHelper.nonNullValue((Object)consumes.getOperation()), this.originalFile.getAbsolutePath()));
                            if (this.configuration.getTransferMode().equals("attachment")) {
                                this.logger.finest("add attachment");
                                FileTransferUtils.addFileAsAttachment(backupFile, fileName, exchange.getInMessage());
                            }
                            this.consumeContext.send(exchange);
                            if (this.configuration.getBackupDirectory() == null) {
                                ((FileTransferComponent)this.consumeContext.getComponent()).addTransferedFile(exchange, backupFile);
                            }
                        } else {
                            this.logger.fine("[" + this.originalFile.getName() + "] : file no longer exists");
                        }
                        break block19;
                    }
                    catch (MessagingException me) {
                        this.logger.log(Level.INFO, "Can't process file " + fileName, me);
                        LoggingUtil.addMonitFailureTrace((Logger)this.logger, (FlowAttributes)PetalsExecutionContext.getFlowAttributes(), (String)me.getMessage(), (MessageExchange.Role)MessageExchange.Role.CONSUMER);
                        break block19;
                    }
                    catch (Exception e) {
                        this.logger.log(Level.INFO, "Can't process file " + fileName, e);
                        break block19;
                    }
                    finally {
                        if (!lockFile.delete()) {
                            this.logger.fine("Unable to delete lock file: [" + lockFile.getAbsolutePath() + "]");
                        }
                    }
                }
                this.logger.finest("The lock file already exists. [" + fileName + "] is processed by another petals-bc-filetransfer instance");
            }
            catch (IOException e) {
                this.logger.info("Unable to create lock file: " + e.getMessage());
            }
        }
    }

    private File moveFile(File file, File destDir) throws IOException {
        long fileSize;
        do {
            fileSize = file.length();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (file.length() > fileSize);
        this.logger.fine("Move file from " + file.getAbsolutePath() + " to " + destDir.getAbsolutePath());
        String target = "backup-" + FileTransferUtils.addDateToFileName(file.getName());
        File newFile = new File(destDir, target);
        boolean success = file.renameTo(newFile);
        if (!success) {
            FileUtils.copyFile((File)file, (File)newFile);
            file.delete();
        }
        return newFile;
    }
}

