/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DirService
extends AbstractFileService {
    public DirService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("dir", Message.MEPConstants.IN_OUT_PATTERN));
        }
        String readPath = null;
        try {
            File readDirectory = FileTransferUtils.getFolderPath(this.extensions);
            readPath = readDirectory.getAbsolutePath();
            Node filePatternNode = XMLHelper.findChild((Node)inMessageDoc.getFirstChild(), null, (String)"filename", (boolean)false);
            String filePattern = null;
            if (filePatternNode != null) {
                filePattern = filePatternNode.getTextContent();
            }
            this.addMonitBeginStepExtTrace(filePattern, readDirectory.getName());
            String[] fileNames = this.dir(readDirectory);
            String outResponse = this.generateFileNameList(fileNames, exchange.getOperation());
            exchange.setOutMessageContent(SourceUtil.createSource((String)outResponse));
            this.addMonitEndStepExtTrace();
        }
        catch (IOException e) {
            FileTransferUtils.setIOFaultOnExchange(exchange, "Can not list files for directory : [" + readPath + "]. Cause : " + e.getMessage());
        }
        catch (PEtALSCDKException e) {
            FileTransferUtils.setIOFaultOnExchange(exchange, "Can not list files for directory : [" + readPath + "]. Cause : " + e.getMessage());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("DIR operation ended");
        }
    }

    private String[] dir(File readDirectory) {
        return readDirectory.list();
    }

    public String generateFileNameList(String[] names, QName operation) {
        StringBuilder result = new StringBuilder();
        result.append("<tns:" + operation.getLocalPart() + "Response xmlns:tns='");
        result.append(operation.getNamespaceURI());
        result.append("'>");
        for (String string : names) {
            result.append("<tns:filename>");
            result.append(string);
            result.append("</tns:filename>");
        }
        result.append("</tns:" + operation.getLocalPart() + "Response>");
        return result.toString();
    }
}

