/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.FileNamePatternUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetFileAsAttachmentService
extends AbstractFileService {
    private String fileName = null;

    public GetFileAsAttachmentService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        this.logger.info("JBI exchange received - Process GET AS ATTACHMENT operation");
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("getAsAttachment", Message.MEPConstants.IN_OUT_PATTERN));
        }
        Node filePatternNode = XMLHelper.findChild((Node)inMessageDoc.getFirstChild(), null, (String)"filename", (boolean)true);
        String filePattern = null;
        if (filePatternNode != null) {
            filePattern = filePatternNode.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(filePattern)) {
            FileTransferUtils.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            try {
                File readDirectory = FileTransferUtils.getFolderPath(this.extensions);
                this.logger.log(Level.INFO, "read files from : " + readDirectory.getAbsolutePath());
                this.logger.log(Level.INFO, "file pattern : " + filePattern);
                this.logger.log(Level.INFO, "read files from : " + readDirectory.getAbsolutePath());
                this.addMonitBeginStepExtTrace(filePattern, readDirectory.getName());
                DataHandler file = this.getAsAttachment(filePattern, readDirectory);
                exchange.setOutMessageAttachment(this.fileName, file);
                Document outDoc = FileTransferUtils.generateMTOMResponse(this.fileName, exchange.getOperation());
                exchange.setOutMessageContent(outDoc);
                this.addMonitEndStepExtTrace();
            }
            catch (Exception e) {
                FileTransferUtils.setIOFaultOnExchange(exchange, "Can not get file [" + filePattern + "]. Cause : " + e.getMessage());
            }
        }
        this.logger.info("GET AS ATTACHMENT operation ended");
    }

    private DataHandler getAsAttachment(String filePattern, File readDirectory) throws IOException {
        FileNamePatternUtil.RegexFileNameFilter filter = FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(filePattern);
        File[] files = readDirectory.listFiles((FilenameFilter)filter);
        if (files.length > 0) {
            if (!FileTransferUtils.checkAccess(files[0])) {
                throw new IOException("File " + files[0].getName() + " is locked.Permission denied");
            }
        } else {
            throw new IOException("file : '" + filePattern + "' not found");
        }
        this.fileName = files[0].getName();
        File processedFile = FileTransferUtils.moveFile(files[0], this.extensions);
        FileDataSource source = new FileDataSource(processedFile);
        DataHandler file = new DataHandler((DataSource)source);
        return file;
    }
}

