/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp.authentication;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.File;
import java.io.IOException;
import org.ow2.petals.bc.sftp.ConfigurationException;
import org.ow2.petals.bc.sftp.authentication.SshAuthentication;

public final class SshPublicKeyAuthentication
extends SshAuthentication {
    private final String pathToPrivateKeyFile;
    private final String passphrase;

    public SshPublicKeyAuthentication(String user, String pathToPrivateKey, String passphrase) throws ConfigurationException {
        super(user);
        this.pathToPrivateKeyFile = pathToPrivateKey;
        this.passphrase = passphrase;
        this.validate();
    }

    @Override
    public final SshAuthenticationClient getAuthenticationClient() throws IOException {
        PublicKeyAuthenticationClient publicKeyAuth = new PublicKeyAuthenticationClient();
        publicKeyAuth.setUsername(this.getUser());
        SshPrivateKeyFile sshPrivateKey = null;
        File sshPrivateKeyFile = new File(this.pathToPrivateKeyFile);
        try {
            sshPrivateKey = SshPrivateKeyFile.parse((File)sshPrivateKeyFile);
        }
        catch (InvalidSshKeyException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Invalid SSH key : ");
            throw new IOException(errorSB.toString(), ex);
        }
        catch (IOException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Private key location: [" + sshPrivateKeyFile.getAbsolutePath() + "]. IO Exception : ");
            throw new IOException(errorSB.toString(), ex);
        }
        if (!StringHelper.isNullOrEmpty((String)this.passphrase)) {
            SshPrivateKey key = null;
            try {
                key = sshPrivateKey.toPrivateKey(this.passphrase);
            }
            catch (InvalidSshKeyException ex) {
                StringBuilder errorSB = new StringBuilder();
                errorSB.append("Invalid SSH key (passphrase does not match) : ");
                throw new IOException(errorSB.toString(), ex);
            }
            if (key != null) {
                publicKeyAuth.setKey(key);
            } else {
                StringBuilder errorSB = new StringBuilder();
                errorSB.append("No valid private key found");
                throw new IOException(errorSB.toString());
            }
        }
        return publicKeyAuth;
    }

    @Override
    public final String getKey() {
        return this.getUser() + this.pathToPrivateKeyFile + this.passphrase;
    }

    @Override
    public final String toString() {
        return super.toString() + "pathToPrivateKey=" + this.pathToPrivateKeyFile + " ; passphrase=" + this.passphrase + ")";
    }

    private final void validate() throws ConfigurationException {
        if (StringHelper.isNullOrEmpty((String)this.pathToPrivateKeyFile)) {
            throw new ConfigurationException("Missing configuration element : privatekey");
        }
        if (StringHelper.isNullOrEmpty((String)this.passphrase) && this.pathToPrivateKeyFile == null) {
            throw new ConfigurationException("A passphrase with no matching private key was found");
        }
    }
}

