/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sftp.connection;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import org.ow2.petals.bc.sftp.ConfigurationException;
import org.ow2.petals.bc.sftp.authentication.SshAuthentication;
import org.ow2.petals.bc.sftp.authentication.SshPasswordAuthentication;
import org.ow2.petals.bc.sftp.authentication.SshPublicKeyAuthentication;
import org.ow2.petals.bc.sftp.connection.SFTPConnectionInfo;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.Retrypolicy;
import org.w3c.dom.Node;

public class SFTPConnectionInfoBuilder {
    public static SFTPConnectionInfo buildSFTPConnectionInfo(Node node) throws ConfigurationException {
        Node serverNode = null;
        Node portNode = null;
        Node userNode = null;
        Node passwordNode = null;
        Node privateKeyNode = null;
        Node passphraseNode = null;
        Node directoryNode = null;
        Node overwrite = null;
        SshAuthentication sshAuthentication = null;
        SFTPConnectionInfo result = null;
        serverNode = XMLHelper.findChild((Node)node, null, (String)"server", (boolean)false);
        portNode = XMLHelper.findChild((Node)node, null, (String)"port", (boolean)false);
        userNode = XMLHelper.findChild((Node)node, null, (String)"user", (boolean)false);
        passwordNode = XMLHelper.findChild((Node)node, null, (String)"password", (boolean)false);
        privateKeyNode = XMLHelper.findChild((Node)node, null, (String)"privatekey", (boolean)false);
        passphraseNode = XMLHelper.findChild((Node)node, null, (String)"passphrase", (boolean)false);
        directoryNode = XMLHelper.findChild((Node)node, null, (String)"folder", (boolean)false);
        overwrite = XMLHelper.findChild((Node)node, null, (String)"overwrite", (boolean)false);
        if (userNode == null) {
            throw new ConfigurationException("Missing configuration element : user");
        }
        if (passwordNode != null && privateKeyNode != null || passwordNode != null && passphraseNode != null) {
            throw new ConfigurationException("Can't use both password authentication and private key authentication");
        }
        if (passphraseNode != null && privateKeyNode == null) {
            throw new ConfigurationException("A passphrase with no matching private key was found");
        }
        if (passwordNode != null) {
            sshAuthentication = new SshPasswordAuthentication(userNode.getTextContent(), passwordNode.getTextContent());
        } else if (privateKeyNode != null) {
            sshAuthentication = new SshPublicKeyAuthentication(userNode.getTextContent(), privateKeyNode.getTextContent(), passphraseNode != null ? passphraseNode.getTextContent() : null);
        } else {
            throw new ConfigurationException("No authentications information found");
        }
        result = new SFTPConnectionInfo(serverNode != null ? serverNode.getTextContent() : null, portNode != null ? portNode.getTextContent() : null, sshAuthentication, directoryNode != null ? directoryNode.getTextContent() : null, overwrite != null ? Boolean.parseBoolean(overwrite.getTextContent()) : false);
        return result;
    }

    public static SFTPConnectionInfo buildSFTPConnectionInfo(ConfigurationExtensions extensions, Retrypolicy retryPolicy) throws ConfigurationException {
        SshAuthentication sshAuthentication = null;
        String server = extensions.get((Object)"server");
        String port = extensions.get((Object)"port");
        String user = extensions.get((Object)"user");
        String password = extensions.get((Object)"password");
        String privateKey = extensions.get((Object)"privatekey");
        String passphrase = extensions.get((Object)"passphrase");
        String directory = extensions.get((Object)"folder");
        boolean overwrite = Boolean.parseBoolean(extensions.get((Object)"overwrite"));
        int maxConnection = -1;
        long maxIdleTime = 10000L;
        try {
            maxIdleTime = Long.parseLong(extensions.get((Object)"max-idle-time"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            maxConnection = Integer.parseInt(extensions.get((Object)"max-connection"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (password != null && privateKey != null || password != null && passphrase != null) {
            throw new ConfigurationException("Can't use both password authentication and private key authentication");
        }
        if (passphrase != null && privateKey == null) {
            throw new ConfigurationException("A passphrase with no matching private key was found");
        }
        if (password != null) {
            sshAuthentication = new SshPasswordAuthentication(user, password);
        } else if (privateKey != null) {
            sshAuthentication = new SshPublicKeyAuthentication(user, privateKey, passphrase);
        } else {
            throw new ConfigurationException("No authentication informations found");
        }
        SFTPConnectionInfo sftpConnectionInfo = new SFTPConnectionInfo(server, port, sshAuthentication, directory, overwrite);
        sftpConnectionInfo.setMaxConnection(maxConnection);
        sftpConnectionInfo.setMaxIdleTime(maxIdleTime);
        return sftpConnectionInfo;
    }
}

