/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axis2.namespace.Constants;

public final class SOAPFaultHelper {
    private static final String FAULT_STRING = "A fault occurs during the petals treatment";

    public static SOAPFault createSOAPFault(SOAPFactory soapFactory) {
        SOAPFault soapFault = soapFactory.createSOAPFault();
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
        soapFaultCode.setText(soapFactory.getSOAPVersion().getReceiverFaultCode());
        soapFault.setCode(soapFaultCode);
        SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
        soapFaultReason.setText(FAULT_STRING);
        soapFault.setReason(soapFaultReason);
        return soapFault;
    }

    public static SOAPFault createSOAPFault(SOAPFactory soapFactory, OMElement bodyContent) {
        SOAPFault soapFault = soapFactory.createSOAPFault();
        boolean codeFound = false;
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
        boolean reasonFound = false;
        SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
        boolean roleFound = false;
        SOAPFaultRole soapFaultRole = soapFactory.createSOAPFaultRole();
        boolean detailFound = false;
        Iterator elements = bodyContent.getChildren();
        while (elements.hasNext()) {
            OMElement element = (OMElement)elements.next();
            if (Constants.QNAME_FAULTCODE.equals(element.getQName()) || Constants.QNAME_FAULTCODE_SOAP12.equals(element.getQName())) {
                soapFaultCode.setText(element.getTextAsQName());
                codeFound = true;
                continue;
            }
            if (Constants.QNAME_FAULTSTRING.equals(element.getQName()) || Constants.QNAME_FAULTREASON_SOAP12.equals(element.getQName())) {
                soapFaultReason.setText(element.getText());
                reasonFound = true;
                continue;
            }
            if (Constants.QNAME_FAULTACTOR.equals(element.getQName()) || Constants.QNAME_FAULTSTRING.equals(element.getQName())) {
                soapFaultRole.setText(element.getText());
                roleFound = true;
                continue;
            }
            if (!Constants.QNAME_FAULTDETAILS.equals(element.getQName()) && !Constants.QNAME_FAULTDETAIL_SOAP12.equals(element.getQName())) continue;
            SOAPFaultDetail soapFaultDetail = soapFactory.createSOAPFaultDetail();
            Iterator it = element.getChildElements();
            while (it.hasNext()) {
                soapFaultDetail.addDetailEntry((OMElement)it.next());
            }
            soapFault.setDetail(soapFaultDetail);
            detailFound = true;
        }
        if (!codeFound) {
            soapFaultCode.setText(soapFactory.getSOAPVersion().getReceiverFaultCode());
        }
        if (!reasonFound) {
            soapFaultReason.setText(FAULT_STRING);
        }
        soapFault.setCode(soapFaultCode);
        soapFault.setReason(soapFaultReason);
        if (roleFound) {
            soapFault.setRole(soapFaultRole);
        }
        if (!(codeFound || reasonFound || detailFound)) {
            SOAPFaultDetail soapFaultDetail = soapFactory.createSOAPFaultDetail();
            soapFaultDetail.addChild((OMNode)bodyContent);
            soapFault.setDetail(soapFaultDetail);
        }
        return soapFault;
    }

    private SOAPFaultHelper() {
        throw new UnsupportedOperationException();
    }
}

