/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.util.logging.Level;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.ow2.petals.binding.soap.SoapComponent;
import org.ow2.petals.binding.soap.listener.incoming.SoapExternalListenerManager;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;

public class SoapExternalListener
extends AbstractExternalListener {
    private SoapExternalListenerManager externalListenerManager;
    private String serviceName = null;

    public void init() {
        this.externalListenerManager = ((SoapComponent)this.getComponent()).getExternalListenerManager();
        this.serviceName = SUPropertiesHelper.getServiceName(this.getExtensions());
        if (this.serviceName == null) {
            this.serviceName = SUPropertiesHelper.getAddress(this.getExtensions());
        }
    }

    public void start() throws PEtALSCDKException {
        this.getLogger().log(Level.FINE, "Starting listening on " + this.serviceName);
        this.externalListenerManager.getAddresses().add(this.serviceName);
        ConfigurationContext axisConfiguration = ((SoapComponent)this.getComponent()).getSoapContext().getAxis2ConfigurationContext();
        AxisConfiguration axisConf = axisConfiguration.getAxisConfiguration();
        try {
            AxisService axisService = axisConf.getService(this.serviceName);
            Parameter soapExternalListenerParam = new Parameter("org.ow2.petals.binding.soap.soapExternalListener", (Object)this);
            axisService.addParameter(soapExternalListenerParam);
        }
        catch (AxisFault af) {
            throw new PEtALSCDKException((Throwable)af);
        }
    }

    public void stop() {
        this.getLogger().log(Level.FINE, "Stopping listening on " + this.serviceName);
        this.externalListenerManager.getAddresses().remove(this.serviceName);
    }
}

