/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.util.Util;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class WsdlHelper {
    private WsdlHelper() {
    }

    public static final Document replaceServiceAddressInWSDL(Document doc, String address) throws WSDL4ComplexWsdlException, URISyntaxException {
        Document result = null;
        WSDL4ComplexWsdlFactory wsdlFactory = WSDL4ComplexWsdlFactory.newInstance();
        WSDL4ComplexWsdlWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        WSDL4ComplexWsdlReader reader = wsdlFactory.newWSDLReader();
        Description desc = reader.read(doc);
        List services = desc.getServices();
        for (Service service : services) {
            List endpoints = service.getEndpoints();
            for (Endpoint endpoint : endpoints) {
                endpoint.setAddress(address);
            }
        }
        result = wsdlWriter.getDocument(desc);
        return result;
    }

    public static final Map<String, String> readAndStoreSoapAction(Document doc, QName serviceName, String endpointName) throws WSDL4ComplexWsdlException, URISyntaxException {
        HashMap<String, String> map = new HashMap<String, String>();
        Description desc = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
        Service srv = (Service)desc.getService(serviceName);
        Endpoint ep = (Endpoint)srv.getEndpoint(endpointName);
        Binding bd = (Binding)ep.getBinding();
        if (bd == null) {
            return map;
        }
        List bOperations = bd.getBindingOperations();
        for (BindingOperation op : bOperations) {
            map.put(op.getQName().getLocalPart(), op.getSoapAction());
        }
        return map;
    }

    public static BindingOperation findOperationUsingElement(org.w3c.dom.Element firstElement, Description desc, String endpointName, QName serviceName) {
        BindingOperation result = null;
        BindingOperation guess = null;
        Binding b = (Binding)((Endpoint)((Service)desc.getService(serviceName)).getEndpoint(endpointName)).getBinding();
        if (firstElement != null) {
            for (BindingOperation op : b.getBindingOperations()) {
                if (op.getStyle().equals((Object)AbsItfBinding.StyleConstant.RPC)) {
                    if (!((Operation)op.getOperation()).getQName().getNamespaceURI().equals(firstElement.getNamespaceURI()) || !((Operation)op.getOperation()).getQName().getLocalPart().equals(firstElement.getLocalName())) continue;
                    result = op;
                    break;
                }
                QName elmtName = new QName(firstElement.getNamespaceURI(), Util.getLocalPartWithoutPrefix((String)firstElement.getNodeName()));
                Element e = ((Input)((Operation)op.getOperation()).getInput()).getElement();
                if (e == null || e.getQName() == null || !e.getQName().getLocalPart().equals(elmtName.getLocalPart())) continue;
                guess = op;
                if (!e.getQName().getNamespaceURI().equals(elmtName.getNamespaceURI())) continue;
                result = op;
                break;
            }
        }
        if (result == null) {
            result = guess;
        }
        return result;
    }

    public static ArrayList<BindingOperation> findOperationUsingSoapAction(String soapAction, Description desc) {
        ArrayList<BindingOperation> bindingOperations = new ArrayList<BindingOperation>();
        for (Binding b : desc.getBindings()) {
            for (BindingOperation op : b.getBindingOperations()) {
                if (op.getSoapAction() == null || !op.getSoapAction().equals(soapAction)) continue;
                bindingOperations.add(op);
            }
        }
        return bindingOperations;
    }

    public static String findSoapAction(org.w3c.dom.Element firstElement, Description desc, String endpointName, QName serviceName) {
        BindingOperation op = WsdlHelper.findOperationUsingElement(firstElement, desc, endpointName, serviceName);
        if (op != null) {
            return op.getSoapAction();
        }
        return "";
    }

    public static final Description getDescription(Consumes consumes, ComponentContext componentContext, Logger logger) throws AxisFault {
        Description desc = null;
        try {
            Document doc = WsdlHelper.getServiceDefinition(consumes, componentContext, logger);
            if (doc != null) {
                desc = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
            }
        }
        catch (WSDL4ComplexWsdlException e) {
            throw new AxisFault("Server", (Throwable)e);
        }
        catch (JBIException e) {
            throw new AxisFault("Server", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new AxisFault("Server", (Throwable)e);
        }
        return desc;
    }

    public static final Document getServiceDefinition(Consumes consumes, ComponentContext componentContext, Logger logger, String serviceAddress) throws JBIException, WSDL4ComplexWsdlException, URISyntaxException {
        Document result = WsdlHelper.getServiceDefinition(consumes, componentContext, logger);
        if (result != null) {
            result = WsdlHelper.replaceServiceAddressInWSDL(result, serviceAddress);
        }
        return result;
    }

    public static final Document getServiceDefinition(Consumes consumes, ComponentContext componentContext, Logger logger) throws JBIException, WSDL4ComplexWsdlException, URISyntaxException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Get the service definition");
        }
        Document result = null;
        ServiceEndpoint ep = WsdlHelper.getServiceEndpoint(consumes, componentContext);
        logger.fine("JBI Service endpoint " + ep);
        if (ep != null) {
            result = componentContext.getEndpointDescriptor(ep);
        }
        return result;
    }

    private static final ServiceEndpoint getServiceEndpoint(Consumes consumes, ComponentContext componentContext) {
        ServiceEndpoint jbiEndpoint = null;
        String endpointName = consumes.getEndpointName();
        QName serviceName = consumes.getServiceName();
        QName itf = consumes.getInterfaceName();
        if (endpointName != null && serviceName != null) {
            jbiEndpoint = componentContext.getEndpoint(serviceName, endpointName);
        } else if (serviceName != null) {
            ServiceEndpoint[] endpoints = componentContext.getEndpointsForService(serviceName);
            if (endpoints != null && endpoints.length > 0) {
                jbiEndpoint = endpoints[0];
            }
        } else {
            ServiceEndpoint[] endpoints = componentContext.getEndpoints(itf);
            if (endpoints != null && endpoints.length > 0) {
                jbiEndpoint = endpoints[0];
            }
        }
        return jbiEndpoint;
    }

    public static final void printWSDL(Logger logger, Consumes consumes, ComponentContext componentContext, OutputStream out, String serviceAddress) throws AxisFault {
        block8: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Print WSDL");
            }
            try {
                Document doc = WsdlHelper.getServiceDefinition(consumes, componentContext, logger, serviceAddress);
                if (doc == null) {
                    WsdlHelper.printWSDLError(out, "WSDL description can not been retrieved from JBI endpoint");
                    break block8;
                }
                Description desc = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
                desc.deleteImportedDocumentsInWsdl(new URI(serviceAddress + "?wsdl="));
                Document descWithoutImport = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(desc);
                try {
                    XMLPrettyPrinter.prettify((Node)descWithoutImport, (OutputStream)out, (String)XMLPrettyPrinter.getEncoding((Document)descWithoutImport));
                }
                catch (Exception e) {
                    throw new AxisFault("Server", (Throwable)e);
                }
            }
            catch (WSDL4ComplexWsdlException e) {
                throw new AxisFault("Server", (Throwable)e);
            }
            catch (JBIException e) {
                throw new AxisFault("Server", (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new AxisFault("Server", (Throwable)e);
            }
        }
    }

    public static final Map<URI, Document> getImportedDocuments(Logger logger, Consumes consumes, ComponentContext componentContext, String requestURL) throws AxisFault {
        Map importsMap = null;
        try {
            Document doc = WsdlHelper.getServiceDefinition(consumes, componentContext, logger);
            if (doc == null) {
                throw new AxisFault("Server", "WSDL description can not been retrieved from JBI endpoint");
            }
            Description desc = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
            importsMap = desc.deleteImportedDocumentsInWsdl(new URI(requestURL));
        }
        catch (WSDL4ComplexWsdlException wsdl4cwe) {
            throw new AxisFault("Server", (Throwable)wsdl4cwe);
        }
        catch (JBIException jbie) {
            throw new AxisFault("Server", (Throwable)jbie);
        }
        catch (URISyntaxException urise) {
            throw new AxisFault("Server", (Throwable)urise);
        }
        return importsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void printWSDLError(OutputStream out, String message) {
        String errorMessage = "<error><description>Unable to get WSDL for this service</description><reason>" + message + "</reason></error>";
        try {
            out.write(errorMessage.getBytes());
            out.flush();
        }
        catch (IOException e) {
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
    }
}

