/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIOperationDispatcher;
import org.apache.axis2.dispatchers.SOAPActionBasedDispatcher;
import org.apache.axis2.dispatchers.SOAPMessageBodyBasedDispatcher;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.binding.soap.axis.HandlerConfig;
import org.ow2.petals.binding.soap.axis.PhaseConfig;
import org.ow2.petals.binding.soap.axis.PhaseOrderConfig;

public class PhaseOrderConfigTest {
    private static final String PHASEORDER_CONFIG_TEST0 = "PhaseOrderConfigTest0.xml";

    @Test
    public void testDumpXml() throws Exception {
        InputStream expected = this.getClass().getClassLoader().getResourceAsStream(PHASEORDER_CONFIG_TEST0);
        HandlerConfig requestURIBasedDispatcherConfig = new HandlerConfig("RequestURIBasedDispatcher", RequestURIBasedDispatcher.class);
        HandlerConfig soapActionBasedDispatcherConfig = new HandlerConfig("SOAPActionBasedDispatcher", SOAPActionBasedDispatcher.class);
        PhaseConfig transportPhaseConfig = new PhaseConfig("Transport");
        transportPhaseConfig.addHandler(requestURIBasedDispatcherConfig);
        transportPhaseConfig.addHandler(soapActionBasedDispatcherConfig);
        PhaseConfig securityPhaseConfig = new PhaseConfig("Security");
        PhaseConfig preDispatchPhaseConfig = new PhaseConfig("PreDispatch");
        HandlerConfig requestURIOperationDispatcherConfig = new HandlerConfig("RequestURIOperationDispatcher", RequestURIOperationDispatcher.class);
        HandlerConfig soapMessageBodyBasedDispatcherConfig = new HandlerConfig("SOAPMessageBodyBasedDispatcher", SOAPMessageBodyBasedDispatcher.class);
        PhaseConfig dispatchPhaseConfig = new PhaseConfig("Dispatch");
        dispatchPhaseConfig.addHandler(requestURIOperationDispatcherConfig);
        dispatchPhaseConfig.addHandler(soapMessageBodyBasedDispatcherConfig);
        PhaseOrderConfig config = new PhaseOrderConfig("InFlow");
        config.addPhase(transportPhaseConfig);
        config.addPhase(securityPhaseConfig);
        config.addPhase(preDispatchPhaseConfig);
        config.addPhase(dispatchPhaseConfig);
        StringWriter sw = new StringWriter();
        config.dump((Writer)sw);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)expected, (InputStream)new ByteArrayInputStream(sw.getBuffer().toString().getBytes())));
    }
}

