/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.TestHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.petals.binding.soap.listener.outgoing.MockWebService;

public class MockWebServiceTest {
    private static final TestHandler testHandler = new TestHandler();
    private static final String FIRST_URL = "http://localhost:8085/UnitTest/MockWebService";
    private static final String POST_METHOD = "POST";
    private static final String GET_METHOD = "GET";
    private MockWebService mws;

    @BeforeClass
    public static void beforeClass() {
        MockWebService.logger.addHandler((Handler)testHandler);
    }

    @AfterClass
    public static void afterClass() {
        MockWebService.logger.removeHandler((Handler)testHandler);
    }

    @Before
    public void before() {
        try {
            this.mws = new MockWebService(new URL(FIRST_URL));
        }
        catch (MalformedURLException mue) {
            throw new UncheckedException((Throwable)mue);
        }
        this.mws.start();
    }

    @After
    public void after() {
        if (this.mws.isStarted()) {
            this.mws.stop();
        }
        testHandler.clearRecords();
    }

    private static final void assertLogRecordsEquals(List<LogRecord> l1, List<LogRecord> l2) {
        Assert.assertEquals((long)l1.size(), (long)l2.size());
        for (int i = 0; i < l1.size(); ++i) {
            Assert.assertEquals((Object)l1.get(i).getLevel(), (Object)l2.get(i).getLevel());
            Assert.assertEquals((Object)l1.get(i).getMessage(), (Object)l2.get(i).getMessage());
            Assert.assertArrayEquals((Object[])l1.get(i).getParameters(), (Object[])l2.get(i).getParameters());
        }
    }

    @Test
    public void testIsStarted() throws Exception {
        Assert.assertTrue((boolean)this.mws.isStarted());
        LogRecord expectedLogRecord = new LogRecord(Level.INFO, String.format("Started mock web service on '%s'.", FIRST_URL));
        MockWebServiceTest.assertLogRecordsEquals(Collections.singletonList(expectedLogRecord), testHandler.getAllRecords());
    }

    @Test
    public void testStartWhenAlreadyStarted() throws Exception {
        this.mws.start();
        Assert.assertTrue((boolean)this.mws.isStarted());
        LogRecord expectedLogRecord = new LogRecord(Level.INFO, String.format("Started mock web service on '%s'.", FIRST_URL));
        MockWebServiceTest.assertLogRecordsEquals(Collections.singletonList(expectedLogRecord), testHandler.getAllRecords());
    }

    @Test
    public void testStop() throws Exception {
        testHandler.clearRecords();
        this.mws.stop();
        Assert.assertFalse((boolean)this.mws.isStarted());
        LogRecord expectedLogRecord = new LogRecord(Level.INFO, String.format("Stopped mock web service on '%s'.", FIRST_URL));
        MockWebServiceTest.assertLogRecordsEquals(Collections.singletonList(expectedLogRecord), testHandler.getAllRecords());
    }

    private final void testLogOnRequestSent(String method, String url, String expectedInfoLogMessage) throws Exception {
        testHandler.clearRecords();
        this.sendRequest(new URL(url), method);
        LogRecord expectedLogRecord = new LogRecord(Level.INFO, expectedInfoLogMessage);
        MockWebServiceTest.assertLogRecordsEquals(Collections.singletonList(expectedLogRecord), testHandler.getAllRecords());
    }

    private final void testNoLogOnRequestSent(String method, String url) throws Exception {
        testHandler.clearRecords();
        this.sendRequest(new URL(url), method);
        MockWebServiceTest.assertLogRecordsEquals(Collections.<LogRecord>emptyList(), testHandler.getAllRecords());
    }

    @Test
    public void testGetMockStarted() throws Exception {
        this.testLogOnRequestSent(GET_METHOD, FIRST_URL, String.format("Received GET request on '%s'.", FIRST_URL));
    }

    @Test
    public void testPostMockStarted() throws Exception {
        this.testLogOnRequestSent(POST_METHOD, FIRST_URL, String.format("Received POST request on '%s'.", FIRST_URL));
    }

    @Test(expected=ConnectException.class)
    public void testGetMockStopped() throws Exception {
        this.mws.stop();
        this.testNoLogOnRequestSent(GET_METHOD, FIRST_URL);
    }

    @Test(expected=ConnectException.class)
    public void testPostMockStopped() throws Exception {
        this.mws.stop();
        this.testNoLogOnRequestSent(POST_METHOD, FIRST_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(URL url, String method) throws IOException {
        BufferedReader in = null;
        try {
            String inputLine;
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method);
            InputStream is = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(is));
            StringBuilder responseBuilder = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                responseBuilder.append(inputLine);
            }
            String string = responseBuilder.toString();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

