/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SUPropertiesHelper {
    protected static final boolean checkPresent(String parameterName, ConfigurationExtensions extensions) {
        String tmp = extensions.get((Object)parameterName);
        return tmp != null && tmp.trim().length() > 0;
    }

    @Deprecated
    public static String getAddress(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("address", extensions);
    }

    protected static final boolean getBoolean(String parameterName, ConfigurationExtensions extensions) {
        boolean result = true;
        String tmp = extensions.get((Object)parameterName);
        if (tmp != null) {
            result = Boolean.parseBoolean(tmp.trim());
        }
        return result;
    }

    protected static final boolean getBoolean(String parameterName, ConfigurationExtensions extensions, boolean defaultValue) {
        boolean result = true;
        String tmp = extensions.get((Object)parameterName);
        result = tmp == null ? defaultValue : Boolean.parseBoolean(tmp.trim());
        return result;
    }

    public static final String getHttpRedirection(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("http-services-redirection", extensions);
    }

    public static String getServiceName(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("service-name", extensions);
    }

    protected static final String getString(String parameterName, ConfigurationExtensions extensions) {
        String result = extensions.get((Object)parameterName);
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    protected static final String getString(String parameterName, String defaultValue, ConfigurationExtensions extensions) {
        String result = SUPropertiesHelper.getString(parameterName, extensions);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static String getWSAFaultTo(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-faultto", extensions);
    }

    public static String getWSAFrom(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-from", extensions);
    }

    public static String getWSAReplyTo(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-replyto", extensions);
    }

    public static String getWSATo(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getString("wsa-to", extensions);
    }

    public static boolean isHttpsTransportEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("enable-https-transport", extensions, false);
    }

    public static boolean isHttpTransportEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("enable-http-transport", extensions);
    }

    public static boolean isJmsTransportEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("enable-jms-transport", extensions, false);
    }

    public static List<String> retrieveHeaderList(ConfigurationExtensions extensions) {
        ArrayList<String> result = null;
        String tmp = extensions.get((Object)"headers-filter");
        if (tmp != null) {
            result = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(tmp, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public static boolean retrieveInjectHeader(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("inject-headers", extensions);
    }

    protected SUPropertiesHelper() {
    }

    public static List<DocumentFragment> retrieveHeaderToInject(ConfigurationExtensions extensions) {
        String toInject = SUPropertiesHelper.getString("headers-to-inject", extensions);
        if (toInject == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader("<R>" + toInject + "</R>")));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
        Element root = doc.getDocumentElement();
        ArrayList<DocumentFragment> result = null;
        while (root.hasChildNodes()) {
            DocumentFragment docfrag = doc.createDocumentFragment();
            docfrag.appendChild(root.removeChild(root.getFirstChild()));
            if (result == null) {
                result = new ArrayList<DocumentFragment>();
            }
            result.add(docfrag);
        }
        return result;
    }

    public static boolean isAxis1CompatibilityEnabled(ConfigurationExtensions extensions) {
        String compatibility = extensions.get((Object)"enable-compatibility-for");
        return compatibility != null && compatibility.equals("AXIS1");
    }

    public static String getKeystoreFile(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-keystore-file");
    }

    public static String getKeystorePassword(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-keystore-password");
    }

    public static String getTruststoreFile(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-truststore-file");
    }

    public static String getTruststorePassword(ConfigurationExtensions extensions) {
        return extensions.get((Object)"https-truststore-password");
    }

    public static boolean isWSAEnabled(ConfigurationExtensions extensions) {
        return SUPropertiesHelper.getBoolean("enable-wsa", extensions, false);
    }

    public static String getBasicAuthUser(ConfigurationExtensions extensions) {
        return extensions.get((Object)"http-basic-auth-username");
    }

    public static String getBasicAuthPwd(ConfigurationExtensions extensions) {
        return extensions.get((Object)"http-basic-auth-password");
    }

    public static final List<String> getModules(ConfigurationExtensions extensions) {
        ArrayList<String> result = new ArrayList<String>();
        String token = extensions.get((Object)"modules");
        if (token != null) {
            StringTokenizer st = new StringTokenizer(token, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
            if (!result.contains("addressing")) {
                result.add("addressing");
            }
        }
        return result;
    }

    public static final String getServiceParameters(ConfigurationExtensions extensions) {
        return extensions.get((Object)"service-parameters");
    }

    public static final String retrieveSOAPEnvelopeNamespaceURI(ConfigurationExtensions extensions) {
        String soapEnvelopeNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
        String soapVersion = extensions.get((Object)"soap-version");
        if ("1.2".equals(soapVersion)) {
            soapEnvelopeNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
        }
        return soapEnvelopeNamespaceURI;
    }

    public static final boolean retrieveCleanupTransport(ConfigurationExtensions extensions) {
        String clean = extensions.get((Object)"cleanup-transport");
        if (clean == null) {
            return true;
        }
        return Boolean.valueOf(clean);
    }

    public static final String retrieveChunkedMode(ConfigurationExtensions extensions) {
        return extensions.get((Object)"chunked-mode");
    }

    public static final String retrieveDefaultSOAPAction(ConfigurationExtensions extensions) {
        String soapAction = extensions.get((Object)"soap-action");
        return soapAction;
    }

    public static final HttpTransportProperties.ProxyProperties retrieveProxySettings(ConfigurationExtensions extensions) {
        HttpTransportProperties.ProxyProperties proxyProperties = null;
        if (extensions.get((Object)"proxy-host") != null) {
            proxyProperties = new HttpTransportProperties.ProxyProperties();
            String domain = extensions.get((Object)"proxy-domain");
            String password = extensions.get((Object)"proxy-password");
            String proxyHost = extensions.get((Object)"proxy-host");
            int proxyPort = -1;
            String tmp = extensions.get((Object)"proxy-port");
            if (tmp != null) {
                try {
                    proxyPort = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String proxyUserName = extensions.get((Object)"proxy-user");
            proxyProperties.setDomain(domain);
            proxyProperties.setPassWord(password);
            proxyProperties.setProxyName(proxyHost);
            proxyProperties.setProxyPort(proxyPort);
            proxyProperties.setUserName(proxyUserName);
        }
        return proxyProperties;
    }

    public static final void setBasicAuthentication(ConfigurationExtensions extensions, Options options) {
        HttpTransportProperties.Authenticator basicAuthentication = null;
        String username = SUPropertiesHelper.getBasicAuthUser(extensions);
        String password = SUPropertiesHelper.getBasicAuthPwd(extensions);
        if (username != null) {
            if (password == null) {
                password = "";
            }
            basicAuthentication = new HttpTransportProperties.Authenticator();
            basicAuthentication.setUsername(username);
            basicAuthentication.setPassword(password);
            basicAuthentication.setPreemptiveAuthentication(true);
            options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)basicAuthentication);
        }
    }
}

