/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class NetworkUtil {
    public static Set<Inet4Address> getAllLocalIPv4InetAddresses() throws SocketException {
        HashSet<Inet4Address> result = new HashSet<Inet4Address>();
        Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
        while (niEnum.hasMoreElements()) {
            NetworkInterface ni = niEnum.nextElement();
            Set<Inet4Address> ipForNi = NetworkUtil.getIPv4InetAdressesFromNetworkInterface(ni);
            result.addAll(ipForNi);
        }
        return result;
    }

    private static final Set<Inet4Address> getIPv4InetAdressesFromNetworkInterface(NetworkInterface ni) {
        HashSet<Inet4Address> result = new HashSet<Inet4Address>();
        Enumeration<InetAddress> e = ni.getInetAddresses();
        while (e.hasMoreElements()) {
            InetAddress ia = e.nextElement();
            if (!(ia instanceof Inet4Address)) continue;
            result.add((Inet4Address)ia);
        }
        return result;
    }
}

