/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.util.XMLUtils;
import org.junit.Test;
import org.ow2.petals.component.framework.util.JVMDocumentBuilders;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SOAHeaderTest {
    private static final Map<String, DocumentFragment> createHeaders() throws Exception {
        String SOAPMessage2 = "<SOAP-ENV:Envelope xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tns=\"http://www.SoapClient.com/xml/SoapResponder.wsdl\" xmlns:xsd1=\"http://www.SoapClient.com/xml/SoapResponder.xsd\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Header><wsa:To>http://example.org/To</wsa:To><wsa:ReplyTo><wsa:Address>http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous</wsa:Address></wsa:ReplyTo><wsa:FaultTo><wsa:Address>http://client/myReceiver</wsa:Address></wsa:FaultTo></SOAP-ENV:Header><SOAP-ENV:Body></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        HashMap<String, DocumentFragment> soapHeaderElementsMap = new HashMap<String, DocumentFragment>();
        ByteArrayInputStream toSOAP = new ByteArrayInputStream(SOAPMessage2.getBytes());
        XMLStreamReader parser = StAXUtils.getXMLInputFactory().createXMLStreamReader(toSOAP);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(parser, null);
        SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
        SOAPHeader header = envelope.getHeader();
        Iterator elements = header.getChildElements();
        Document doc = JVMDocumentBuilders.newDocument();
        while (elements != null && elements.hasNext()) {
            OMElement element = (OMElement)elements.next();
            Element elt = XMLUtils.toDOM((OMElement)element);
            DocumentFragment docfrag = doc.createDocumentFragment();
            docfrag.appendChild(doc.importNode(elt, true));
            docfrag.normalize();
            soapHeaderElementsMap.put(element.getQName().toString(), docfrag);
        }
        return soapHeaderElementsMap;
    }

    @Test
    public void testGetAsMapOfString() throws Exception {
        Map<String, DocumentFragment> map = SOAHeaderTest.createHeaders();
        for (Map.Entry<String, DocumentFragment> entry : map.entrySet()) {
            DocumentFragment df = entry.getValue();
            if (df.getFirstChild() == null || !(df.getFirstChild() instanceof Element)) continue;
            df.getFirstChild().getTextContent();
        }
    }
}

