/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.binding.soap.util.AxiomSOAPEnvelopeFlattener;
import org.ow2.petals.binding.soap.util.SOAPTestUtil;

public class SOAPFlattenerTest {
    @Test
    public void testNoMultiref() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-002-nohref.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertEquals((Object)soapEnvelope, (Object)flattened);
    }

    @Test
    public void testTwoMultirefInBody() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-003-twohref.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertNotNull((Object)flattened);
        Assert.assertNull((Object)flattened.getHeader());
        Assert.assertNotNull((Object)flattened.getBody());
        SOAPBody body = flattened.getBody();
        Assert.assertNull((Object)body.getFirstChildWithName(QName.valueOf("multiRef")));
        Assert.assertNotNull((Object)body.getFirstElement());
        Assert.assertEquals((Object)"createEventsResponse", (Object)body.getFirstElementLocalName());
        OMElement createEventResponseElement = body.getFirstElement();
        Iterator iter = createEventResponseElement.getChildrenWithLocalName("createEventsReturn");
        int i = 0;
        while (iter.hasNext()) {
            iter.next();
            ++i;
        }
        Assert.assertEquals((long)2L, (long)i);
        HashSet<String> set = new HashSet<String>();
        set.add("message");
        set.add("resultCode");
        set.add("results");
        iter = createEventResponseElement.getChildrenWithLocalName("createEventsReturn");
        while (iter.hasNext()) {
            OMElement e = (OMElement)iter.next();
            Iterator ii = e.getChildElements();
            int j = 0;
            while (ii.hasNext()) {
                ++j;
                OMElement inner = (OMElement)ii.next();
                Assert.assertTrue((boolean)set.contains(inner.getLocalName()));
            }
            Assert.assertEquals((long)3L, (long)j);
        }
    }

    @Test
    public void testFlattenSOAPEnvelopeWithIdElement() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-004-withidelements.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertNotNull((Object)flattened);
        Assert.assertNull((Object)flattened.getHeader());
        Assert.assertNotNull((Object)flattened.getBody());
        SOAPBody body = flattened.getBody();
        Assert.assertNull((Object)body.getFirstChildWithName(QName.valueOf("multiRef")));
        Assert.assertNotNull((Object)body.getFirstElement());
        Assert.assertEquals((Object)"createEventsResponse", (Object)body.getFirstElementLocalName());
        OMElement first = body.getFirstElement();
        Assert.assertNotNull((Object)first.getFirstChildWithName(QName.valueOf("id")));
        Assert.assertNotNull((Object)first.getFirstChildWithName(QName.valueOf("createEventsReturn")));
    }

    @Test
    public void testFlattenSOAPEnvelopeWithIdElementInMultiref() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-005-withidelementinmultiref.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertNotNull((Object)flattened);
        Assert.assertNull((Object)flattened.getHeader());
        Assert.assertNotNull((Object)flattened.getBody());
        SOAPBody body = flattened.getBody();
        Assert.assertNull((Object)body.getFirstChildWithName(QName.valueOf("multiRef")));
        Assert.assertNotNull((Object)body.getFirstElement());
        Assert.assertEquals((Object)"createEventsResponse", (Object)body.getFirstElementLocalName());
        OMElement first = body.getFirstElement();
        OMElement firstFirst = first.getFirstElement();
        Assert.assertNotNull((Object)firstFirst);
        Assert.assertNotNull((Object)firstFirst.getFirstChildWithName(QName.valueOf("id")));
    }

    @Test
    public void testFlattenSOAPEnvelopeImbriquedIds() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-006-imbriquedhrefs.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertNotNull((Object)flattened);
        Assert.assertNull((Object)flattened.getHeader());
        Assert.assertNotNull((Object)flattened.getBody());
        SOAPBody body = flattened.getBody();
        Assert.assertNull((Object)body.getFirstChildWithName(QName.valueOf("multiRef")));
        Assert.assertNotNull((Object)body.getFirstElement());
        Assert.assertEquals((Object)"createEventsResponse", (Object)body.getFirstElementLocalName());
        OMElement first = body.getFirstElement();
        OMElement createEventsReturn = first.getFirstElement();
        Assert.assertNotNull((Object)createEventsReturn);
        Assert.assertEquals((Object)"createEventsReturn", (Object)createEventsReturn.getLocalName());
        OMElement another = createEventsReturn.getFirstChildWithName(QName.valueOf("another"));
        Assert.assertNotNull((Object)another);
        Iterator iter = another.getChildElements();
        int i = 0;
        while (iter.hasNext()) {
            iter.next();
            ++i;
        }
        Assert.assertEquals((long)3L, (long)i);
        HashSet<String> set = new HashSet<String>();
        set.add("message2");
        set.add("resultCode2");
        set.add("results2");
        iter = another.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            Assert.assertTrue((boolean)set.contains(element.getLocalName()));
        }
    }

    @Test
    public void testtestFlattenSOAPEnvelopeHrefInHeaderAndBody() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-007-hrefheaderandbody.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertNotNull((Object)flattened);
        Assert.assertNotNull((Object)flattened.getHeader());
        Assert.assertEquals((Object)"myheader", (Object)flattened.getHeader().getFirstElement().getLocalName());
        OMElement myheaderElement = flattened.getHeader().getFirstElement();
        Assert.assertNotNull((Object)myheaderElement.getFirstElement());
        Iterator iter = myheaderElement.getChildElements();
        int i = 0;
        while (iter.hasNext()) {
            iter.next();
            ++i;
        }
        Assert.assertEquals((long)3L, (long)i);
        Assert.assertNotNull((Object)flattened.getBody());
        SOAPBody body = flattened.getBody();
        Assert.assertNull((Object)body.getFirstChildWithName(QName.valueOf("multiRef")));
        Assert.assertNotNull((Object)body.getFirstElement());
        Assert.assertEquals((Object)"createEventsResponse", (Object)body.getFirstElementLocalName());
        OMElement first = body.getFirstElement();
        OMElement firstFirst = first.getFirstElement();
        Assert.assertNotNull((Object)firstFirst);
        iter = firstFirst.getChildElements();
        i = 0;
        while (iter.hasNext()) {
            iter.next();
            ++i;
        }
        Assert.assertEquals((long)3L, (long)i);
    }

    @Test
    public void testWithIDAttribute() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-008-withidattribute.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertNotNull((Object)flattened);
        Assert.assertNull((Object)flattened.getHeader());
        Assert.assertEquals((Object)"createEventsResponse", (Object)flattened.getBody().getFirstElementLocalName());
        OMElement createEventsResponse = flattened.getBody().getFirstChildWithName(QName.valueOf("createEventsResponse"));
        Assert.assertNotNull((Object)createEventsResponse);
        OMElement createEventsReturn = createEventsResponse.getFirstChildWithName(QName.valueOf("createEventsReturn"));
        Assert.assertNotNull((Object)createEventsReturn);
        OMAttribute id = createEventsReturn.getAttribute(QName.valueOf("id"));
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)"0", (Object)id.getAttributeValue());
    }

    @Test
    public void testWithIDAttributeAndMultiref() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-009-withidattributeandhref.xml", 11);
        AxiomSOAPEnvelopeFlattener soapEnvelopeFlattener = new AxiomSOAPEnvelopeFlattener();
        SOAPEnvelope flattened = AxiomSOAPEnvelopeFlattener.flatten((SOAPEnvelope)soapEnvelope);
        Assert.assertNotNull((Object)flattened);
        Assert.assertNull((Object)flattened.getHeader());
        Assert.assertEquals((Object)"createEventsResponse", (Object)flattened.getBody().getFirstElementLocalName());
        OMElement createEventsResponse = flattened.getBody().getFirstChildWithName(QName.valueOf("createEventsResponse"));
        Assert.assertNotNull((Object)createEventsResponse);
        OMElement createEventsReturn = createEventsResponse.getFirstChildWithName(QName.valueOf("createEventsReturn"));
        Assert.assertNotNull((Object)createEventsReturn);
        OMAttribute id = createEventsReturn.getAttribute(QName.valueOf("id"));
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)"0", (Object)id.getAttributeValue());
        OMElement myelement = createEventsResponse.getFirstChildWithName(QName.valueOf("myelement"));
        Assert.assertNotNull((Object)myelement);
        HashSet<String> set = new HashSet<String>();
        set.add("message");
        int i = 0;
        Iterator iter = myelement.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            Assert.assertTrue((boolean)set.contains(element.getLocalName()));
            ++i;
        }
        Assert.assertEquals((long)1L, (long)i);
    }
}

