/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.transaction.UserTransaction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSEndpoint;
import org.apache.axis2.transport.jms.JMSListener;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.transport.jms.ctype.ContentTypeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessageReceiver {
    private static final Log log = LogFactory.getLog(JMSMessageReceiver.class);
    private JMSListener jmsListener = null;
    private JMSConnectionFactory jmsConnectionFactory = null;
    private MetricsCollector metrics = null;
    final JMSEndpoint endpoint;

    JMSMessageReceiver(JMSListener jmsListener, JMSConnectionFactory jmsConFac, JMSEndpoint endpoint) {
        this.jmsListener = jmsListener;
        this.jmsConnectionFactory = jmsConFac;
        this.endpoint = endpoint;
        this.metrics = jmsListener.getMetricsCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onMessage(Message message, UserTransaction ut) {
        boolean successful;
        block20: {
            block19: {
                try {
                    if (!log.isDebugEnabled()) break block19;
                    StringBuffer sb = new StringBuffer();
                    sb.append("Received new JMS message for service :").append(this.endpoint.getServiceName());
                    sb.append("\nDestination    : ").append(message.getJMSDestination());
                    sb.append("\nMessage ID     : ").append(message.getJMSMessageID());
                    sb.append("\nCorrelation ID : ").append(message.getJMSCorrelationID());
                    sb.append("\nReplyTo        : ").append(message.getJMSReplyTo());
                    sb.append("\nRedelivery ?   : ").append(message.getJMSRedelivered());
                    sb.append("\nPriority       : ").append(message.getJMSPriority());
                    sb.append("\nExpiration     : ").append(message.getJMSExpiration());
                    sb.append("\nTimestamp      : ").append(message.getJMSTimestamp());
                    sb.append("\nMessage Type   : ").append(message.getJMSType());
                    sb.append("\nPersistent ?   : ").append(2 == message.getJMSDeliveryMode());
                    log.debug((Object)sb.toString());
                    if (log.isTraceEnabled() && message instanceof TextMessage) {
                        log.trace((Object)("\nMessage : " + ((TextMessage)message).getText()));
                    }
                }
                catch (JMSException e) {
                    if (!log.isDebugEnabled()) break block19;
                    log.debug((Object)"Error reading JMS message headers for debug logging", (Throwable)e);
                }
            }
            try {
                this.metrics.incrementBytesReceived(JMSUtils.getMessageSize(message));
            }
            catch (JMSException e) {
                log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
            }
            try {
                long expiryTime = message.getJMSExpiration();
                if (expiryTime > 0L && System.currentTimeMillis() > expiryTime) {
                    if (!log.isDebugEnabled()) return true;
                    log.debug((Object)("Discard expired message with ID : " + message.getJMSMessageID()));
                    return true;
                }
            }
            catch (JMSException ignore) {
                // empty catch block
            }
            successful = false;
            try {
                try {
                    successful = this.processThoughEngine(message, ut);
                }
                catch (JMSException e) {
                    log.error((Object)"JMS Exception encountered while processing", (Throwable)e);
                    Object var6_10 = null;
                    if (successful) {
                        this.metrics.incrementMessagesReceived();
                        return successful;
                    }
                    this.metrics.incrementFaultsReceiving();
                    return successful;
                }
                catch (AxisFault e) {
                    log.error((Object)"Axis fault processing message", (Throwable)e);
                    Object var6_11 = null;
                    if (successful) {
                        this.metrics.incrementMessagesReceived();
                        return successful;
                    }
                    this.metrics.incrementFaultsReceiving();
                    return successful;
                }
                catch (Exception e) {
                    log.error((Object)"Unknown error processing message", (Throwable)e);
                    Object var6_12 = null;
                    if (successful) {
                        this.metrics.incrementMessagesReceived();
                        return successful;
                    }
                    this.metrics.incrementFaultsReceiving();
                    return successful;
                }
                Object var6_9 = null;
                if (!successful) break block20;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                if (successful) {
                    this.metrics.incrementMessagesReceived();
                    throw throwable;
                }
                this.metrics.incrementFaultsReceiving();
                throw throwable;
            }
            this.metrics.incrementMessagesReceived();
            return successful;
        }
        this.metrics.incrementFaultsReceiving();
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processThoughEngine(Message message, UserTransaction ut) throws JMSException, AxisFault {
        String jndiReplyDestinationName;
        MessageContext msgContext = this.endpoint.createMessageContext();
        try {
            msgContext.setMessageID(message.getJMSMessageID());
            msgContext.setProperty("JMS_COORELATION_ID", (Object)message.getJMSMessageID());
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        String soapAction = JMSUtils.getProperty(message, "SOAPAction");
        ContentTypeInfo contentTypeInfo = this.endpoint.getContentTypeRuleSet().getContentTypeInfo(message);
        if (contentTypeInfo == null) {
            throw new AxisFault("Unable to determine content type for message " + msgContext.getMessageID());
        }
        Destination replyTo = message.getJMSReplyTo();
        if (replyTo == null && (jndiReplyDestinationName = this.endpoint.getJndiReplyDestinationName()) != null) {
            replyTo = this.jmsConnectionFactory.getDestination(jndiReplyDestinationName, this.endpoint.getReplyDestinationType());
        }
        if (replyTo != null) {
            msgContext.setProperty("OutTransportInfo", (Object)new JMSOutTransportInfo(this.jmsConnectionFactory, replyTo, contentTypeInfo.getPropertyName()));
        }
        JMSUtils.setSOAPEnvelope(message, msgContext, contentTypeInfo.getContentType());
        if (ut != null) {
            msgContext.setProperty("UserTransaction", (Object)ut);
        }
        try {
            this.jmsListener.handleIncomingMessage(msgContext, JMSUtils.getTransportHeaders(message), soapAction, contentTypeInfo.getContentType());
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Object o = msgContext.getProperty("SET_ROLLBACK_ONLY");
            return o == null || (!(o instanceof Boolean) || (Boolean)o == false) && (!(o instanceof String) || Boolean.valueOf((String)o) == false);
        }
        Object o = msgContext.getProperty("SET_ROLLBACK_ONLY");
        return o == null || (!(o instanceof Boolean) || (Boolean)o == false) && (!(o instanceof String) || Boolean.valueOf((String)o) == false);
    }
}

