/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap;

import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.phaseresolver.PhaseHolder;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSListener;
import org.ow2.petals.binding.soap.SoapComponentContext;
import org.ow2.petals.binding.soap.SoapSUManager;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.binding.soap.listener.incoming.SoapExternalListenerManager;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

public class SoapComponent
extends AbstractBindingComponent {
    protected SoapExternalListenerManager externalListenerManager;
    protected SoapComponentContext soapContext;

    private void createJMSTransporter(ConfigurationContext axisConfigurationContext) throws AxisFault {
        TransportInDescription jmsTransportDescription = new TransportInDescription("jms");
        jmsTransportDescription.setReceiver((TransportListener)new JMSListener());
        axisConfigurationContext.getAxisConfiguration().addTransportIn(jmsTransportDescription);
        String jndiInitialFactory = this.getComponentExtensions().get((Object)"java-naming-factory-initial");
        String jndiProviderUrl = this.getComponentExtensions().get((Object)"java-naming-provider-url");
        String confacJndiName = this.getComponentExtensions().get((Object)"jms-connection-factory-jndiname");
        if (jndiInitialFactory != null && jndiProviderUrl != null && confacJndiName != null && jndiInitialFactory.length() > 0 && jndiProviderUrl.length() > 0 && confacJndiName.length() > 0) {
            this.soapContext.setJmsJndiInitialFactory(jndiInitialFactory);
            this.soapContext.setJmsJndiProviderUrl(jndiProviderUrl);
            this.soapContext.setJmsConnectionFactoryName(confacJndiName);
            this.getLogger().info("Create the default JMS connection factory ('default'):");
            this.getLogger().info("\tjava-naming-factory-initial: " + jndiInitialFactory);
            this.getLogger().info("\tjava-naming-provider-url: " + jndiProviderUrl);
            this.getLogger().info("\tjms-connection-factory-jndiname: " + confacJndiName);
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            OMElement initialContextFactory = omFactory.createOMElement(new QName("parameter"));
            initialContextFactory.addAttribute("name", "java.naming.factory.initial", null);
            initialContextFactory.setText(jndiInitialFactory);
            OMElement providerUrl = omFactory.createOMElement(new QName("parameter"));
            providerUrl.addAttribute("name", "java.naming.provider.url", null);
            providerUrl.setText(jndiProviderUrl);
            OMElement connectionFactoryName = omFactory.createOMElement(new QName("parameter"));
            connectionFactoryName.addAttribute("name", "transport.jms.ConnectionFactoryJNDIName", null);
            connectionFactoryName.setText(confacJndiName);
            OMElement defaultConnectionFactory = omFactory.createOMElement(new QName("parameter"));
            defaultConnectionFactory.addChild((OMNode)initialContextFactory);
            defaultConnectionFactory.addChild((OMNode)providerUrl);
            defaultConnectionFactory.addChild((OMNode)connectionFactoryName);
            jmsTransportDescription.addParameter(new Parameter("default", (Object)defaultConnectionFactory));
        } else {
            this.getLogger().info("The JMS transport layer configuration is not complete. It is disabled.");
        }
    }

    protected AbstractServiceUnitManager createServiceUnitManager() {
        return new SoapSUManager(this);
    }

    protected void doInit() throws JBIException {
        this.soapContext = new SoapComponentContext(this.getComponentConfiguration(), this.getLogger());
        File axis2File = new File(this.getContext().getWorkspaceRoot(), "axis2.xml");
        if (!axis2File.exists()) {
            throw new JBIException("Can not get axis2 configuration file");
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, "Creating Axis configuration context...");
        }
        ConfigurationContext axisConfigurationContext = null;
        try {
            axisConfigurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.getContext().getWorkspaceRoot(), (String)axis2File.getAbsolutePath());
            this.createJMSTransporter(axisConfigurationContext);
            this.soapContext.setAxis2ConfigurationContext(axisConfigurationContext);
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Axis configuration context set.");
            }
        }
        catch (AxisFault e) {
            if (this.getLogger().isLoggable(Level.SEVERE)) {
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
            throw new JBIException("Can not initialize SOAP BC", (Throwable)e);
        }
        PetalsReceiver petalsReceiver = new PetalsReceiver(this.getLogger());
        this.externalListenerManager = new SoapExternalListenerManager((AbstractComponent)this, (AbstractServiceUnitManager)this.getServiceUnitManager(), this.soapContext, petalsReceiver, this.getLogger());
        AxisConfiguration axisConfiguration = axisConfigurationContext.getAxisConfiguration();
        SoapComponent.engageModulesHandlers(this.getLogger(), axisConfiguration);
        ((SoapSUManager)this.getServiceUnitManager()).init(this.soapContext, this.getContext(), this.externalListenerManager.getSoapServerConfig(), petalsReceiver, this.getLogger());
    }

    public void doStart() throws JBIException {
        try {
            AxisConfiguration axisConfiguration = this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration();
            this.externalListenerManager.start(axisConfiguration);
            try {
                axisConfiguration.getTransportIn("jms").getReceiver().start();
            }
            catch (AxisJMSException e) {
                if (this.getLogger().isLoggable(Level.WARNING)) {
                    this.getLogger().log(Level.WARNING, "The JMS Transport is not available. SOAP over JMS is not available.");
                }
            }
        }
        catch (AxisFault e) {
            if (this.getLogger().isLoggable(Level.SEVERE)) {
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
            throw new JBIException((Throwable)e);
        }
    }

    public void doStop() throws JBIException {
        try {
            this.externalListenerManager.stop();
            this.soapContext.getAxis2ConfigurationContext().getAxisConfiguration().getTransportIn("jms").getReceiver().stop();
        }
        catch (AxisFault e) {
            if (this.getLogger().isLoggable(Level.SEVERE)) {
                this.getLogger().log(Level.SEVERE, e.getMessage());
            }
            throw new JBIException((Throwable)e);
        }
    }

    private static final void engageModuleHandlersIntoPhases(Logger logger, AxisModule module, AxisConfiguration axisConfiguration) throws PhaseException {
        Flow moduleFlow = null;
        PhaseHolder phaseHolder = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Engaging module " + module.getName() + " in flows");
        }
        for (int type = 1; type <= 4; ++type) {
            if (type == 1) {
                phaseHolder = new PhaseHolder(axisConfiguration.getInFlowPhases());
                moduleFlow = module.getInFlow();
            } else if (type == 2) {
                phaseHolder = new PhaseHolder(axisConfiguration.getOutFlowPhases());
                moduleFlow = module.getOutFlow();
            } else if (type == 3) {
                phaseHolder = new PhaseHolder(axisConfiguration.getInFaultFlowPhases());
                moduleFlow = module.getFaultInFlow();
            } else if (type == 4) {
                phaseHolder = new PhaseHolder(axisConfiguration.getOutFaultFlowPhases());
                moduleFlow = module.getFaultOutFlow();
            }
            if (moduleFlow == null || phaseHolder == null) continue;
            for (int j = 0; j < moduleFlow.getHandlerCount(); ++j) {
                phaseHolder.addHandler(moduleFlow.getHandler(j));
            }
        }
    }

    private static final void engageModulesHandlers(Logger logger, AxisConfiguration axisConfiguration) throws JBIException {
        Iterator modules = axisConfiguration.getEngagedModules().iterator();
        while (modules.hasNext()) {
            try {
                AxisModule module = (AxisModule)modules.next();
                SoapComponent.engageModuleHandlersIntoPhases(logger, module, axisConfiguration);
            }
            catch (PhaseException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.getMessage());
                }
                throw new JBIException("Can not initialize SOAP BC", (Throwable)e);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Axis modules flows added.");
        }
    }

    public SoapExternalListenerManager getExternalListenerManager() {
        return this.externalListenerManager;
    }

    public SoapComponentContext getSoapContext() {
        return this.soapContext;
    }
}

