/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.axis;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.ow2.petals.binding.soap.axis.AbstractAxis2DirBasedObject;
import org.ow2.petals.binding.soap.axis.Axis2Config;
import org.ow2.petals.binding.soap.axis.Axis2Repository;

abstract class AbstractAxis2RepositoryBasedObject
extends AbstractAxis2DirBasedObject {
    private final File configDir;
    private final File configFile;
    private final Axis2Config config;
    private final Axis2Repository repository;
    private ConfigurationContext configurationContext;

    public AbstractAxis2RepositoryBasedObject(File baseDir, Axis2Config config) {
        super(baseDir);
        this.configDir = new File(baseDir, "conf");
        this.configFile = new File(this.configDir, "axis2.xml");
        this.config = config;
        this.repository = new Axis2Repository(new File(baseDir, "repository"));
        this.configurationContext = null;
    }

    @Override
    protected void specificSetUp() {
        this.createDirIfNeeded(this.configDir);
        try {
            FileWriter fw = new FileWriter(this.configFile);
            this.config.dump(fw);
            fw.close();
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
        this.repository.setUp();
    }

    protected final ConfigurationContext getConfigurationContext() {
        if (this.configurationContext == null) {
            try {
                this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repository.getBaseDir().getAbsolutePath(), (String)this.configFile.getAbsolutePath());
            }
            catch (AxisFault e) {
                throw new UncheckedException((Throwable)e);
            }
        }
        return this.configurationContext;
    }

    protected final Axis2Repository getRepository() {
        return this.repository;
    }
}

