/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.MessageReceiver;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.binding.BindingProtocol;
import org.ow2.petals.binding.soap.listener.incoming.PetalsReceiver;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.binding.soap.util.WsdlHelper;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.LoggingUtil;

public class PetalsDispatchPhase
extends DispatchPhase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkPostConditions(MessageContext msgContext) throws AxisFault {
        if (!msgContext.isServerSide()) return;
        AxisService service = msgContext.getAxisService();
        if (service == null) return;
        AxisService axisService = service;
        synchronized (axisService) {
            Parameter wsdlFoundParam = service.getParameter("org.ow2.petals.binding.soap.wsdlFound");
            boolean wsdlFound = (Boolean)wsdlFoundParam.getValue();
            if (!wsdlFound) {
                Parameter consumesConfigParam = service.getParameter("org.ow2.petals.binding.soap.consumes");
                Consumes consumes = (Consumes)consumesConfigParam.getValue();
                Parameter componentContextParam = service.getParameter("org.ow2.petals.binding.soap.componentContext");
                ComponentContext componentContext = (ComponentContext)componentContextParam.getValue();
                Parameter loggerParam = service.getParameter("org.ow2.petals.binding.soap.logger");
                Logger logger = (Logger)loggerParam.getValue();
                Parameter petalsReceiverParam = service.getParameter("org.ow2.petals.binding.soap.petalsReceiver");
                PetalsReceiver petalsReceiver = (PetalsReceiver)((Object)petalsReceiverParam.getValue());
                Description desc = WsdlHelper.getDescription(consumes, componentContext, logger);
                if (desc == null) {
                    String errorMessage = "WSDL description can not been retrieved from JBI endpoint";
                    LoggingUtil.addMonitFailureTrace((Logger)logger, (FlowAttributes)PetalsExecutionContext.getFlowAttributes(), (String)errorMessage, (MessageExchange.Role)MessageExchange.Role.CONSUMER);
                    throw new AxisFault(errorMessage, "Server");
                }
                this.addAxisOperation(service, petalsReceiver, desc);
                this.updateEndpoint(service, msgContext);
                Parameter consumesExtensionsParam = service.getParameter("org.ow2.petals.binding.soap.consumesExtensions");
                ConfigurationExtensions consumesExtensions = (ConfigurationExtensions)consumesExtensionsParam.getValue();
                if (SUPropertiesHelper.isWSAEnabled(consumesExtensions)) {
                    Parameter disableAddressingParam = service.getParameter("disableAddressingForInMessages");
                    service.removeParameter(disableAddressingParam);
                }
                this.resetFlow(msgContext);
                if (SUPropertiesHelper.getModules(consumesExtensions).contains("rampart")) {
                    AxisModule axisModule = service.getAxisConfiguration().getModule("rampart");
                    service.engageModule(axisModule, (AxisDescription)service);
                }
                wsdlFoundParam.setValue((Object)true);
                service.removeParameter(petalsReceiverParam);
            } else {
                super.checkPostConditions(msgContext);
            }
            return;
        }
    }

    private void updateEndpoint(AxisService service, MessageContext msgContext) throws AxisFault {
        service.getEndpoints().clear();
        Utils.addEndpointsToService((AxisService)service);
        AxisEndpoint axisEndpoint = (AxisEndpoint)msgContext.getProperty("endpoint");
        if (axisEndpoint != null) {
            axisEndpoint = service.getEndpoint(axisEndpoint.getName());
            msgContext.setProperty("endpoint", (Object)axisEndpoint);
        }
    }

    private void resetFlow(MessageContext msgContext) {
        List preCalculatedPhases;
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        if (msgContext.isFault() || msgContext.isProcessingFault()) {
            preCalculatedPhases = confContext.getAxisConfiguration().getInFaultFlowPhases();
            msgContext.setFLOW(3);
        } else {
            preCalculatedPhases = confContext.getAxisConfiguration().getInFlowPhases();
            msgContext.setFLOW(1);
        }
        ArrayList executionChain = new ArrayList();
        executionChain.addAll(preCalculatedPhases);
        msgContext.setExecutionChain(executionChain);
        msgContext.resetExecutedPhases();
    }

    private void addAxisOperation(AxisService service, PetalsReceiver petalsReceiver, Description desc) {
        List bindings = desc.getBindings();
        for (Binding binding : bindings) {
            List bindingOperations = binding.getBindingOperations();
            for (BindingOperation bindingOperation : bindingOperations) {
                List parts;
                Input input;
                InOutAxisOperation genericOperation = new InOutAxisOperation(bindingOperation.getQName());
                genericOperation.setSoapAction(bindingOperation.getSoapAction());
                String wsdl2Mep = this.getWSDL2Mep(bindingOperation);
                genericOperation.setMessageExchangePattern(wsdl2Mep);
                genericOperation.setMessageReceiver((MessageReceiver)petalsReceiver);
                service.addOperation((AxisOperation)genericOperation);
                Operation operation = (Operation)bindingOperation.getOperation();
                if (operation == null || (input = (Input)operation.getInput()) == null || (parts = input.getParts()) == null || parts.size() <= 1) continue;
                Element firstElement = ((Part)parts.get(0)).getElement();
                service.addMessageElementQNameToOperationMapping(firstElement.getQName(), (AxisOperation)genericOperation);
            }
        }
    }

    private String getWSDL2Mep(BindingOperation operation) {
        BindingProtocol.SOAPMEPConstants soapMep = operation.getMEP();
        String wsdl2Mep = soapMep == BindingProtocol.SOAPMEPConstants.ONE_WAY ? "http://www.w3.org/ns/wsdl/in-only" : (soapMep == BindingProtocol.SOAPMEPConstants.REQUEST_RESPONSE ? "http://www.w3.org/ns/wsdl/in-out" : "http://www.w3.org/ns/wsdl/out-only");
        return wsdl2Mep;
    }
}

