/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.binding.soap.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.binding.soap.SoapConstants;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;

public class ComponentPropertiesHelper {
    private ComponentPropertiesHelper() {
    }

    public static String getHttpHostName(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"http-host");
    }

    public static int getHttpPort(Logger logger, ConfigurationExtensions configurationExtensions) {
        return ComponentPropertiesHelper.getInt(logger, configurationExtensions, "http-port", 8084);
    }

    public static boolean isProvidingServicesList(ConfigurationExtensions configurationExtensions) {
        return Boolean.parseBoolean(configurationExtensions.get((Object)"http-services-list"));
    }

    public static String getServicesContext(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"http-services-context");
    }

    public static String getServicesMapping(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"http-services-mapping");
    }

    public static int getHttpThreadMaxPoolSize(Logger logger, ConfigurationExtensions configurationExtensions) {
        return ComponentPropertiesHelper.getInt(logger, configurationExtensions, "http-thread-pool-size-max", 255);
    }

    public static int getHttpThreadMinPoolSize(Logger logger, ConfigurationExtensions configurationExtensions) {
        return ComponentPropertiesHelper.getInt(logger, configurationExtensions, "http-thread-pool-size-min", 2);
    }

    public static int getHttpAcceptors(Logger logger, ConfigurationExtensions configurationExtensions) {
        return ComponentPropertiesHelper.getInt(logger, configurationExtensions, "http-acceptors", 4);
    }

    public static boolean isHttpsEnabled(ConfigurationExtensions configurationExtensions) {
        return Boolean.parseBoolean(configurationExtensions.get((Object)"https-enabled"));
    }

    public static boolean isHttpsClientAuthEnabled(ConfigurationExtensions configurationExtensions) {
        return Boolean.parseBoolean(configurationExtensions.get((Object)"https-client-authentication-enabled", Boolean.toString(SoapConstants.HttpServer.DEFAULT_HTTPS_CLIENT_AUTH_ENABLED)));
    }

    public static int getHttpsPort(Logger logger, ConfigurationExtensions configurationExtensions) {
        return ComponentPropertiesHelper.getInt(logger, configurationExtensions, "https-port", 8083);
    }

    public static String getHttpsKeystoreType(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"https-keystore-type");
    }

    public static String getHttpsKeystoreFile(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"https-keystore-file");
    }

    public static String getHttpsKeystorePassword(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"https-keystore-password");
    }

    public static String getHttpsKeyPassword(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"https-key-password");
    }

    public static String getHttpsTruststoreType(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"https-truststore-type");
    }

    public static String getHttpsTruststoreFile(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"https-truststore-file");
    }

    public static String getHttpsTruststorePassword(ConfigurationExtensions configurationExtensions) {
        return configurationExtensions.get((Object)"https-truststore-password");
    }

    private static final int getInt(Logger logger, ConfigurationExtensions configurationExtensions, String parameterName, int defaultValue) {
        int intValue;
        block2: {
            String intStr = configurationExtensions.get((Object)parameterName);
            try {
                intValue = Integer.parseInt(intStr);
            }
            catch (NumberFormatException e) {
                intValue = defaultValue;
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "The value of the parameter " + parameterName + " is not correct, use the default value");
            }
        }
        return intValue;
    }
}

