/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.uuid.QualifiedUUIDGenerator;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.commons.logger.ProvideFlowStepBeginDumpLogData;
import org.ow2.petals.commons.logger.ProvideFlowStepBeginLogData;
import org.ow2.petals.commons.logger.TraceCode;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.exception.SOAP11FaultServerException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.ExchangeProperties;
import org.ow2.petals.component.framework.jbidescriptor.generated.MessageParam;
import org.ow2.petals.component.framework.jbidescriptor.generated.MessageProperties;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.process.async.AsyncMessageManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.LoggingUtil;

public class MessageExchangeProcessor
implements Runnable {
    private final AbstractComponent component;
    private final Logger logger;
    private final DeliveryChannel deliveryChannel;
    private final Object transactionManager;
    private final AbstractJBIListener jbiListener;
    private final AbstractServiceUnitManager suManager;
    private final AsyncMessageManager asyncManager;
    private final String componentName;
    private ExchangeImpl exchange = null;

    public MessageExchangeProcessor(AbstractComponent component, AbstractJBIListener jbiListener, Logger logger) {
        this.component = component;
        this.jbiListener = jbiListener;
        this.logger = logger;
        this.deliveryChannel = component.getChannel();
        this.suManager = (AbstractServiceUnitManager)component.getServiceUnitManager();
        this.asyncManager = component.getAsyncManager();
        this.transactionManager = component.getContext().getTransactionManager();
        this.componentName = component.getContext().getComponentName();
    }

    public void setMessageExchange(ExchangeImpl exchange) {
        this.exchange = exchange;
    }

    public ExchangeImpl getMessageExchange() {
        return this.exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.process(this.exchange);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            try {
                if (this.exchange.isActiveStatus()) {
                    if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern())) {
                        this.exchange.setFault(e);
                    } else {
                        this.exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)e))));
                    }
                    this.deliveryChannel.send(this.exchange.getMessageExchange());
                }
                MessageExchange messageExchange = this.exchange.getMessageExchange();
                FlowAttributes flowAttributes = messageExchange.getFlowAttributes();
                LoggingUtil.addMonitEndOrFailureTrace(this.logger, this.exchange, flowAttributes);
            }
            catch (MessagingException me) {
                this.logger.log(Level.SEVERE, "Cannot send back an error acknowledgement or a Fault", me);
            }
        }
        finally {
            ExecutionContext.getProperties().clear();
        }
    }

    protected final void clean() {
        this.jbiListener.setConsumes(null);
        this.jbiListener.setProvides(null);
        this.jbiListener.setExtensions(null);
        this.jbiListener.setCurrentTransaction(null);
        this.exchange = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void process(Exchange exchange) throws MessagingException {
        this.setCurrentTransaction();
        if (exchange.isProviderRole() && exchange.getProperty("org.ow2.petals.component.framework.asynchronous.expired") == null) {
            try {
                this.processAsProvider(exchange);
                return;
            }
            catch (RuntimeException e) {
                if (!exchange.isProviderRole()) return;
                throw e;
            }
            catch (MessagingException e) {
                if (!exchange.isProviderRole()) return;
                throw e;
            }
        }
        try {
            this.processAsConsumer(exchange);
            return;
        }
        catch (RuntimeException e) {
            if (!exchange.isConsumerRole()) return;
            throw e;
        }
        catch (MessagingException e) {
            if (!exchange.isConsumerRole()) return;
            throw e;
        }
    }

    private final void processAsConsumer(Exchange exchange) throws MessagingException {
        boolean isAnAsynchronousExchange;
        AsyncContext asyncContext = null;
        this.logger.finest("Process an exchange as CONSUMER with id : " + exchange.getExchangeId());
        Consumes consumes = this.getConsumesFromExchange(exchange);
        if (consumes != null) {
            this.jbiListener.setConsumes(consumes);
            this.jbiListener.setExtensions(this.getExtensions(consumes));
            try {
                this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, consumes, Message.InterceptorPhase.SEND_RESPONSE);
            }
            catch (PEtALSCDKException e) {
                throw new MessagingException((Throwable)e);
            }
        } else {
            this.logger.fine("The exchange '" + exchange.getExchangeId() + "' refers to an unknown consumer on the component : " + this.componentName + ". The listener will not have the consumes and the extensions for this exchange");
        }
        if (this.exchange.getProperty("org.ow2.petals.component.framework.asynchronous") != null) {
            isAnAsynchronousExchange = true;
            asyncContext = this.asyncManager.unreferenceAsyncContext(this.exchange.getExchangeId());
        } else {
            isAnAsynchronousExchange = false;
        }
        if (exchange.isInOnlyPattern()) {
            this.processInOnlyAsConsumer(exchange, asyncContext);
        } else if (exchange.isRobustInOnlyPattern()) {
            this.processRobustInOnlyAsConsumer(exchange, asyncContext, isAnAsynchronousExchange);
        } else if (exchange.isInOutPattern()) {
            this.processInOutAsConsumer(exchange, asyncContext, isAnAsynchronousExchange);
        } else if (exchange.isInOptionalOutPattern()) {
            this.processInOptionalOutAsConsumer(exchange, asyncContext, isAnAsynchronousExchange);
        } else {
            throw new MessagingException("Message Exchange Pattern not recognized :" + exchange.getPattern());
        }
    }

    private final void processAsProvider(Exchange exchange) throws MessagingException {
        boolean exchangeIsActiveStatusAndIsNotAFault;
        this.logger.log(Level.FINEST, "Process an exchange as PROVIDER with id : " + exchange.getExchangeId());
        boolean bl = exchangeIsActiveStatusAndIsNotAFault = exchange.isActiveStatus() && exchange.getFault() == null;
        if (exchangeIsActiveStatusAndIsNotAFault) {
            MessageExchange messageExchange = ((ExchangeImpl)exchange).getMessageExchange();
            FlowAttributes flowAttributes = messageExchange.getFlowAttributes();
            if (flowAttributes != null) {
                PetalsExecutionContext.putFlowAttributes((FlowAttributes)flowAttributes);
                PetalsExecutionContext.nextFlowStepId();
                FlowAttributes newFlowAttributes = PetalsExecutionContext.getFlowAttributes();
                messageExchange.setFlowAttributes(newFlowAttributes);
            }
            this.logger.log(Level.MONIT, "", this.newProvideFlowStepBeginLogData(exchange));
            this.dumpProvideBeginMessageContent(exchange);
        }
        Provides provides = this.getProvidesFromExchange(exchange);
        if (!this.isOperationAvailableForExchangeEndpoint(exchange)) {
            throw new MessagingException("Operation '" + exchange.getOperation().toString() + "' not found in endpoint '" + exchange.getEndpointName() + "' description");
        }
        if (provides == null) {
            if (this.component.getServiceDescription(exchange.getEndpoint()) == null) {
                throw new MessagingException("The endpoint '" + exchange.getEndpoint() + "' is unknown on the component : " + this.componentName);
            }
            this.logger.fine("Process an exchange managed directly by the component");
        } else {
            this.jbiListener.setProvides(provides);
            this.jbiListener.setExtensions(this.getExtensions(provides));
            try {
                this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT);
            }
            catch (PEtALSCDKException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        if (exchange.getProperty("org.ow2.petals.propagate.correlation") == null) {
            String correlationId = new QualifiedUUIDGenerator("petals:uid").getNewID();
            exchange.setProperty("org.ow2.petals.propagate.correlation", (Object)correlationId);
        }
        if (exchange.isInOnlyPattern()) {
            this.processInOnlyAsProvider(exchange, provides);
        } else if (exchange.isRobustInOnlyPattern()) {
            this.processRobustInOnlyAsProvider(exchange, provides);
        } else if (exchange.isInOutPattern()) {
            this.processInOutAsProvider(exchange, provides);
        } else if (exchange.isInOptionalOutPattern()) {
            this.processInOptionalOutAsProvider(exchange, provides);
        } else {
            throw new MessagingException("Message Exchange Pattern not recognized :" + exchange.getPattern());
        }
    }

    private void dumpProvideBeginMessageContent(Exchange exchange) {
        FlowAttributes newFlowAttributes;
        if (LoggingUtil.isDumpEnabled(this.logger) && (newFlowAttributes = PetalsExecutionContext.getFlowAttributes()) != null) {
            try {
                File dumpFile = LoggingUtil.dumpMessageContent(exchange.getInMessageContentAsSource(), TraceCode.PROVIDE_FLOW_STEP_BEGIN);
                this.logger.log(Level.MONIT_MSG, "", new ProvideFlowStepBeginDumpLogData(newFlowAttributes.getFlowInstanceId(), newFlowAttributes.getFlowStepId(), dumpFile.getAbsolutePath()));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Cannot dump mesage content", e);
            }
        }
    }

    private boolean isOperationAvailableForExchangeEndpoint(Exchange exchange) throws MessagingException {
        List<QName> epOperations;
        boolean operationExists = true;
        ServiceUnitDataHandler suDataHandler = this.suManager.getSUDataHandlerForEndpoint(exchange.getEndpoint());
        if (suDataHandler != null && (epOperations = suDataHandler.getEndpointOperationsList(exchange.getEndpoint())) != null && !epOperations.isEmpty()) {
            operationExists = epOperations.contains(exchange.getOperation());
        }
        return operationExists;
    }

    protected final ProvideFlowStepBeginLogData newProvideFlowStepBeginLogData(Exchange exchange) {
        String edptName = "";
        QName serviceName = null;
        if (exchange.getEndpoint() != null) {
            edptName = exchange.getEndpoint().getEndpointName();
            serviceName = exchange.getEndpoint().getServiceName();
        }
        return new ProvideFlowStepBeginLogData(ExecutionContext.getProperties().getProperty("flowInstanceId"), ExecutionContext.getProperties().getProperty("flowStepId"), StringHelper.nonNullValue((Object)exchange.getInterfaceName()), StringHelper.nonNullValue((Object)serviceName), StringHelper.nonNullValue((Object)exchange.getOperation()), edptName, ExecutionContext.getProperties().getProperty("flowPreviousStepId"));
    }

    private final void processInOnlyAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        if (asyncContext == null) {
            this.jbiListener.onJBIMessage(exchange);
        } else if (exchange.getProperty("org.ow2.petals.component.framework.asynchronous.expired") != null) {
            this.jbiListener.onExpiredAsyncJBIMessage(asyncContext.getOriginalExchange(), asyncContext);
        } else {
            this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
    }

    private final void processInOnlyAsProvider(Exchange exchange, Provides provides) throws MessagingException {
        boolean activeStatusReceived = exchange.isActiveStatus();
        boolean faultReceived = exchange.getFault() != null;
        boolean reply = this.jbiListener.onJBIMessage(exchange);
        if (reply && activeStatusReceived) {
            if (exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.interceptAndSend(exchange, provides, faultReceived);
        }
    }

    private final void processInOptionalOutAsConsumer(Exchange exchange, AsyncContext asyncContext, boolean isAnAsynchronousExchange) throws MessagingException {
        boolean reply = false;
        boolean doneOrErrorStatusReceived = false;
        if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
            doneOrErrorStatusReceived = true;
        }
        if (asyncContext == null) {
            if (isAnAsynchronousExchange && exchange.isActiveStatus()) {
                this.logger.warning("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!");
                exchange.setError(new Exception("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!"));
                exchange.setProperty("org.ow2.petals.component.framework.asynchronous.expired", null);
                this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
            } else {
                reply = this.jbiListener.onJBIMessage(exchange);
            }
        } else {
            reply = exchange.getProperty("org.ow2.petals.component.framework.asynchronous.expired") != null ? this.jbiListener.onExpiredAsyncJBIMessage(asyncContext.getOriginalExchange(), asyncContext) : this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
        if (reply && !doneOrErrorStatusReceived) {
            if (exchange.getFault() == null && exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOptionalOutAsProvider(Exchange exchange, Provides provides) throws MessagingException {
        boolean activeStatusReceived = exchange.isActiveStatus();
        boolean faultReceived = exchange.getFault() != null;
        boolean reply = this.jbiListener.onJBIMessage(exchange);
        if (provides != null && exchange.isOutMessage()) {
            MessageExchangeProcessor.forwardMessageData(exchange, provides);
        }
        if (reply & activeStatusReceived) {
            if (exchange.isActiveStatus() && (faultReceived || exchange.getFault() == null && !((ExchangeImpl)exchange).isOutMessage())) {
                exchange.setDoneStatus();
            }
            this.interceptAndSend(exchange, provides, faultReceived);
        }
    }

    private final void processInOutAsConsumer(Exchange exchange, AsyncContext asyncContext, boolean isAnAsynchronousExchange) throws MessagingException {
        boolean reply = false;
        if (asyncContext == null) {
            if (isAnAsynchronousExchange && exchange.isActiveStatus()) {
                this.logger.warning("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!");
                exchange.setError(new Exception("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!"));
                exchange.setProperty("org.ow2.petals.component.framework.asynchronous.expired", null);
                this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
            } else {
                reply = this.jbiListener.onJBIMessage(exchange);
            }
        } else {
            reply = exchange.getProperty("org.ow2.petals.component.framework.asynchronous.expired") != null ? this.jbiListener.onExpiredAsyncJBIMessage(asyncContext.getOriginalExchange(), asyncContext) : this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
        if (reply) {
            if (exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOutAsProvider(Exchange exchange, Provides provides) throws MessagingException {
        boolean faultReceived;
        boolean activeStatusReceived;
        boolean reply;
        block7: {
            reply = false;
            activeStatusReceived = exchange.isActiveStatus();
            faultReceived = exchange.getFault() != null;
            try {
                reply = this.jbiListener.onJBIMessage(exchange);
                if (provides != null && exchange.isOutMessage()) {
                    MessageExchangeProcessor.forwardMessageData(exchange, provides);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "An unexpected exception occured during an exchange processing", e);
                if (exchange.getFault() != null) break block7;
                exchange.setFault((Throwable)new SOAP11FaultServerException(e.getMessage(), Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName), (Throwable)e));
                reply = true;
            }
        }
        if (reply && activeStatusReceived) {
            if (exchange.getFault() == null && !exchange.isOutMessage()) {
                if (exchange.getError() != null) {
                    exchange.setFault((Throwable)new SOAP11FaultServerException(exchange.getError().getMessage(), Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName), (Throwable)exchange.getError()));
                } else {
                    exchange.setFault((Throwable)new SOAP11FaultServerException("The Provider do not return any response", Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName)));
                }
            }
            this.interceptAndSend(exchange, provides, faultReceived);
        }
    }

    private final void processRobustInOnlyAsConsumer(Exchange exchange, AsyncContext asyncContext, boolean isAnAsynchronousExchange) throws MessagingException {
        if (asyncContext == null) {
            if (isAnAsynchronousExchange && exchange.isActiveStatus()) {
                this.logger.warning("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!");
                exchange.setError(new Exception("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!"));
                exchange.setProperty("org.ow2.petals.component.framework.asynchronous.expired", null);
                this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
            } else {
                this.jbiListener.onJBIMessage(exchange);
            }
        } else if (exchange.getProperty("org.ow2.petals.component.framework.asynchronous.expired") != null) {
            this.jbiListener.onExpiredAsyncJBIMessage(asyncContext.getOriginalExchange(), asyncContext);
        } else {
            this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
    }

    private final void processRobustInOnlyAsProvider(Exchange exchange, Provides provides) throws MessagingException {
        boolean activeStatusReceived = exchange.isActiveStatus();
        boolean faultReceived = exchange.getFault() != null;
        boolean reply = this.jbiListener.onJBIMessage(exchange);
        if (reply && activeStatusReceived) {
            if (exchange.getFault() == null && exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.interceptAndSend(exchange, provides, faultReceived);
        }
    }

    private final void interceptAndSend(Exchange exchange, Provides provides, boolean faultReceived) throws MessagingException {
        if (provides != null) {
            try {
                this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
            }
            catch (PEtALSCDKException e) {
                throw new MessagingException((Throwable)e);
            }
            this.setProperties(provides);
        }
        MessageExchange messageExchange = ((ExchangeImpl)exchange).getMessageExchange();
        if (!faultReceived) {
            FlowAttributes flowAttributes = messageExchange.getFlowAttributes();
            LoggingUtil.addMonitEndOrFailureTrace(this.logger, exchange, flowAttributes);
            if (flowAttributes != null) {
                messageExchange.setFlowAttributes(new FlowAttributes(flowAttributes.getFlowInstanceId(), ExecutionContext.getProperties().getProperty("flowPreviousStepId")));
            }
        }
        this.deliveryChannel.send(messageExchange);
    }

    private final ConfigurationExtensions getExtensions(Object service) {
        ConfigurationExtensions extensions = null;
        if (service == null) {
            return null;
        }
        ServiceUnitDataHandler suDataHandler = this.suManager.getSUDataHandlerForService(service);
        if (suDataHandler != null) {
            extensions = suDataHandler.getConfigurationExtensions(service);
        }
        return extensions;
    }

    private final Consumes getConsumesFromExchange(Exchange exchange) {
        ServiceEndpoint endpoint = exchange.getEndpoint();
        return this.suManager.getConsumesFromDestination(endpoint.getEndpointName(), exchange.getService(), exchange.getInterfaceName());
    }

    private final Provides getProvidesFromExchange(Exchange exchange) {
        ServiceEndpoint ep = exchange.getEndpoint();
        Provides provides = this.suManager.getProvidesFromEndpoint(ep);
        return provides;
    }

    private final void setCurrentTransaction() {
        if (this.exchange.isTransacted()) {
            Transaction currentTransaction = (Transaction)this.exchange.getProperty("javax.jbi.transaction.jta");
            if (currentTransaction == null) {
                try {
                    currentTransaction = ((TransactionManager)this.transactionManager).getTransaction();
                }
                catch (SystemException e) {
                    this.logger.log(Level.WARNING, "Failed to retrieve Transaction for exchange '" + this.exchange.getExchangeId() + "'", e);
                }
            }
            this.jbiListener.setCurrentTransaction(currentTransaction);
        }
    }

    private final void setProperties(Provides provides) throws MessagingException {
        MessageProperties messageProperties;
        ExchangeProperties exchangeProperties = provides.getExchangeProperties();
        if (exchangeProperties != null) {
            for (Param exchangeProperty : exchangeProperties.getExchangeProperty()) {
                this.exchange.setProperty(exchangeProperty.getName(), exchangeProperty.getValue());
            }
        }
        if ((messageProperties = provides.getMessageProperties()) != null) {
            for (MessageParam messageProperty : messageProperties.getMessageProperty()) {
                NormalizedMessage message = this.exchange.getMessageExchange().getMessage(messageProperty.getMessage().name());
                message.setProperty(messageProperty.getName(), (Object)messageProperty.getValue());
            }
        }
    }

    private static final void forwardMessageData(Exchange exchange, Provides provides) throws MessagingException {
        if (provides == null) {
            return;
        }
        if (provides.isForwardSecuritySubject() != null && provides.isForwardSecuritySubject().booleanValue() && exchange.getInSubject() != null && exchange.getOutSubject() == null) {
            exchange.setOutSubject(exchange.getInSubject());
        }
        if (provides.isForwardMessageProperties() != null && provides.isForwardMessageProperties().booleanValue()) {
            for (String propertyName : exchange.getInMessagePropertyNames()) {
                if (exchange.getOutMessageProperty(propertyName) != null) continue;
                exchange.setOutMessageProperty(propertyName, exchange.getInMessageProperty(propertyName));
            }
        }
        if (provides.isForwardAttachments() != null && provides.isForwardAttachments().booleanValue()) {
            Set attachmentNames = exchange.getInMessageAttachmentNames();
            for (String attachmentName : attachmentNames) {
                if (exchange.getOutMessageAttachment(attachmentName) != null) continue;
                exchange.setOutMessageAttachment(attachmentName, exchange.getInMessageAttachment(attachmentName));
            }
        }
    }
}

