/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sql.service;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.MessagingException;

public class SQLParameter {
    public static final Map<String, Integer> SQL_TYPES = new HashMap<String, Integer>();
    public static final String DEFAULT_SCOPE = "IN";
    public static final String IN_SCOPE = "IN";
    public static final String OUT_SCOPE = "OUT";
    public static final String INOUT_SCOPE = "INOUT";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSSS");
    private final int type;
    private final String scope;
    private final short rank;
    private String value;

    public SQLParameter(String type, String scope, short rank) throws MessagingException {
        this.type = SQL_TYPES.get(type);
        this.scope = scope;
        this.rank = rank;
        if (this.type == 0) {
            throw new MessagingException("SQL Type " + type + "not recognized");
        }
    }

    public SQLParameter(String externalizedSQLParameter, String value) throws MessagingException {
        String[] splittedStrings = externalizedSQLParameter.split(":");
        this.rank = Short.valueOf(splittedStrings[0]);
        this.scope = splittedStrings[1];
        this.type = Integer.valueOf(splittedStrings[2]);
        this.value = value;
        if (this.type == 0) {
            throw new MessagingException("SQL Type " + this.type + "not recognized");
        }
    }

    public int getType() {
        return this.type;
    }

    public String getScope() {
        return this.scope;
    }

    public short getRank() {
        return this.rank;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.rank + ":" + this.scope + ":" + this.type;
    }

    public static final void setSQLParameter(CallableStatement statement, SQLParameter sqlParameter, short rank) throws SQLException, ParseException, MessagingException, IOException {
        switch (sqlParameter.getType()) {
            case 16: {
                statement.setBoolean(Short.valueOf(rank).shortValue(), (boolean)Boolean.valueOf(sqlParameter.getValue()));
                break;
            }
            case 91: {
                Date date = dateFormat.parse(sqlParameter.getValue());
                statement.setDate(Short.valueOf(rank).shortValue(), new java.sql.Date(date.getTime()));
                break;
            }
            case 8: {
                statement.setDouble(Short.valueOf(rank).shortValue(), (double)Double.valueOf(sqlParameter.getValue()));
                break;
            }
            case 6: {
                statement.setFloat(Short.valueOf(rank).shortValue(), Float.valueOf(sqlParameter.getValue()).floatValue());
                break;
            }
            case 4: {
                statement.setInt(Short.valueOf(rank).shortValue(), (int)Integer.valueOf(sqlParameter.getValue()));
                break;
            }
            case -1: {
                statement.setString(Short.valueOf(rank).shortValue(), sqlParameter.getValue());
                break;
            }
            case 5: {
                statement.setInt(Short.valueOf(rank).shortValue(), (int)Integer.valueOf(sqlParameter.getValue()));
                break;
            }
            case 92: {
                Date time = timeFormat.parse(sqlParameter.getValue());
                statement.setTime(Short.valueOf(rank).shortValue(), new Time(time.getTime()));
                break;
            }
            case 93: {
                Date timestamp = timestampFormat.parse(sqlParameter.getValue());
                statement.setTimestamp(Short.valueOf(rank).shortValue(), new Timestamp(timestamp.getTime()));
                break;
            }
            case -6: {
                statement.setInt(Short.valueOf(rank).shortValue(), (int)Integer.valueOf(sqlParameter.getValue()));
                break;
            }
            case 12: {
                statement.setString(Short.valueOf(rank).shortValue(), sqlParameter.getValue());
                break;
            }
            case 2005: {
                Reader clobReader = statement.getClob(rank).getCharacterStream();
                StringBuilder resultBuilder = new StringBuilder();
                int size = 0;
                char[] buffer = new char[64];
                while ((size = clobReader.read(buffer)) != -1) {
                    resultBuilder.append(buffer, 0, size);
                }
                clobReader.close();
                statement.setString(Short.valueOf(rank).shortValue(), resultBuilder.toString());
                break;
            }
            default: {
                for (Map.Entry<String, Integer> entry : SQL_TYPES.entrySet()) {
                    if (entry.getValue().intValue() != sqlParameter.getType()) continue;
                    throw new MessagingException("Type : " + entry.getKey() + " is not supported by the SQL component");
                }
            }
        }
    }

    public static final void getSQLParameter(CallableStatement statement, SQLParameter sqlParameter, short rank) throws SQLException, IOException, MessagingException {
        String result = null;
        switch (sqlParameter.getType()) {
            case 16: {
                result = Boolean.toString(statement.getBoolean(rank));
                break;
            }
            case 91: {
                result = statement.getDate(rank).toString();
                break;
            }
            case 8: {
                result = Double.toString(statement.getDouble(rank));
                break;
            }
            case 6: {
                result = Float.toString(statement.getFloat(rank));
                break;
            }
            case 4: {
                result = Integer.toString(statement.getInt(rank));
                break;
            }
            case -1: {
                result = statement.getString(rank);
                break;
            }
            case 5: {
                result = Integer.toString(statement.getInt(rank));
                break;
            }
            case 92: {
                result = statement.getTime(rank).toString();
                break;
            }
            case 93: {
                result = statement.getTimestamp(rank).toString();
                break;
            }
            case -6: {
                result = Integer.toString(statement.getInt(rank));
                break;
            }
            case 12: {
                result = statement.getString(rank);
                break;
            }
            case 2005: {
                Reader clobReader = statement.getClob(rank).getCharacterStream();
                StringBuilder resultBuilder = new StringBuilder();
                int size = 0;
                char[] buffer = new char[64];
                while ((size = clobReader.read(buffer)) != -1) {
                    resultBuilder.append(buffer, 0, size);
                }
                clobReader.close();
                result = resultBuilder.toString();
                break;
            }
            default: {
                for (Map.Entry<String, Integer> entry : SQL_TYPES.entrySet()) {
                    if (entry.getValue().intValue() != sqlParameter.getType()) continue;
                    throw new MessagingException("Type : " + entry.getKey() + " is not supported by the SQL component");
                }
            }
        }
        sqlParameter.setValue(result);
    }

    static {
        SQL_TYPES.put("ARRAY", 4);
        SQL_TYPES.put("BIGINT", -5);
        SQL_TYPES.put("BINARY", -2);
        SQL_TYPES.put("BIT", -7);
        SQL_TYPES.put("BLOB", 2004);
        SQL_TYPES.put("BOOLEAN ", 16);
        SQL_TYPES.put("CHAR", 1);
        SQL_TYPES.put("CLOB", 2005);
        SQL_TYPES.put("DATALINK", 70);
        SQL_TYPES.put("DATE", 91);
        SQL_TYPES.put("DECIMAL", 3);
        SQL_TYPES.put("DISTINCT", 2001);
        SQL_TYPES.put("DOUBLE", 8);
        SQL_TYPES.put("FLOAT", 6);
        SQL_TYPES.put("INT", 4);
        SQL_TYPES.put("INTEGER", 4);
        SQL_TYPES.put("LONGVARBINARY", -4);
        SQL_TYPES.put("LONGVARCHAR", -1);
        SQL_TYPES.put("NUMERIC", 2);
        SQL_TYPES.put("OTHER", 1111);
        SQL_TYPES.put("REAL", 7);
        SQL_TYPES.put("REF", 2006);
        SQL_TYPES.put("SMALLINT", 5);
        SQL_TYPES.put("STRUCT", 2002);
        SQL_TYPES.put("TIME", 92);
        SQL_TYPES.put("TIMESTAMP", 93);
        SQL_TYPES.put("TINYINT", -6);
        SQL_TYPES.put("VARBINARY", -3);
        SQL_TYPES.put("VARCHAR", 12);
        SQL_TYPES.put("VARCHAR2", 12);
        SQL_TYPES.put("LONG", 12);
    }
}

