/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sql.service;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.xml.XMLOutputFactories;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.ow2.petals.bc.sql.SqlProvideExtFlowStepBeginLogData;
import org.ow2.petals.bc.sql.service.SQLParameter;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.logger.ProvideExtFlowStepEndLogData;

public class SQLService {
    private final Logger logger;

    public SQLService(Logger logger) {
        this.logger = logger;
    }

    public ResultSet select(String sql, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        this.logger.info("Execute the following SQL statement : " + sql);
        this.addMonitBeginStepExtTrace();
        ResultSet resultSet = statement.executeQuery(sql);
        this.addMonitEndStepExtTrace();
        return resultSet;
    }

    public void storedProcedure(List<SQLParameter> sqlParameters, String call, Connection connection) throws SQLException, ParseException, MessagingException, IOException {
        CallableStatement statement = connection.prepareCall(call);
        for (SQLParameter sqlParameter : sqlParameters) {
            if ("IN".equals(sqlParameter.getScope()) || "INOUT".equals(sqlParameter.getScope())) {
                this.logger.finest("Register a SQL stored procedure parameter : " + sqlParameter);
                SQLParameter.setSQLParameter(statement, sqlParameter, sqlParameter.getRank());
            }
            if ("IN".equals(sqlParameter.getScope())) continue;
            this.logger.finest("Register SQL stored procedure parameter to return : " + sqlParameter);
            statement.registerOutParameter((int)sqlParameter.getRank(), sqlParameter.getType());
        }
        this.logger.info("Execute the following SQL stored procedure : " + call);
        this.addMonitBeginStepExtTrace();
        statement.execute();
        this.addMonitEndStepExtTrace();
        for (SQLParameter sqlParameter : sqlParameters) {
            if (!"OUT".equals(sqlParameter.getScope()) && !"INOUT".equals(sqlParameter.getScope())) continue;
            SQLParameter.getSQLParameter(statement, sqlParameter, sqlParameter.getRank());
            this.logger.finest("Set a returned SQL stored procedure parameter : " + sqlParameter);
        }
    }

    public int update(String sql, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        this.logger.info("Execute the following SQL instruction : " + sql);
        this.addMonitBeginStepExtTrace();
        int nbOfUpdatedRows = statement.executeUpdate(sql);
        this.addMonitEndStepExtTrace();
        return nbOfUpdatedRows;
    }

    public void resultSetAsXMLOutputStream(ResultSet resultSet, OutputStream outputStream, boolean showAttributes) throws SQLException, XMLStreamException {
        XMLStreamWriter writer = XMLOutputFactories.createXMLStreamWriter((OutputStream)outputStream);
        writer.writeStartDocument();
        writer.writeStartElement("result");
        writer.writeDefaultNamespace("http://petals.ow2.org/components/sql/version-1");
        if (resultSet != null) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                writer.writeStartElement("row");
                if (showAttributes) {
                    writer.writeAttribute("index", Integer.toString(resultSet.getRow()));
                }
                for (int i = 1; i <= columnCount; ++i) {
                    String resultvalue;
                    writer.writeStartElement("column");
                    if (showAttributes) {
                        writer.writeAttribute("name", metaData.getColumnName(i));
                        writer.writeAttribute("type", metaData.getColumnTypeName(i));
                    }
                    if ((resultvalue = resultSet.getString(i)) == null) {
                        writer.writeCharacters("NULL");
                    } else {
                        writer.writeCharacters(resultvalue);
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    public void sqlParametersAsXMLOutputStream(List<SQLParameter> sqlParameters, OutputStream outputStream, boolean isResultXML) throws XMLStreamException, IOException {
        XMLStreamWriter writer = XMLOutputFactories.createXMLStreamWriter((OutputStream)outputStream);
        writer.writeStartDocument();
        writer.writeStartElement("storedProcedureResult");
        writer.writeDefaultNamespace("http://petals.ow2.org/components/sql/version-1");
        if (isResultXML) {
            for (SQLParameter sqlParameter : sqlParameters) {
                if (!"INOUT".equals(sqlParameter.getScope()) && !"OUT".equals(sqlParameter.getScope())) continue;
                writer.writeStartElement("parameter");
                writer.writeAttribute("rank", Short.toString(sqlParameter.getRank()));
                if (sqlParameter.getValue() == null) {
                    writer.writeCharacters("NULL");
                } else {
                    writer.writeCharacters(sqlParameter.getValue());
                }
                writer.writeEndElement();
            }
        } else {
            Iterator<SQLParameter> sqlParameterIterator = sqlParameters.iterator();
            while (sqlParameterIterator.hasNext()) {
                SQLParameter sqlParameter = sqlParameterIterator.next();
                if ("INOUT".equals(sqlParameter.getScope()) || "OUT".equals(sqlParameter.getScope())) {
                    writer.writeCharacters(sqlParameter.getRank() + ":" + sqlParameter.getScope() + ":" + sqlParameter.getValue());
                }
                if (!sqlParameterIterator.hasNext()) continue;
                writer.writeCharacters(";");
            }
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void addMonitBeginStepExtTrace() {
        FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
        String flowInstanceId = "";
        String flowStepId = "";
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        String sqlOperation = (String)ExecutionContext.getProperties().get("flowStepOperationName");
        this.logger.log(Level.MONIT, "", (Object)new SqlProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, sqlOperation));
    }

    private void addMonitEndStepExtTrace() {
        if (!this.isInOnlySqlOperation()) {
            FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
            String flowInstanceId = "";
            String flowStepId = "";
            if (flowAttributes != null) {
                flowInstanceId = flowAttributes.getFlowInstanceId();
                flowStepId = flowAttributes.getFlowStepId();
            }
            this.logger.log(Level.MONIT, "", new ProvideExtFlowStepEndLogData(flowInstanceId, flowStepId));
        }
    }

    private boolean isInOnlySqlOperation() {
        QName sqlOperation = QName.valueOf((String)ExecutionContext.getProperties().get("flowStepOperationName"));
        return "insert".equals(sqlOperation.getLocalPart()) || "delete".equals(sqlOperation.getLocalPart()) || "update".equals(sqlOperation.getLocalPart());
    }
}

