/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sql.su;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jbi.messaging.MessagingException;
import javax.sql.DataSource;
import org.ow2.petals.bc.sql.DataSources;
import org.ow2.petals.bc.sql.SqlComponent;
import org.ow2.petals.bc.sql.service.SQLParameter;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class SUManager
extends AbstractServiceUnitManager {
    private DataSources dataSources;
    private static final Pattern storedProcedureNamePattern = Pattern.compile("^\\s*[cC][rR][eE][aA][tT][eE]\\s+[oErReEpPlLaAcC\\s]*[pP][rR][oO][cC][eE][dD][uU][rR][eE]\\s+([^\\s\\(]+)");
    private static final Pattern storedProcedureName2Pattern = Pattern.compile("^\\s*([^\\s\\(]+)");
    private static final Pattern paramPattern = Pattern.compile("^\\s*\\({0,1}\\s*([INOUT]{0,5})[@\\w]*\\s*([INOUT]{0,5})[@\\w]*\\s*([^\\(\\s,]+)[\\(\\),0-9]*\\s*([,\\)])");

    public SUManager(AbstractComponent component) {
        super(component);
    }

    public void doDeploy(String serviceUnitName, String suRootPath, Jbi descriptor) throws PEtALSCDKException {
        ServiceUnitDataHandler suDatahandler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
        if (descriptor.getServices().getConsumes().size() != 0) {
            throw new PEtALSCDKException("Consumes section are not supported by this component");
        }
        for (Provides provides : descriptor.getServices().getProvides()) {
            ConfigurationExtensions extensions = suDatahandler.getConfigurationExtensions((Object)provides);
            DataSource dataSource = this.getDataSources().createDataSourceForService(extensions);
            this.getDataSources().addDataSource(provides, dataSource);
            this.logger.info("DataSource for " + provides.getServiceName() + "-" + provides.getEndpointName() + " created");
        }
    }

    protected void doInit(String serviceUnitName, String suRootPath) throws PEtALSCDKException {
        ServiceUnitDataHandler suDataHandler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
        Jbi descriptor = suDataHandler.getDescriptor();
        List providesList = descriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            ConfigurationExtensions extensions = suDataHandler.getConfigurationExtensions((Object)provides);
            try {
                if (extensions.get((Object)"storedProcedureCall") != null) continue;
                String storedProcedure = extensions.get((Object)"storedProcedure");
                if (storedProcedure != null) {
                    this.extractStoredProcedureElements(storedProcedure, storedProcedureNamePattern, extensions, true);
                    try {
                        Connection connection = this.getDataSources().getDataSource(provides).getConnection();
                        Statement statement = connection.createStatement();
                        statement.executeUpdate(storedProcedure);
                        this.logger.info("Stored procedure successfully registered : '" + storedProcedure + "'");
                        continue;
                    }
                    catch (SQLException e) {
                        throw new PEtALSCDKException("Failed to prepare a stored procedure", (Throwable)e);
                    }
                }
                storedProcedure = extensions.get((Object)"storedProcedureSignature");
                if (storedProcedure == null) continue;
                this.extractStoredProcedureElements(storedProcedure, storedProcedureName2Pattern, extensions, false);
            }
            catch (MessagingException e) {
                throw new PEtALSCDKException((Throwable)e);
            }
        }
    }

    protected void doStart(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = ((ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName)).getDescriptor();
        List providesList = descriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            try {
                Connection connection = this.getDataSources().getDataSource(provides).getConnection();
                connection.close();
            }
            catch (SQLException e) {
                throw new PEtALSCDKException("Can not reach the target database", (Throwable)e);
            }
        }
    }

    protected void doShutdown(String serviceUnitName) throws PEtALSCDKException {
        ServiceUnitDataHandler suDataHandler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
        Jbi descriptor = suDataHandler.getDescriptor();
        List providesList = descriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            ConfigurationExtensions extensions = suDataHandler.getConfigurationExtensions((Object)provides);
            String storedProcedure = extensions.get((Object)"storedProcedure");
            if (storedProcedure == null) continue;
            try {
                Connection connection = this.getDataSources().getDataSource(provides).getConnection();
                Statement statement = connection.createStatement();
                statement.executeUpdate(extensions.get((Object)"storedProcedureDrop"));
                this.logger.info("Stored procedure successfully dropped : '" + extensions.get((Object)"storedProcedureDrop") + "'");
            }
            catch (SQLException e) {
                throw new PEtALSCDKException("Failed to drop a stored procedure", (Throwable)e);
            }
        }
    }

    public void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        Jbi descriptor = ((ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName)).getDescriptor();
        List providesList = descriptor.getServices().getProvides();
        for (Provides provides : providesList) {
            DataSource dataSource = this.getDataSources().removeDataSource(provides);
            this.getDataSources().closeDataSource(dataSource);
            this.logger.info("DataSource for " + provides.getServiceName() + "-" + provides.getEndpointName() + " closed");
        }
    }

    private DataSources getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = ((SqlComponent)this.component).getDataSources();
        }
        return this.dataSources;
    }

    private void extractStoredProcedureElements(String storedProcedureDeclaration, Pattern storedProcedureNamepattern, ConfigurationExtensions extensions, boolean buildDropElement) throws PEtALSCDKException, MessagingException {
        StringBuilder storedProcedureCall = new StringBuilder("call ");
        StringBuilder storedProcedureDrop = null;
        Matcher matcher = storedProcedureNamepattern.matcher(storedProcedureDeclaration);
        if (matcher.find()) {
            storedProcedureCall.append(matcher.group(1)).append("(");
            this.logger.finest("Found Stored Procedure name: " + matcher.group(1));
            if (buildDropElement) {
                storedProcedureDrop = new StringBuilder("DROP PROCEDURE ").append(matcher.group(1));
            }
            String trunkatedStoredProcedure = storedProcedureDeclaration.substring(matcher.end());
            short counter = 1;
            boolean isEndParameters = false;
            while (!isEndParameters) {
                matcher = paramPattern.matcher(trunkatedStoredProcedure);
                if (matcher.find()) {
                    String sqlScope = "IN";
                    if ("IN".equals(matcher.group(1)) || "OUT".equals(matcher.group(1)) || "INOUT".equals(matcher.group(1))) {
                        sqlScope = matcher.group(1);
                    } else if ("IN".equals(matcher.group(2)) || "OUT".equals(matcher.group(2)) || "INOUT".equals(matcher.group(2))) {
                        sqlScope = matcher.group(2);
                    }
                    this.logger.finest("Found a parameter with scope: " + sqlScope);
                    this.logger.finest("Found a parameter with type: " + matcher.group(3));
                    SQLParameter sqlParameter = new SQLParameter(matcher.group(3), sqlScope, counter);
                    extensions.put("parameter" + counter, sqlParameter.toString());
                    counter = (short)(counter + 1);
                    storedProcedureCall.append("?,");
                    trunkatedStoredProcedure = trunkatedStoredProcedure.substring(matcher.end());
                }
                if (!matcher.group(4).equals(")")) continue;
                this.logger.finest("Found end of the procedure declaration");
                isEndParameters = true;
            }
        } else {
            throw new PEtALSCDKException("Failed to identify the name of the stored procedure.");
        }
        storedProcedureCall.deleteCharAt(storedProcedureCall.length() - 1);
        storedProcedureCall.append(")");
        extensions.put("storedProcedureCall", storedProcedureCall.toString());
        if (buildDropElement) {
            extensions.put("storedProcedureDrop", storedProcedureDrop.toString());
        }
    }
}

